/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat;

import com.azure.communication.chat.ChatClientBuilder;
import com.azure.communication.chat.ChatThreadAsyncClient;
import com.azure.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.communication.chat.implementation.ChatsImpl;
import com.azure.communication.chat.implementation.converters.ChatErrorConverter;
import com.azure.communication.chat.implementation.converters.CreateChatThreadOptionsConverter;
import com.azure.communication.chat.implementation.converters.CreateChatThreadResultConverter;
import com.azure.communication.chat.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.chat.implementation.models.CreateChatThreadResult;
import com.azure.communication.chat.models.ChatError;
import com.azure.communication.chat.models.ChatErrorResponseException;
import com.azure.communication.chat.models.ChatThreadItem;
import com.azure.communication.chat.models.CreateChatThreadOptions;
import com.azure.communication.chat.models.ListChatThreadsOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ChatClientBuilder.class, isAsync=true)
public final class ChatAsyncClient {
    private final ClientLogger logger = new ClientLogger(ChatAsyncClient.class);
    private final AzureCommunicationChatServiceImpl chatServiceClient;
    private final ChatsImpl chatClient;

    ChatAsyncClient(AzureCommunicationChatServiceImpl chatServiceClient) {
        this.chatServiceClient = chatServiceClient;
        this.chatClient = chatServiceClient.getChats();
    }

    public ChatThreadAsyncClient getChatThreadClient(String chatThreadId) {
        Objects.requireNonNull(chatThreadId, "'chatThreadId' cannot be null.");
        return new ChatThreadAsyncClient(this.chatServiceClient, chatThreadId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<com.azure.communication.chat.models.CreateChatThreadResult> createChatThread(CreateChatThreadOptions options) {
        try {
            Objects.requireNonNull(options, "'options' cannot be null.");
            return FluxUtil.withContext(context -> this.createChatThread(options, (Context)context).flatMap(res -> {
                if (res.getValue() != null) {
                    return Mono.just((Object)((com.azure.communication.chat.models.CreateChatThreadResult)res.getValue()));
                }
                return Mono.empty();
            }));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<com.azure.communication.chat.models.CreateChatThreadResult>> createChatThreadWithResponse(CreateChatThreadOptions options) {
        try {
            Objects.requireNonNull(options, "'options' cannot be null.");
            return FluxUtil.withContext(context -> this.createChatThread(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<com.azure.communication.chat.models.CreateChatThreadResult>> createChatThread(CreateChatThreadOptions options, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatClient.createChatThreadWithResponseAsync(CreateChatThreadOptionsConverter.convert(options), options.getIdempotencyToken(), context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e))).map(result -> new SimpleResponse(result, (Object)CreateChatThreadResultConverter.convert((CreateChatThreadResult)result.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatThreadItem> listChatThreads() {
        ListChatThreadsOptions listThreadsOptions = new ListChatThreadsOptions();
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.chatClient.listChatThreadsSinglePageAsync(listThreadsOptions.getMaxPageSize(), listThreadsOptions.getStartTime(), (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e)))))), nextLink -> FluxUtil.withContext(context -> this.chatClient.listChatThreadsNextSinglePageAsync((String)nextLink, (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e)))))));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatThreadItem> listChatThreads(ListChatThreadsOptions listThreadsOptions) {
        ListChatThreadsOptions serviceListThreadsOptions = listThreadsOptions == null ? new ListChatThreadsOptions() : listThreadsOptions;
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.chatClient.listChatThreadsSinglePageAsync(serviceListThreadsOptions.getMaxPageSize(), serviceListThreadsOptions.getStartTime(), (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e)))))), nextLink -> FluxUtil.withContext(context -> this.chatClient.listChatThreadsNextSinglePageAsync((String)nextLink, (Context)context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)((Object)((Object)e)))))));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<ChatThreadItem> listChatThreads(ListChatThreadsOptions listThreadsOptions, Context context) {
        Context serviceContext = context == null ? Context.NONE : context;
        ListChatThreadsOptions serviceListThreadsOptions = listThreadsOptions == null ? new ListChatThreadsOptions() : listThreadsOptions;
        try {
            return this.chatClient.listChatThreadsAsync(serviceListThreadsOptions.getMaxPageSize(), serviceListThreadsOptions.getStartTime(), serviceContext);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteChatThread(String chatThreadId) {
        try {
            Objects.requireNonNull(chatThreadId, "'chatThreadId' cannot be null.");
            return FluxUtil.withContext(context -> this.deleteChatThread(chatThreadId, (Context)context)).flatMap(res -> Mono.empty());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteChatThreadWithResponse(String chatThreadId) {
        try {
            Objects.requireNonNull(chatThreadId, "'chatThreadId' cannot be null.");
            return FluxUtil.withContext(context -> this.deleteChatThread(chatThreadId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteChatThread(String chatThreadId, Context context) {
        context = context == null ? Context.NONE : context;
        try {
            return this.chatClient.deleteChatThreadWithResponseAsync(chatThreadId, context).onErrorMap(CommunicationErrorResponseException.class, e -> this.translateException((CommunicationErrorResponseException)((Object)e)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private ChatErrorResponseException translateException(CommunicationErrorResponseException exception) {
        ChatError error = null;
        if (exception.getValue() != null) {
            error = ChatErrorConverter.convert(exception.getValue().getError());
        }
        return new ChatErrorResponseException(exception.getMessage(), exception.getResponse(), error);
    }
}

