/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat;

import com.azure.communication.chat.ChatAsyncClient;
import com.azure.communication.chat.ChatClient;
import com.azure.communication.chat.ChatServiceVersion;
import com.azure.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.communication.chat.implementation.AzureCommunicationChatServiceImplBuilder;
import com.azure.communication.chat.implementation.CommunicationBearerTokenCredential;
import com.azure.communication.common.CommunicationTokenCredential;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ChatAsyncClient.class, ChatClient.class})
public final class ChatClientBuilder {
    private String endpoint;
    private HttpClient httpClient;
    private CommunicationTokenCredential communicationTokenCredential;
    private final List<HttpPipelinePolicy> customPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions = new HttpLogOptions();
    private HttpPipeline httpPipeline;
    private Configuration configuration;
    private ClientOptions clientOptions;
    private RetryPolicy retryPolicy = new RetryPolicy();
    private static final String APP_CONFIG_PROPERTIES = "azure-communication-chat.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";

    public ChatClientBuilder endpoint(String endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        return this;
    }

    public ChatClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
        return this;
    }

    public ChatClientBuilder credential(CommunicationTokenCredential communicationTokenCredential) {
        this.communicationTokenCredential = Objects.requireNonNull(communicationTokenCredential, "'communicationTokenCredential' cannot be null.");
        return this;
    }

    public ChatClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ChatClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.customPolicies.add(Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null."));
        return this;
    }

    public ChatClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
        return this;
    }

    public ChatClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public ChatClientBuilder serviceVersion(ChatServiceVersion version) {
        return this;
    }

    public ChatClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }

    public ChatClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ChatClient buildClient() {
        ChatAsyncClient asyncClient = this.buildAsyncClient();
        return new ChatClient(asyncClient);
    }

    public ChatAsyncClient buildAsyncClient() {
        AzureCommunicationChatServiceImpl internalClient = this.createInternalClient();
        return new ChatAsyncClient(internalClient);
    }

    private AzureCommunicationChatServiceImpl createInternalClient() {
        HttpPipeline pipeline;
        Objects.requireNonNull(this.endpoint);
        if (this.httpPipeline != null) {
            pipeline = this.httpPipeline;
        } else {
            Objects.requireNonNull(this.communicationTokenCredential);
            CommunicationBearerTokenCredential tokenCredential = new CommunicationBearerTokenCredential(this.communicationTokenCredential);
            pipeline = this.createHttpPipeline(this.httpClient, (HttpPipelinePolicy)new BearerTokenAuthenticationPolicy((TokenCredential)tokenCredential, new String[]{""}), this.customPolicies);
        }
        AzureCommunicationChatServiceImplBuilder clientBuilder = new AzureCommunicationChatServiceImplBuilder().endpoint(this.endpoint).pipeline(pipeline);
        return clientBuilder.buildClient();
    }

    private HttpPipeline createHttpPipeline(HttpClient httpClient, HttpPipelinePolicy authorizationPolicy, List<HttpPipelinePolicy> additionalPolicies) {
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(this.getUserAgentPolicy());
        policies.add(new RequestIdPolicy());
        policies.add(this.retryPolicy);
        policies.add(new CookiePolicy());
        policies.add(authorizationPolicy);
        policies.add(new HttpLoggingPolicy(this.logOptions));
        if (additionalPolicies != null && additionalPolicies.size() > 0) {
            policies.addAll(additionalPolicies);
        }
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }

    private UserAgentPolicy getUserAgentPolicy() {
        Map properties = CoreUtils.getProperties((String)APP_CONFIG_PROPERTIES);
        String clientName = properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = this.logOptions.getApplicationId();
        if (this.clientOptions != null) {
            applicationId = this.clientOptions.getApplicationId();
        }
        return new UserAgentPolicy(applicationId, clientName, clientVersion, this.configuration);
    }
}

