/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat;

import com.azure.communication.chat.ChatThreadAsyncClient;
import com.azure.communication.chat.ChatThreadClientBuilder;
import com.azure.communication.chat.models.AddChatParticipantsResult;
import com.azure.communication.chat.models.ChatMessage;
import com.azure.communication.chat.models.ChatMessageReadReceipt;
import com.azure.communication.chat.models.ChatParticipant;
import com.azure.communication.chat.models.ChatThreadProperties;
import com.azure.communication.chat.models.ListChatMessagesOptions;
import com.azure.communication.chat.models.ListParticipantsOptions;
import com.azure.communication.chat.models.ListReadReceiptOptions;
import com.azure.communication.chat.models.SendChatMessageOptions;
import com.azure.communication.chat.models.SendChatMessageResult;
import com.azure.communication.chat.models.TypingNotificationOptions;
import com.azure.communication.chat.models.UpdateChatMessageOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;

@ServiceClient(builder=ChatThreadClientBuilder.class, isAsync=false)
public final class ChatThreadClient {
    private final ClientLogger logger = new ClientLogger(ChatThreadClient.class);
    private final ChatThreadAsyncClient client;
    private final String chatThreadId;

    ChatThreadClient(ChatThreadAsyncClient client) {
        this.client = client;
        this.chatThreadId = client.getChatThreadId();
    }

    public String getChatThreadId() {
        return this.chatThreadId;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateTopic(String topic) {
        this.client.updateTopic(topic).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateTopicWithResponse(String topic, Context context) {
        return (Response)this.client.updateTopic(topic, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddChatParticipantsResult addParticipants(Iterable<ChatParticipant> participants) {
        return (AddChatParticipantsResult)this.client.addParticipants(participants).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddChatParticipantsResult> addParticipantsWithResponse(Iterable<ChatParticipant> participants, Context context) {
        return (Response)this.client.addParticipants(participants, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void addParticipant(ChatParticipant participant) {
        this.client.addParticipant(participant).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> addParticipantWithResponse(ChatParticipant participant, Context context) {
        return (Response)this.client.addParticipantWithResponse(participant, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeParticipantWithResponse(CommunicationIdentifier identifier, Context context) {
        return (Response)this.client.removeParticipant(identifier, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeParticipant(CommunicationIdentifier identifier) {
        this.client.removeParticipant(identifier).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatParticipant> listParticipants() {
        return new PagedIterable(this.client.listParticipants());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatParticipant> listParticipants(ListParticipantsOptions listParticipantsOptions, Context context) {
        return new PagedIterable(this.client.listParticipants(listParticipantsOptions, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SendChatMessageResult> sendMessageWithResponse(SendChatMessageOptions options, Context context) {
        return (Response)this.client.sendMessage(options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendChatMessageResult sendMessage(SendChatMessageOptions options) {
        return (SendChatMessageResult)this.client.sendMessage(options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ChatMessage> getMessageWithResponse(String chatMessageId, Context context) {
        return (Response)this.client.getMessage(chatMessageId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ChatMessage getMessage(String chatMessageId) {
        return (ChatMessage)this.client.getMessage(chatMessageId).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatMessage> listMessages() {
        return new PagedIterable(this.client.listMessages());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatMessage> listMessages(ListChatMessagesOptions listMessagesOptions, Context context) {
        return new PagedIterable(this.client.listMessages(listMessagesOptions, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateMessageWithResponse(String chatMessageId, UpdateChatMessageOptions options, Context context) {
        return (Response)this.client.updateMessage(chatMessageId, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateMessage(String chatMessageId, UpdateChatMessageOptions options) {
        this.client.updateMessage(chatMessageId, options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteMessageWithResponse(String chatMessageId, Context context) {
        return (Response)this.client.deleteMessage(chatMessageId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteMessage(String chatMessageId) {
        this.client.deleteMessage(chatMessageId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendTypingNotificationWithResponse(Context context) {
        TypingNotificationOptions options = new TypingNotificationOptions();
        return (Response)this.client.sendTypingNotification(options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendTypingNotification() {
        this.client.sendTypingNotification().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendTypingNotificationWithResponse(TypingNotificationOptions options, Context context) {
        return (Response)this.client.sendTypingNotification(options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendTypingNotification(TypingNotificationOptions options) {
        this.client.sendTypingNotification(options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendReadReceiptWithResponse(String chatMessageId, Context context) {
        return (Response)this.client.sendReadReceipt(chatMessageId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendReadReceipt(String chatMessageId) {
        this.client.sendReadReceipt(chatMessageId).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatMessageReadReceipt> listReadReceipts() {
        return new PagedIterable(this.client.listReadReceipts());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatMessageReadReceipt> listReadReceipts(ListReadReceiptOptions listReadReceiptOptions, Context context) {
        return new PagedIterable(this.client.listReadReceipts(listReadReceiptOptions, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ChatThreadProperties getProperties() {
        return (ChatThreadProperties)this.client.getProperties().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ChatThreadProperties> getPropertiesWithResponse(Context context) {
        return (Response)this.client.getProperties(context).block();
    }
}

