/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation;

import com.azure.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.communication.chat.implementation.models.AddChatParticipantsOptions;
import com.azure.communication.chat.implementation.models.AddChatParticipantsResult;
import com.azure.communication.chat.implementation.models.ChatMessage;
import com.azure.communication.chat.implementation.models.ChatMessageReadReceipt;
import com.azure.communication.chat.implementation.models.ChatMessageReadReceiptsCollection;
import com.azure.communication.chat.implementation.models.ChatMessagesCollection;
import com.azure.communication.chat.implementation.models.ChatParticipant;
import com.azure.communication.chat.implementation.models.ChatParticipantsCollection;
import com.azure.communication.chat.implementation.models.ChatThreadProperties;
import com.azure.communication.chat.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.chat.implementation.models.SendReadReceiptRequest;
import com.azure.communication.chat.models.SendChatMessageOptions;
import com.azure.communication.chat.models.SendChatMessageResult;
import com.azure.communication.chat.models.TypingNotificationOptions;
import com.azure.communication.chat.models.UpdateChatMessageOptions;
import com.azure.communication.chat.models.UpdateChatThreadOptions;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class ChatThreadsImpl {
    private final ChatThreadsService service;
    private final AzureCommunicationChatServiceImpl client;

    ChatThreadsImpl(AzureCommunicationChatServiceImpl client) {
        this.service = (ChatThreadsService)RestProxy.create(ChatThreadsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatMessageReadReceipt>> listChatReadReceiptsSinglePageAsync(String chatThreadId, Integer maxPageSize, Integer skip) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listChatReadReceipts(this.client.getEndpoint(), chatThreadId, maxPageSize, skip, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatMessageReadReceiptsCollection)res.getValue()).getValue(), ((ChatMessageReadReceiptsCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatMessageReadReceipt>> listChatReadReceiptsSinglePageAsync(String chatThreadId, Integer maxPageSize, Integer skip, Context context) {
        String accept = "application/json";
        return this.service.listChatReadReceipts(this.client.getEndpoint(), chatThreadId, maxPageSize, skip, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatMessageReadReceiptsCollection)res.getValue()).getValue(), ((ChatMessageReadReceiptsCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatMessageReadReceipt> listChatReadReceiptsAsync(String chatThreadId, Integer maxPageSize, Integer skip) {
        return new PagedFlux(() -> this.listChatReadReceiptsSinglePageAsync(chatThreadId, maxPageSize, skip), nextLink -> this.listChatReadReceiptsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatMessageReadReceipt> listChatReadReceiptsAsync(String chatThreadId) {
        Integer maxPageSize = null;
        Integer skip = null;
        return new PagedFlux(() -> this.listChatReadReceiptsSinglePageAsync(chatThreadId, maxPageSize, skip), nextLink -> this.listChatReadReceiptsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatMessageReadReceipt> listChatReadReceiptsAsync(String chatThreadId, Integer maxPageSize, Integer skip, Context context) {
        return new PagedFlux(() -> this.listChatReadReceiptsSinglePageAsync(chatThreadId, maxPageSize, skip, context), nextLink -> this.listChatReadReceiptsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatMessageReadReceipt> listChatReadReceipts(String chatThreadId, Integer maxPageSize, Integer skip) {
        return new PagedIterable(this.listChatReadReceiptsAsync(chatThreadId, maxPageSize, skip));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatMessageReadReceipt> listChatReadReceipts(String chatThreadId) {
        Integer maxPageSize = null;
        Integer skip = null;
        return new PagedIterable(this.listChatReadReceiptsAsync(chatThreadId, maxPageSize, skip));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatMessageReadReceipt> listChatReadReceipts(String chatThreadId, Integer maxPageSize, Integer skip, Context context) {
        return new PagedIterable(this.listChatReadReceiptsAsync(chatThreadId, maxPageSize, skip, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendChatReadReceiptWithResponseAsync(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.sendChatReadReceipt(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendReadReceiptRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendChatReadReceiptWithResponseAsync(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest, Context context) {
        String accept = "application/json";
        return this.service.sendChatReadReceipt(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendReadReceiptRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendChatReadReceiptAsync(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest) {
        return this.sendChatReadReceiptWithResponseAsync(chatThreadId, sendReadReceiptRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendChatReadReceiptAsync(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest, Context context) {
        return this.sendChatReadReceiptWithResponseAsync(chatThreadId, sendReadReceiptRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendChatReadReceipt(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest) {
        this.sendChatReadReceiptAsync(chatThreadId, sendReadReceiptRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendChatReadReceiptWithResponse(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest, Context context) {
        return (Response)this.sendChatReadReceiptWithResponseAsync(chatThreadId, sendReadReceiptRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SendChatMessageResult>> sendChatMessageWithResponseAsync(String chatThreadId, SendChatMessageOptions sendChatMessageRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.sendChatMessage(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendChatMessageRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SendChatMessageResult>> sendChatMessageWithResponseAsync(String chatThreadId, SendChatMessageOptions sendChatMessageRequest, Context context) {
        String accept = "application/json";
        return this.service.sendChatMessage(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendChatMessageRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendChatMessageResult> sendChatMessageAsync(String chatThreadId, SendChatMessageOptions sendChatMessageRequest) {
        return this.sendChatMessageWithResponseAsync(chatThreadId, sendChatMessageRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SendChatMessageResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendChatMessageResult> sendChatMessageAsync(String chatThreadId, SendChatMessageOptions sendChatMessageRequest, Context context) {
        return this.sendChatMessageWithResponseAsync(chatThreadId, sendChatMessageRequest, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SendChatMessageResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendChatMessageResult sendChatMessage(String chatThreadId, SendChatMessageOptions sendChatMessageRequest) {
        return (SendChatMessageResult)this.sendChatMessageAsync(chatThreadId, sendChatMessageRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SendChatMessageResult> sendChatMessageWithResponse(String chatThreadId, SendChatMessageOptions sendChatMessageRequest, Context context) {
        return (Response)this.sendChatMessageWithResponseAsync(chatThreadId, sendChatMessageRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatMessage>> listChatMessagesSinglePageAsync(String chatThreadId, Integer maxPageSize, OffsetDateTime startTime) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listChatMessages(this.client.getEndpoint(), chatThreadId, maxPageSize, startTime, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatMessagesCollection)res.getValue()).getValue(), ((ChatMessagesCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatMessage>> listChatMessagesSinglePageAsync(String chatThreadId, Integer maxPageSize, OffsetDateTime startTime, Context context) {
        String accept = "application/json";
        return this.service.listChatMessages(this.client.getEndpoint(), chatThreadId, maxPageSize, startTime, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatMessagesCollection)res.getValue()).getValue(), ((ChatMessagesCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatMessage> listChatMessagesAsync(String chatThreadId, Integer maxPageSize, OffsetDateTime startTime) {
        return new PagedFlux(() -> this.listChatMessagesSinglePageAsync(chatThreadId, maxPageSize, startTime), nextLink -> this.listChatMessagesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatMessage> listChatMessagesAsync(String chatThreadId) {
        Integer maxPageSize = null;
        OffsetDateTime startTime = null;
        return new PagedFlux(() -> this.listChatMessagesSinglePageAsync(chatThreadId, maxPageSize, startTime), nextLink -> this.listChatMessagesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatMessage> listChatMessagesAsync(String chatThreadId, Integer maxPageSize, OffsetDateTime startTime, Context context) {
        return new PagedFlux(() -> this.listChatMessagesSinglePageAsync(chatThreadId, maxPageSize, startTime, context), nextLink -> this.listChatMessagesNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatMessage> listChatMessages(String chatThreadId, Integer maxPageSize, OffsetDateTime startTime) {
        return new PagedIterable(this.listChatMessagesAsync(chatThreadId, maxPageSize, startTime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatMessage> listChatMessages(String chatThreadId) {
        Integer maxPageSize = null;
        OffsetDateTime startTime = null;
        return new PagedIterable(this.listChatMessagesAsync(chatThreadId, maxPageSize, startTime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatMessage> listChatMessages(String chatThreadId, Integer maxPageSize, OffsetDateTime startTime, Context context) {
        return new PagedIterable(this.listChatMessagesAsync(chatThreadId, maxPageSize, startTime, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ChatMessage>> getChatMessageWithResponseAsync(String chatThreadId, String chatMessageId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ChatMessage>> getChatMessageWithResponseAsync(String chatThreadId, String chatMessageId, Context context) {
        String accept = "application/json";
        return this.service.getChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ChatMessage> getChatMessageAsync(String chatThreadId, String chatMessageId) {
        return this.getChatMessageWithResponseAsync(chatThreadId, chatMessageId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ChatMessage)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ChatMessage> getChatMessageAsync(String chatThreadId, String chatMessageId, Context context) {
        return this.getChatMessageWithResponseAsync(chatThreadId, chatMessageId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ChatMessage)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ChatMessage getChatMessage(String chatThreadId, String chatMessageId) {
        return (ChatMessage)this.getChatMessageAsync(chatThreadId, chatMessageId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ChatMessage> getChatMessageWithResponse(String chatThreadId, String chatMessageId, Context context) {
        return (Response)this.getChatMessageWithResponseAsync(chatThreadId, chatMessageId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateChatMessageWithResponseAsync(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), updateChatMessageRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateChatMessageWithResponseAsync(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest, Context context) {
        String accept = "application/json";
        return this.service.updateChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), updateChatMessageRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateChatMessageAsync(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest) {
        return this.updateChatMessageWithResponseAsync(chatThreadId, chatMessageId, updateChatMessageRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateChatMessageAsync(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest, Context context) {
        return this.updateChatMessageWithResponseAsync(chatThreadId, chatMessageId, updateChatMessageRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateChatMessage(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest) {
        this.updateChatMessageAsync(chatThreadId, chatMessageId, updateChatMessageRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateChatMessageWithResponse(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest, Context context) {
        return (Response)this.updateChatMessageWithResponseAsync(chatThreadId, chatMessageId, updateChatMessageRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteChatMessageWithResponseAsync(String chatThreadId, String chatMessageId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteChatMessageWithResponseAsync(String chatThreadId, String chatMessageId, Context context) {
        String accept = "application/json";
        return this.service.deleteChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteChatMessageAsync(String chatThreadId, String chatMessageId) {
        return this.deleteChatMessageWithResponseAsync(chatThreadId, chatMessageId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteChatMessageAsync(String chatThreadId, String chatMessageId, Context context) {
        return this.deleteChatMessageWithResponseAsync(chatThreadId, chatMessageId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteChatMessage(String chatThreadId, String chatMessageId) {
        this.deleteChatMessageAsync(chatThreadId, chatMessageId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteChatMessageWithResponse(String chatThreadId, String chatMessageId, Context context) {
        return (Response)this.deleteChatMessageWithResponseAsync(chatThreadId, chatMessageId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatParticipant>> listChatParticipantsSinglePageAsync(String chatThreadId, Integer maxPageSize, Integer skip) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listChatParticipants(this.client.getEndpoint(), chatThreadId, maxPageSize, skip, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatParticipantsCollection)res.getValue()).getValue(), ((ChatParticipantsCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatParticipant>> listChatParticipantsSinglePageAsync(String chatThreadId, Integer maxPageSize, Integer skip, Context context) {
        String accept = "application/json";
        return this.service.listChatParticipants(this.client.getEndpoint(), chatThreadId, maxPageSize, skip, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatParticipantsCollection)res.getValue()).getValue(), ((ChatParticipantsCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatParticipant> listChatParticipantsAsync(String chatThreadId, Integer maxPageSize, Integer skip) {
        return new PagedFlux(() -> this.listChatParticipantsSinglePageAsync(chatThreadId, maxPageSize, skip), nextLink -> this.listChatParticipantsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatParticipant> listChatParticipantsAsync(String chatThreadId) {
        Integer maxPageSize = null;
        Integer skip = null;
        return new PagedFlux(() -> this.listChatParticipantsSinglePageAsync(chatThreadId, maxPageSize, skip), nextLink -> this.listChatParticipantsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatParticipant> listChatParticipantsAsync(String chatThreadId, Integer maxPageSize, Integer skip, Context context) {
        return new PagedFlux(() -> this.listChatParticipantsSinglePageAsync(chatThreadId, maxPageSize, skip, context), nextLink -> this.listChatParticipantsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatParticipant> listChatParticipants(String chatThreadId, Integer maxPageSize, Integer skip) {
        return new PagedIterable(this.listChatParticipantsAsync(chatThreadId, maxPageSize, skip));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatParticipant> listChatParticipants(String chatThreadId) {
        Integer maxPageSize = null;
        Integer skip = null;
        return new PagedIterable(this.listChatParticipantsAsync(chatThreadId, maxPageSize, skip));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatParticipant> listChatParticipants(String chatThreadId, Integer maxPageSize, Integer skip, Context context) {
        return new PagedIterable(this.listChatParticipantsAsync(chatThreadId, maxPageSize, skip, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeChatParticipantWithResponseAsync(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeChatParticipant(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), participantCommunicationIdentifier, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeChatParticipantWithResponseAsync(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier, Context context) {
        String accept = "application/json";
        return this.service.removeChatParticipant(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), participantCommunicationIdentifier, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeChatParticipantAsync(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier) {
        return this.removeChatParticipantWithResponseAsync(chatThreadId, participantCommunicationIdentifier).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeChatParticipantAsync(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier, Context context) {
        return this.removeChatParticipantWithResponseAsync(chatThreadId, participantCommunicationIdentifier, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeChatParticipant(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier) {
        this.removeChatParticipantAsync(chatThreadId, participantCommunicationIdentifier).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeChatParticipantWithResponse(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier, Context context) {
        return (Response)this.removeChatParticipantWithResponseAsync(chatThreadId, participantCommunicationIdentifier, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddChatParticipantsResult>> addChatParticipantsWithResponseAsync(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addChatParticipants(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), addChatParticipantsRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddChatParticipantsResult>> addChatParticipantsWithResponseAsync(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest, Context context) {
        String accept = "application/json";
        return this.service.addChatParticipants(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), addChatParticipantsRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddChatParticipantsResult> addChatParticipantsAsync(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest) {
        return this.addChatParticipantsWithResponseAsync(chatThreadId, addChatParticipantsRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AddChatParticipantsResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddChatParticipantsResult> addChatParticipantsAsync(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest, Context context) {
        return this.addChatParticipantsWithResponseAsync(chatThreadId, addChatParticipantsRequest, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AddChatParticipantsResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddChatParticipantsResult addChatParticipants(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest) {
        return (AddChatParticipantsResult)this.addChatParticipantsAsync(chatThreadId, addChatParticipantsRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddChatParticipantsResult> addChatParticipantsWithResponse(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest, Context context) {
        return (Response)this.addChatParticipantsWithResponseAsync(chatThreadId, addChatParticipantsRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateChatThreadPropertiesWithResponseAsync(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateChatThreadProperties(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), updateChatThreadRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateChatThreadPropertiesWithResponseAsync(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest, Context context) {
        String accept = "application/json";
        return this.service.updateChatThreadProperties(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), updateChatThreadRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateChatThreadPropertiesAsync(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest) {
        return this.updateChatThreadPropertiesWithResponseAsync(chatThreadId, updateChatThreadRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateChatThreadPropertiesAsync(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest, Context context) {
        return this.updateChatThreadPropertiesWithResponseAsync(chatThreadId, updateChatThreadRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateChatThreadProperties(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest) {
        this.updateChatThreadPropertiesAsync(chatThreadId, updateChatThreadRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateChatThreadPropertiesWithResponse(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest, Context context) {
        return (Response)this.updateChatThreadPropertiesWithResponseAsync(chatThreadId, updateChatThreadRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ChatThreadProperties>> getChatThreadPropertiesWithResponseAsync(String chatThreadId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getChatThreadProperties(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ChatThreadProperties>> getChatThreadPropertiesWithResponseAsync(String chatThreadId, Context context) {
        String accept = "application/json";
        return this.service.getChatThreadProperties(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ChatThreadProperties> getChatThreadPropertiesAsync(String chatThreadId) {
        return this.getChatThreadPropertiesWithResponseAsync(chatThreadId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ChatThreadProperties)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ChatThreadProperties> getChatThreadPropertiesAsync(String chatThreadId, Context context) {
        return this.getChatThreadPropertiesWithResponseAsync(chatThreadId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ChatThreadProperties)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ChatThreadProperties getChatThreadProperties(String chatThreadId) {
        return (ChatThreadProperties)this.getChatThreadPropertiesAsync(chatThreadId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ChatThreadProperties> getChatThreadPropertiesWithResponse(String chatThreadId, Context context) {
        return (Response)this.getChatThreadPropertiesWithResponseAsync(chatThreadId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendTypingNotificationWithResponseAsync(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.sendTypingNotification(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendTypingNotificationRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendTypingNotificationWithResponseAsync(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest, Context context) {
        String accept = "application/json";
        return this.service.sendTypingNotification(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendTypingNotificationRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendTypingNotificationAsync(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest) {
        return this.sendTypingNotificationWithResponseAsync(chatThreadId, sendTypingNotificationRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendTypingNotificationAsync(String chatThreadId) {
        TypingNotificationOptions sendTypingNotificationRequest = null;
        return this.sendTypingNotificationWithResponseAsync(chatThreadId, sendTypingNotificationRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendTypingNotificationAsync(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest, Context context) {
        return this.sendTypingNotificationWithResponseAsync(chatThreadId, sendTypingNotificationRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendTypingNotification(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest) {
        this.sendTypingNotificationAsync(chatThreadId, sendTypingNotificationRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendTypingNotification(String chatThreadId) {
        TypingNotificationOptions sendTypingNotificationRequest = null;
        this.sendTypingNotificationAsync(chatThreadId, sendTypingNotificationRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendTypingNotificationWithResponse(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest, Context context) {
        return (Response)this.sendTypingNotificationWithResponseAsync(chatThreadId, sendTypingNotificationRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatMessageReadReceipt>> listChatReadReceiptsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listChatReadReceiptsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatMessageReadReceiptsCollection)res.getValue()).getValue(), ((ChatMessageReadReceiptsCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatMessageReadReceipt>> listChatReadReceiptsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listChatReadReceiptsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatMessageReadReceiptsCollection)res.getValue()).getValue(), ((ChatMessageReadReceiptsCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatMessage>> listChatMessagesNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listChatMessagesNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatMessagesCollection)res.getValue()).getValue(), ((ChatMessagesCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatMessage>> listChatMessagesNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listChatMessagesNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatMessagesCollection)res.getValue()).getValue(), ((ChatMessagesCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatParticipant>> listChatParticipantsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listChatParticipantsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatParticipantsCollection)res.getValue()).getValue(), ((ChatParticipantsCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatParticipant>> listChatParticipantsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listChatParticipantsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatParticipantsCollection)res.getValue()).getValue(), ((ChatParticipantsCollection)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCh")
    private static interface ChatThreadsService {
        @Get(value="/chat/threads/{chatThreadId}/readReceipts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<ChatMessageReadReceiptsCollection>> listChatReadReceipts(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="maxPageSize") Integer var3, @QueryParam(value="skip") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/chat/threads/{chatThreadId}/readReceipts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> sendChatReadReceipt(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SendReadReceiptRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/chat/threads/{chatThreadId}/messages")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<SendChatMessageResult>> sendChatMessage(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SendChatMessageOptions var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/chat/threads/{chatThreadId}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<ChatMessagesCollection>> listChatMessages(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="maxPageSize") Integer var3, @QueryParam(value="startTime") OffsetDateTime var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/chat/threads/{chatThreadId}/messages/{chatMessageId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<ChatMessage>> getChatMessage(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @PathParam(value="chatMessageId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/chat/threads/{chatThreadId}/messages/{chatMessageId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> updateChatMessage(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @PathParam(value="chatMessageId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/merge-patch+json") UpdateChatMessageOptions var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/chat/threads/{chatThreadId}/messages/{chatMessageId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> deleteChatMessage(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @PathParam(value="chatMessageId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/chat/threads/{chatThreadId}/participants")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<ChatParticipantsCollection>> listChatParticipants(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="maxPageSize") Integer var3, @QueryParam(value="skip") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/chat/threads/{chatThreadId}/participants/:remove")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> removeChatParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CommunicationIdentifierModel var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/chat/threads/{chatThreadId}/participants/:add")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<AddChatParticipantsResult>> addChatParticipants(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") AddChatParticipantsOptions var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Patch(value="/chat/threads/{chatThreadId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> updateChatThreadProperties(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/merge-patch+json") UpdateChatThreadOptions var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/chat/threads/{chatThreadId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<ChatThreadProperties>> getChatThreadProperties(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/chat/threads/{chatThreadId}/typing")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> sendTypingNotification(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") TypingNotificationOptions var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<ChatMessageReadReceiptsCollection>> listChatReadReceiptsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<ChatMessagesCollection>> listChatMessagesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<ChatParticipantsCollection>> listChatParticipantsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

