/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.developer.loadtesting.LoadTestAdministrationClientBuilder;
import com.azure.developer.loadtesting.implementation.LoadTestAdministrationsImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import reactor.core.publisher.Mono;

@ServiceClient(builder=LoadTestAdministrationClientBuilder.class, isAsync=true)
public final class LoadTestAdministrationAsyncClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final LoadTestAdministrationsImpl serviceClient;

    LoadTestAdministrationAsyncClient(LoadTestAdministrationsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateServerMetricsConfigWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateServerMetricsConfigWithResponseAsync(testId, body, requestOptions);
    }

    private Mono<PollResponse<BinaryData>> getValidationStatus(BinaryData fileBinary) {
        LongRunningOperationStatus lroStatus;
        String fileType;
        String validationStatus;
        try {
            JsonNode file = OBJECT_MAPPER.readTree(fileBinary.toString());
            validationStatus = file.get("validationStatus").asText();
            fileType = file.get("fileType").asText();
        }
        catch (JsonProcessingException e) {
            return Mono.error((Throwable)new RuntimeException("Encountered exception while retrieving validation status", e));
        }
        switch (validationStatus) {
            case "VALIDATION_NOT_REQUIRED": 
            case "VALIDATION_SUCCESS": {
                lroStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case "VALIDATION_FAILURE": {
                lroStatus = LongRunningOperationStatus.FAILED;
                break;
            }
            case "VALIDATION_INITIATED": {
                lroStatus = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case "NOT_VALIDATED": {
                if ("JMX_FILE".equalsIgnoreCase(fileType)) {
                    lroStatus = LongRunningOperationStatus.NOT_STARTED;
                    break;
                }
                lroStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            default: {
                lroStatus = LongRunningOperationStatus.NOT_STARTED;
            }
        }
        return Mono.just((Object)new PollResponse(lroStatus, (Object)fileBinary));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginUploadTestFile(String testId, String fileName, BinaryData body, RequestOptions fileUploadRequestOptions) {
        RequestOptions defaultRequestOptions = new RequestOptions();
        if (fileUploadRequestOptions != null) {
            defaultRequestOptions.setContext(fileUploadRequestOptions.getContext());
        }
        return new PollerFlux(Duration.ofSeconds(2L), context -> {
            Mono fileMono = this.uploadTestFileWithResponse(testId, fileName, body, fileUploadRequestOptions).flatMap(FluxUtil::toMono);
            Mono fileValidationPollRespMono = fileMono.flatMap(fileBinaryData -> this.getValidationStatus((BinaryData)fileBinaryData));
            return fileValidationPollRespMono.flatMap(fileValidationPollResp -> Mono.just((Object)((BinaryData)fileValidationPollResp.getValue())));
        }, context -> {
            Mono fileMono = this.getTestFileWithResponse(testId, fileName, defaultRequestOptions).flatMap(FluxUtil::toMono);
            return fileMono.flatMap(fileBinaryData -> this.getValidationStatus((BinaryData)fileBinaryData));
        }, (activationResponse, context) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), context -> this.getTestFileWithResponse(testId, fileName, defaultRequestOptions).flatMap(FluxUtil::toMono));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTestFiles(String testId, RequestOptions requestOptions) {
        return this.serviceClient.listTestFilesAsync(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateTestWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestWithResponseAsync(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTestWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestWithResponseAsync(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getTestWithResponseAsync(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTests(RequestOptions requestOptions) {
        return this.serviceClient.listTestsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> uploadTestFileWithResponse(String testId, String fileName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.uploadTestFileWithResponseAsync(testId, fileName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestFileWithResponse(String testId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.getTestFileWithResponseAsync(testId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTestFileWithResponse(String testId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestFileWithResponseAsync(testId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateAppComponentsWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateAppComponentsWithResponseAsync(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAppComponentsWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getAppComponentsWithResponseAsync(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getServerMetricsConfigWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getServerMetricsConfigWithResponseAsync(testId, requestOptions);
    }
}

