/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.developer.loadtesting.LoadTestAdministrationAsyncClient;
import com.azure.developer.loadtesting.LoadTestAdministrationClientBuilder;

@ServiceClient(builder=LoadTestAdministrationClientBuilder.class)
public final class LoadTestAdministrationClient {
    private final LoadTestAdministrationAsyncClient client;

    LoadTestAdministrationClient(LoadTestAdministrationAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateServerMetricsConfigWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return (Response)this.client.createOrUpdateServerMetricsConfigWithResponse(testId, body, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginUploadTestFile(String testId, String fileName, BinaryData body, RequestOptions fileUploadRequestOptions) {
        PollerFlux<BinaryData, BinaryData> asyncPoller = this.client.beginUploadTestFile(testId, fileName, body, fileUploadRequestOptions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTestFiles(String testId, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listTestFiles(testId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateTestWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return (Response)this.client.createOrUpdateTestWithResponse(testId, body, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestWithResponse(String testId, RequestOptions requestOptions) {
        return (Response)this.client.deleteTestWithResponse(testId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestWithResponse(String testId, RequestOptions requestOptions) {
        return (Response)this.client.getTestWithResponse(testId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTests(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listTests(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> uploadTestFileWithResponse(String testId, String fileName, BinaryData body, RequestOptions requestOptions) {
        return (Response)this.client.uploadTestFileWithResponse(testId, fileName, body, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestFileWithResponse(String testId, String fileName, RequestOptions requestOptions) {
        return (Response)this.client.getTestFileWithResponse(testId, fileName, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestFileWithResponse(String testId, String fileName, RequestOptions requestOptions) {
        return (Response)this.client.deleteTestFileWithResponse(testId, fileName, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateAppComponentsWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return (Response)this.client.createOrUpdateAppComponentsWithResponse(testId, body, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAppComponentsWithResponse(String testId, RequestOptions requestOptions) {
        return (Response)this.client.getAppComponentsWithResponse(testId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getServerMetricsConfigWithResponse(String testId, RequestOptions requestOptions) {
        return (Response)this.client.getServerMetricsConfigWithResponse(testId, requestOptions).block();
    }
}

