/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.developer.loadtesting.LoadTestRunAsyncClient;
import com.azure.developer.loadtesting.LoadTestRunClientBuilder;

@ServiceClient(builder=LoadTestRunClientBuilder.class)
public final class LoadTestRunClient {
    private final LoadTestRunAsyncClient client;

    LoadTestRunClient(LoadTestRunAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateServerMetricsConfigWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return (Response)this.client.createOrUpdateServerMetricsConfigWithResponse(testRunId, body, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginTestRun(String testRunId, BinaryData body, RequestOptions testRunRequestOptions) {
        PollerFlux<BinaryData, BinaryData> asyncPoller = this.client.beginTestRun(testRunId, body, testRunRequestOptions);
        return asyncPoller.getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateAppComponentsWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return (Response)this.client.createOrUpdateAppComponentsWithResponse(testRunId, body, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMetrics(String testRunId, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listMetrics(testRunId, metricName, metricNamespace, timespan, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMetricDimensionValues(String testRunId, String name, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listMetricDimensionValues(testRunId, name, metricName, metricNamespace, timespan, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAppComponentsWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.client.getAppComponentsWithResponse(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getServerMetricsConfigWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.client.getServerMetricsConfigWithResponse(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> createOrUpdateTestRunWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return (Response)this.client.createOrUpdateTestRunWithResponse(testRunId, body, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.client.getTestRunWithResponse(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.client.deleteTestRunWithResponse(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestRunFileWithResponse(String testRunId, String fileName, RequestOptions requestOptions) {
        return (Response)this.client.getTestRunFileWithResponse(testRunId, fileName, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTestRuns(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listTestRuns(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> stopTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.client.stopTestRunWithResponse(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMetricNamespacesWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.client.getMetricNamespacesWithResponse(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMetricDefinitionsWithResponse(String testRunId, String metricNamespace, RequestOptions requestOptions) {
        return (Response)this.client.getMetricDefinitionsWithResponse(testRunId, metricNamespace, requestOptions).block();
    }
}

