/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.developer.loadtesting.implementation.LoadTestingClientImpl;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class LoadTestRunsImpl {
    private final LoadTestRunsService service;
    private final LoadTestingClientImpl client;

    LoadTestRunsImpl(LoadTestingClientImpl client) {
        this.service = (LoadTestRunsService)RestProxy.create(LoadTestRunsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateTestRunWithResponseAsync(String testRunId, BinaryData body, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateTestRun(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), body, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateTestRunWithResponseAsync(String testRunId, BinaryData body, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.createOrUpdateTestRun(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), body, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateTestRunWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return (Response)this.createOrUpdateTestRunWithResponseAsync(testRunId, body, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestRunWithResponseAsync(String testRunId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTestRun(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestRunWithResponseAsync(String testRunId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getTestRun(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.getTestRunWithResponseAsync(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTestRunWithResponseAsync(String testRunId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteTestRun(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTestRunWithResponseAsync(String testRunId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.deleteTestRun(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.deleteTestRunWithResponseAsync(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestRunFileWithResponseAsync(String testRunId, String fileName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTestRunFile(this.client.getEndpoint(), testRunId, fileName, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestRunFileWithResponseAsync(String testRunId, String fileName, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getTestRunFile(this.client.getEndpoint(), testRunId, fileName, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestRunFileWithResponse(String testRunId, String fileName, RequestOptions requestOptions) {
        return (Response)this.getTestRunFileWithResponseAsync(testRunId, fileName, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listTestRunsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listTestRuns(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listTestRunsSinglePageAsync(RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listTestRuns(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTestRunsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listTestRunsSinglePageAsync(requestOptions), nextLink -> this.listTestRunsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTestRunsAsync(RequestOptions requestOptions, Context context) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listTestRunsSinglePageAsync(requestOptions, context), nextLink -> this.listTestRunsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTestRuns(RequestOptions requestOptions) {
        return new PagedIterable(this.listTestRunsAsync(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> stopTestRunWithResponseAsync(String testRunId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stopTestRun(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> stopTestRunWithResponseAsync(String testRunId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.stopTestRun(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> stopTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.stopTestRunWithResponseAsync(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMetricNamespacesWithResponseAsync(String testRunId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMetricNamespaces(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMetricNamespacesWithResponseAsync(String testRunId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getMetricNamespaces(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMetricNamespacesWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.getMetricNamespacesWithResponseAsync(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMetricDefinitionsWithResponseAsync(String testRunId, String metricNamespace, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMetricDefinitions(this.client.getEndpoint(), testRunId, metricNamespace, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMetricDefinitionsWithResponseAsync(String testRunId, String metricNamespace, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getMetricDefinitions(this.client.getEndpoint(), testRunId, metricNamespace, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMetricDefinitionsWithResponse(String testRunId, String metricNamespace, RequestOptions requestOptions) {
        return (Response)this.getMetricDefinitionsWithResponseAsync(testRunId, metricNamespace, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listMetricsSinglePageAsync(String testRunId, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetrics(this.client.getEndpoint(), testRunId, metricName, metricNamespace, timespan, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listMetricsSinglePageAsync(String testRunId, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listMetrics(this.client.getEndpoint(), testRunId, metricName, metricNamespace, timespan, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMetricsAsync(String testRunId, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(testRunId, metricName, metricNamespace, timespan, requestOptions), nextLink -> this.listMetricsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMetricsAsync(String testRunId, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions, Context context) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(testRunId, metricName, metricNamespace, timespan, requestOptions, context), nextLink -> this.listMetricsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMetrics(String testRunId, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        return new PagedIterable(this.listMetricsAsync(testRunId, metricName, metricNamespace, timespan, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listMetricDimensionValuesSinglePageAsync(String testRunId, String name, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetricDimensionValues(this.client.getEndpoint(), testRunId, name, metricName, metricNamespace, timespan, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listMetricDimensionValuesSinglePageAsync(String testRunId, String name, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listMetricDimensionValues(this.client.getEndpoint(), testRunId, name, metricName, metricNamespace, timespan, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMetricDimensionValuesAsync(String testRunId, String name, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listMetricDimensionValuesSinglePageAsync(testRunId, name, metricName, metricNamespace, timespan, requestOptions), nextLink -> this.listMetricDimensionValuesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMetricDimensionValuesAsync(String testRunId, String name, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions, Context context) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listMetricDimensionValuesSinglePageAsync(testRunId, name, metricName, metricNamespace, timespan, requestOptions, context), nextLink -> this.listMetricDimensionValuesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMetricDimensionValues(String testRunId, String name, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        return new PagedIterable(this.listMetricDimensionValuesAsync(testRunId, name, metricName, metricNamespace, timespan, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateAppComponentsWithResponseAsync(String testRunId, BinaryData body, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAppComponents(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), body, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateAppComponentsWithResponseAsync(String testRunId, BinaryData body, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.createOrUpdateAppComponents(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), body, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateAppComponentsWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return (Response)this.createOrUpdateAppComponentsWithResponseAsync(testRunId, body, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAppComponentsWithResponseAsync(String testRunId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAppComponents(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAppComponentsWithResponseAsync(String testRunId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getAppComponents(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAppComponentsWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.getAppComponentsWithResponseAsync(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateServerMetricsConfigWithResponseAsync(String testRunId, BinaryData body, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateServerMetricsConfig(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), body, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateServerMetricsConfigWithResponseAsync(String testRunId, BinaryData body, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.createOrUpdateServerMetricsConfig(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), body, "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateServerMetricsConfigWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return (Response)this.createOrUpdateServerMetricsConfigWithResponseAsync(testRunId, body, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getServerMetricsConfigWithResponseAsync(String testRunId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getServerMetricsConfig(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getServerMetricsConfigWithResponseAsync(String testRunId, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.getServerMetricsConfig(this.client.getEndpoint(), testRunId, this.client.getServiceVersion().getVersion(), "application/json", requestOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getServerMetricsConfigWithResponse(String testRunId, RequestOptions requestOptions) {
        return (Response)this.getServerMetricsConfigWithResponseAsync(testRunId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listTestRunsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listTestRunsNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listTestRunsNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listTestRunsNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listMetricsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetricsNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listMetricsNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listMetricsNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listMetricDimensionValuesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetricDimensionValuesNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listMetricDimensionValuesNextSinglePageAsync(String nextLink, RequestOptions requestOptions, Context context) {
        String accept = "application/json";
        return this.service.listMetricDimensionValuesNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="https://{Endpoint}")
    @ServiceInterface(name="LoadTestingClientLoa")
    private static interface LoadTestRunsService {
        @Patch(value="/test-runs/{testRunId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createOrUpdateTestRun(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/merge-patch+json") BinaryData var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/test-runs/{testRunId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getTestRun(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/test-runs/{testRunId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteTestRun(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/test-runs/{testRunId}/files/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getTestRunFile(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/test-runs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listTestRuns(@HostParam(value="Endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Post(value="/test-runs/{testRunId}:stop")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> stopTestRun(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/test-runs/{testRunId}/metric-namespaces")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getMetricNamespaces(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/test-runs/{testRunId}/metric-definitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getMetricDefinitions(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="metricNamespace") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/test-runs/{testRunId}/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listMetrics(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="metricname") String var3, @QueryParam(value="metricNamespace") String var4, @QueryParam(value="timespan") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Get(value="/test-runs/{testRunId}/metric-dimensions/{name}/values")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listMetricDimensionValues(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @PathParam(value="name") String var3, @QueryParam(value="metricname") String var4, @QueryParam(value="metricNamespace") String var5, @QueryParam(value="timespan") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, RequestOptions var9, Context var10);

        @Patch(value="/test-runs/{testRunId}/app-components")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createOrUpdateAppComponents(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/merge-patch+json") BinaryData var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/test-runs/{testRunId}/app-components")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getAppComponents(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Patch(value="/test-runs/{testRunId}/server-metrics-config")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createOrUpdateServerMetricsConfig(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/merge-patch+json") BinaryData var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/test-runs/{testRunId}/server-metrics-config")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getServerMetricsConfig(@HostParam(value="Endpoint") String var1, @PathParam(value="testRunId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listTestRunsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="Endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listMetricsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="Endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listMetricDimensionValuesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="Endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

