/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.developer.loadtesting.LoadTestingServiceVersion;
import com.azure.developer.loadtesting.implementation.LoadTestAdministrationsImpl;
import com.azure.developer.loadtesting.implementation.LoadTestRunsImpl;

public final class LoadTestingClientImpl {
    private final String endpoint;
    private final LoadTestingServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final LoadTestAdministrationsImpl loadTestAdministrations;
    private final LoadTestRunsImpl loadTestRuns;

    public String getEndpoint() {
        return this.endpoint;
    }

    public LoadTestingServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public LoadTestAdministrationsImpl getLoadTestAdministrations() {
        return this.loadTestAdministrations;
    }

    public LoadTestRunsImpl getLoadTestRuns() {
        return this.loadTestRuns;
    }

    public LoadTestingClientImpl(String endpoint, LoadTestingServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public LoadTestingClientImpl(HttpPipeline httpPipeline, String endpoint, LoadTestingServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public LoadTestingClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, LoadTestingServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.loadTestAdministrations = new LoadTestAdministrationsImpl(this);
        this.loadTestRuns = new LoadTestRunsImpl(this);
    }
}

