// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.iot.deviceupdate;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;

/** Initializes a new instance of the synchronous DeviceUpdateClient type. */
@ServiceClient(builder = DeviceManagementClientBuilder.class)
public final class DeviceManagementClient {
    @Generated private final DeviceManagementAsyncClient client;

    /**
     * Initializes an instance of DeviceManagementClient class.
     *
     * @param client the async client.
     */
    @Generated
    DeviceManagementClient(DeviceManagementAsyncClient client) {
        this.client = client;
    }

    /**
     * Gets a list of all device classes (sets of devices compatible with the same updates based on the model Id and
     * compat properties reported in the Device Update PnP interface in IoT Hub) for all devices connected to Device
     * Update for IoT Hub.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of device classes returned. You can filter on friendly name.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceClassId: String (Required)
     *             friendlyName: String (Optional)
     *             deviceClassProperties (Required): {
     *                 contractModel (Optional): {
     *                     id: String (Required)
     *                     name: String (Required)
     *                 }
     *                 compatProperties (Required): {
     *                     String: String (Required)
     *                 }
     *             }
     *             bestCompatibleUpdate (Optional): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device classes (sets of devices compatible with the same updates based on the model Id and
     *     compat properties reported in the Device Update PnP interface in IoT Hub) for all devices connected to Device
     *     Update for IoT Hub as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceClasses(RequestOptions requestOptions) {
        return new PagedIterable<>(this.client.listDeviceClasses(requestOptions));
    }

    /**
     * Gets the properties of a device class.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceClassId: String (Required)
     *     friendlyName: String (Optional)
     *     deviceClassProperties (Required): {
     *         contractModel (Optional): {
     *             id: String (Required)
     *             name: String (Required)
     *         }
     *         compatProperties (Required): {
     *             String: String (Required)
     *         }
     *     }
     *     bestCompatibleUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     * }
     * }</pre>
     *
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the properties of a device class along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return this.client.getDeviceClassWithResponse(deviceClassId, requestOptions).block();
    }

    /**
     * Update device class details.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     friendlyName: String (Required)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceClassId: String (Required)
     *     friendlyName: String (Optional)
     *     deviceClassProperties (Required): {
     *         contractModel (Optional): {
     *             id: String (Required)
     *             name: String (Required)
     *         }
     *         compatProperties (Required): {
     *             String: String (Required)
     *         }
     *     }
     *     bestCompatibleUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     * }
     * }</pre>
     *
     * @param deviceClassId Device class identifier.
     * @param deviceClassPatch The device class json merge patch body. Currently only supports patching friendlyName.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device class metadata along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateDeviceClassWithResponse(
            String deviceClassId, BinaryData deviceClassPatch, RequestOptions requestOptions) {
        return this.client.updateDeviceClassWithResponse(deviceClassId, deviceClassPatch, requestOptions).block();
    }

    /**
     * Deletes a device class. Device classes are created automatically when Device Update-enabled devices are connected
     * to the hub but are not automatically cleaned up since they are referenced by DeviceClassSubgroups. If the user
     * has deleted all DeviceClassSubgroups for a device class they can also delete the device class to remove the
     * records from the system and to stop checking the compatibility of this device class with new updates. If a device
     * is ever reconnected for this device class it will be re-created.
     *
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return this.client.deleteDeviceClassWithResponse(deviceClassId, requestOptions).block();
    }

    /**
     * Gets a list of installable updates for a device class.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             updateId (Required): {
     *                 provider: String (Required)
     *                 name: String (Required)
     *                 version: String (Required)
     *             }
     *             description: String (Optional)
     *             friendlyName: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of installable updates for a device class as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listInstallableUpdatesForDeviceClass(
            String deviceClassId, RequestOptions requestOptions) {
        return new PagedIterable<>(this.client.listInstallableUpdatesForDeviceClass(deviceClassId, requestOptions));
    }

    /**
     * Gets a list of devices connected to Device Update for IoT Hub.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of devices returned. You can filter on GroupId, DeviceClassId, or GroupId and DeploymentStatus. Use DeploymentStatus eq null to query for devices with no deployment status (that have never been deployed to).</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             deviceClassId: String (Required)
     *             groupId: String (Optional)
     *             lastAttemptedUpdate (Optional): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *             installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *             onLatestUpdate: boolean (Required)
     *             lastDeploymentId: String (Optional)
     *             lastInstallResult (Optional): {
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *                 stepResults (Optional): [
     *                      (Optional){
     *                         update (Optional): (recursive schema, see update above)
     *                         description: String (Optional)
     *                         resultCode: int (Required)
     *                         extendedResultCode: int (Required)
     *                         resultDetails: String (Optional)
     *                     }
     *                 ]
     *             }
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of devices connected to Device Update for IoT Hub as paginated response with {@link
     *     PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDevices(RequestOptions requestOptions) {
        return new PagedIterable<>(this.client.listDevices(requestOptions));
    }

    /**
     * Import existing devices from IoT Hub. This is a long-running-operation; use Operation-Location response header
     * value to check for operation status.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * String(Devices/Modules/All)
     * }</pre>
     *
     * @param importType The types of devices to import.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginImportDevices(BinaryData importType, RequestOptions requestOptions) {
        return this.client.beginImportDevices(importType, requestOptions).getSyncPoller();
    }

    /**
     * Gets the device properties and latest deployment status for a device connected to Device Update for IoT Hub.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceId: String (Required)
     *     moduleId: String (Optional)
     *     deviceClassId: String (Required)
     *     groupId: String (Optional)
     *     lastAttemptedUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *     installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *     onLatestUpdate: boolean (Required)
     *     lastDeploymentId: String (Optional)
     *     lastInstallResult (Optional): {
     *         resultCode: int (Required)
     *         extendedResultCode: int (Required)
     *         resultDetails: String (Optional)
     *         stepResults (Optional): [
     *              (Optional){
     *                 update (Optional): (recursive schema, see update above)
     *                 description: String (Optional)
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *             }
     *         ]
     *     }
     * }
     * }</pre>
     *
     * @param deviceId Device identifier in Azure IoT Hub.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device properties and latest deployment status for a device connected to Device Update for IoT Hub
     *     along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceWithResponse(String deviceId, RequestOptions requestOptions) {
        return this.client.getDeviceWithResponse(deviceId, requestOptions).block();
    }

    /**
     * Gets the device module properties and latest deployment status for a device module connected to Device Update for
     * IoT Hub.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceId: String (Required)
     *     moduleId: String (Optional)
     *     deviceClassId: String (Required)
     *     groupId: String (Optional)
     *     lastAttemptedUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *     installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *     onLatestUpdate: boolean (Required)
     *     lastDeploymentId: String (Optional)
     *     lastInstallResult (Optional): {
     *         resultCode: int (Required)
     *         extendedResultCode: int (Required)
     *         resultDetails: String (Optional)
     *         stepResults (Optional): [
     *              (Optional){
     *                 update (Optional): (recursive schema, see update above)
     *                 description: String (Optional)
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *             }
     *         ]
     *     }
     * }
     * }</pre>
     *
     * @param deviceId Device identifier in Azure IoT Hub.
     * @param moduleId Device module identifier in Azure IoT Hub.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device module properties and latest deployment status for a device module connected to Device Update
     *     for IoT Hub along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceModuleWithResponse(
            String deviceId, String moduleId, RequestOptions requestOptions) {
        return this.client.getDeviceModuleWithResponse(deviceId, moduleId, requestOptions).block();
    }

    /**
     * Gets the breakdown of how many devices are on their latest update, have new updates available, or are in progress
     * receiving new updates.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     totalDeviceCount: int (Required)
     *     onLatestUpdateDeviceCount: int (Required)
     *     newUpdatesAvailableDeviceCount: int (Required)
     *     updatesInProgressDeviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the breakdown of how many devices are on their latest update, have new updates available, or are in
     *     progress receiving new updates along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getUpdateComplianceWithResponse(RequestOptions requestOptions) {
        return this.client.getUpdateComplianceWithResponse(requestOptions).block();
    }

    /**
     * Gets a list of all device groups. The $default group will always be returned first.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of groups returned. You can order by groupId, deviceCount, createdDate, subgroupsWithNewUpdatesAvailableCount, subgroupsWithUpdatesInProgressCount, or subgroupsOnLatestUpdateCount.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             groupType: String(IoTHubTag/DefaultNoTag) (Required)
     *             createdDateTime: String (Required)
     *             deviceCount: Integer (Optional)
     *             subgroupsWithNewUpdatesAvailableCount: Integer (Optional)
     *             subgroupsWithUpdatesInProgressCount: Integer (Optional)
     *             subgroupsWithOnLatestUpdateCount: Integer (Optional)
     *             deployments (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device groups as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listGroups(RequestOptions requestOptions) {
        return new PagedIterable<>(this.client.listGroups(requestOptions));
    }

    /**
     * Gets the device group properties.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     groupType: String(IoTHubTag/DefaultNoTag) (Required)
     *     createdDateTime: String (Required)
     *     deviceCount: Integer (Optional)
     *     subgroupsWithNewUpdatesAvailableCount: Integer (Optional)
     *     subgroupsWithUpdatesInProgressCount: Integer (Optional)
     *     subgroupsWithOnLatestUpdateCount: Integer (Optional)
     *     deployments (Optional): [
     *         String (Optional)
     *     ]
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device group properties along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return this.client.getGroupWithResponse(groupId, requestOptions).block();
    }

    /**
     * Deletes a device group. This group is automatically created when a Device Update-enabled device is connected to
     * the hub and reports its properties. Groups, subgroups, and deployments are not automatically cleaned up but are
     * retained for history purposes. Users can call this method to delete a group if they do not need to retain any of
     * the history of the group and no longer need it. If a device is ever connected again for this group after the
     * group was deleted it will be automatically re-created but there will be no history.
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return this.client.deleteGroupWithResponse(groupId, requestOptions).block();
    }

    /**
     * Get device group update compliance information such as how many devices are on their latest update, how many need
     * new updates, and how many are in progress on receiving a new update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     totalDeviceCount: int (Required)
     *     onLatestUpdateDeviceCount: int (Required)
     *     newUpdatesAvailableDeviceCount: int (Required)
     *     updatesInProgressDeviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device group update compliance information such as how many devices are on their latest update, how many
     *     need new updates, and how many are in progress on receiving a new update along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getUpdateComplianceForGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return this.client.getUpdateComplianceForGroupWithResponse(groupId, requestOptions).block();
    }

    /**
     * Get the best available updates for a device group and a count of how many devices need each update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             deviceClassId: String (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             deviceCount: int (Required)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the best available updates for a device group and a count of how many devices need each update as
     *     paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listBestUpdatesForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable<>(this.client.listBestUpdatesForGroup(groupId, requestOptions));
    }

    /**
     * Gets a list of deployments for a device group.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of deployments returned. You can order by start date.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deploymentId: String (Required)
     *             startDateTime: OffsetDateTime (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             groupId: String (Required)
     *             deviceClassSubgroups (Optional): [
     *                 String (Optional)
     *             ]
     *             isCanceled: Boolean (Optional)
     *             isRetried: Boolean (Optional)
     *             rollbackPolicy (Optional): {
     *                 update (Required): (recursive schema, see update above)
     *                 failure (Required): {
     *                     devicesFailedPercentage: int (Required)
     *                     devicesFailedCount: int (Required)
     *                 }
     *             }
     *             isCloudInitiatedRollback: Boolean (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of deployments for a device group as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeploymentsForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable<>(this.client.listDeploymentsForGroup(groupId, requestOptions));
    }

    /**
     * Gets the deployment properties.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the deployment properties along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentWithResponse(
            String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.client.getDeploymentWithResponse(groupId, deploymentId, requestOptions).block();
    }

    /**
     * Creates or updates a deployment.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param deployment The deployment properties.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return deployment metadata along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateDeploymentWithResponse(
            String groupId, String deploymentId, BinaryData deployment, RequestOptions requestOptions) {
        return this.client
                .createOrUpdateDeploymentWithResponse(groupId, deploymentId, deployment, requestOptions)
                .block();
    }

    /**
     * Deletes a deployment.
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDeploymentWithResponse(
            String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.client.deleteDeploymentWithResponse(groupId, deploymentId, requestOptions).block();
    }

    /**
     * Gets the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     * completed, or failed.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     deploymentState: String(Active/ActiveWithSubgroupFailures/Failed/Inactive/Canceled) (Required)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Required)
     *             message: String (Optional)
     *             errorDetail: String (Optional)
     *             innerError (Optional): (recursive schema, see innerError above)
     *         }
     *         occurredDateTime: OffsetDateTime (Optional)
     *     }
     *     subgroupStatus (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             deviceClassId: String (Required)
     *             deploymentState: String(Active/Failed/Inactive/Canceled) (Required)
     *             error (Optional): (recursive schema, see error above)
     *             totalDevices: Integer (Optional)
     *             devicesInProgressCount: Integer (Optional)
     *             devicesCompletedFailedCount: Integer (Optional)
     *             devicesCompletedSucceededCount: Integer (Optional)
     *             devicesCanceledCount: Integer (Optional)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     *     completed, or failed along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentStatusWithResponse(
            String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.client.getDeploymentStatusWithResponse(groupId, deploymentId, requestOptions).block();
    }

    /**
     * Get the device class subgroups for the group. A device class subgroup is the set of devices within the group that
     * share the same device class. All devices within the same device class are compatible with the same updates.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of device class subgroups returned. You can filter on compat properties by name and value. (i.e. filter=compatProperties/propertyName1 eq 'value1' and compatProperties/propertyName2 eq 'value2')</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceClassId: String (Required)
     *             groupId: String (Required)
     *             createdDateTime: String (Required)
     *             deviceCount: Integer (Optional)
     *             deploymentId: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device class subgroups for the group as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceClassSubgroupsForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable<>(this.client.listDeviceClassSubgroupsForGroup(groupId, requestOptions));
    }

    /**
     * Gets device class subgroup details. A device class subgroup is the set of devices within the group that share the
     * same device class. All devices within the same device class are compatible with the same updates.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceClassId: String (Required)
     *     groupId: String (Required)
     *     createdDateTime: String (Required)
     *     deviceCount: Integer (Optional)
     *     deploymentId: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device class subgroup details along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassSubgroupWithResponse(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        return this.client.getDeviceClassSubgroupWithResponse(groupId, deviceClassId, requestOptions).block();
    }

    /**
     * Deletes a device class subgroup. This subgroup is automatically created when a Device Update-enabled device is
     * connected to the hub and reports its properties. Groups, subgroups, and deployments are not automatically cleaned
     * up but are retained for history purposes. Users can call this method to delete a subgroup if they do not need to
     * retain any of the history of the subgroup and no longer need it. If a device is ever connected again for this
     * subgroup after the subgroup was deleted it will be automatically re-created but there will be no history.
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDeviceClassSubgroupWithResponse(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        return this.client.deleteDeviceClassSubgroupWithResponse(groupId, deviceClassId, requestOptions).block();
    }

    /**
     * Get device class subgroup update compliance information such as how many devices are on their latest update, how
     * many need new updates, and how many are in progress on receiving a new update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     totalDeviceCount: int (Required)
     *     onLatestUpdateDeviceCount: int (Required)
     *     newUpdatesAvailableDeviceCount: int (Required)
     *     updatesInProgressDeviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device class subgroup update compliance information such as how many devices are on their latest update,
     *     how many need new updates, and how many are in progress on receiving a new update along with {@link
     *     Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassSubgroupUpdateComplianceWithResponse(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        return this.client
                .getDeviceClassSubgroupUpdateComplianceWithResponse(groupId, deviceClassId, requestOptions)
                .block();
    }

    /**
     * Get the best available update for a device class subgroup and a count of how many devices need this update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     deviceClassId: String (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     deviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the best available update for a device class subgroup and a count of how many devices need this update
     *     along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getBestUpdatesForDeviceClassSubgroupWithResponse(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        return this.client
                .getBestUpdatesForDeviceClassSubgroupWithResponse(groupId, deviceClassId, requestOptions)
                .block();
    }

    /**
     * Gets a list of deployments for a device class subgroup.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of deployments returned. You can order by start date.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deploymentId: String (Required)
     *             startDateTime: OffsetDateTime (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             groupId: String (Required)
     *             deviceClassSubgroups (Optional): [
     *                 String (Optional)
     *             ]
     *             isCanceled: Boolean (Optional)
     *             isRetried: Boolean (Optional)
     *             rollbackPolicy (Optional): {
     *                 update (Required): (recursive schema, see update above)
     *                 failure (Required): {
     *                     devicesFailedPercentage: int (Required)
     *                     devicesFailedCount: int (Required)
     *                 }
     *             }
     *             isCloudInitiatedRollback: Boolean (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of deployments for a device class subgroup as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeploymentsForDeviceClassSubgroup(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        return new PagedIterable<>(
                this.client.listDeploymentsForDeviceClassSubgroup(groupId, deviceClassId, requestOptions));
    }

    /**
     * Gets the deployment properties.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the deployment properties along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentForDeviceClassSubgroupWithResponse(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.client
                .getDeploymentForDeviceClassSubgroupWithResponse(groupId, deviceClassId, deploymentId, requestOptions)
                .block();
    }

    /**
     * Deletes a device class subgroup deployment.
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDeploymentForDeviceClassSubgroupWithResponse(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.client
                .deleteDeploymentForDeviceClassSubgroupWithResponse(
                        groupId, deviceClassId, deploymentId, requestOptions)
                .block();
    }

    /**
     * Stops a deployment.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return deployment metadata along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> stopDeploymentWithResponse(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.client.stopDeploymentWithResponse(groupId, deviceClassId, deploymentId, requestOptions).block();
    }

    /**
     * Retries a deployment with failed devices.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return deployment metadata along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> retryDeploymentWithResponse(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.client.retryDeploymentWithResponse(groupId, deviceClassId, deploymentId, requestOptions).block();
    }

    /**
     * Gets the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     * completed, or failed.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     deviceClassId: String (Required)
     *     deploymentState: String(Active/Failed/Inactive/Canceled) (Required)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Required)
     *             message: String (Optional)
     *             errorDetail: String (Optional)
     *             innerError (Optional): (recursive schema, see innerError above)
     *         }
     *         occurredDateTime: OffsetDateTime (Optional)
     *     }
     *     totalDevices: Integer (Optional)
     *     devicesInProgressCount: Integer (Optional)
     *     devicesCompletedFailedCount: Integer (Optional)
     *     devicesCompletedSucceededCount: Integer (Optional)
     *     devicesCanceledCount: Integer (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     *     completed, or failed along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassSubgroupDeploymentStatusWithResponse(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.client
                .getDeviceClassSubgroupDeploymentStatusWithResponse(
                        groupId, deviceClassId, deploymentId, requestOptions)
                .block();
    }

    /**
     * Gets a list of devices in a deployment along with their state. Useful for getting a list of failed devices.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of deployment device states returned. You can filter on deviceId and moduleId and/or deviceState.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             retryCount: int (Required)
     *             movedOnToNewDeployment: boolean (Required)
     *             deviceState: String(Succeeded/InProgress/Canceled/Failed) (Required)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of devices in a deployment along with their state as paginated response with {@link
     *     PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceStatesForDeviceClassSubgroupDeployment(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return new PagedIterable<>(
                this.client.listDeviceStatesForDeviceClassSubgroupDeployment(
                        groupId, deviceClassId, deploymentId, requestOptions));
    }

    /**
     * Retrieve operation status.
     *
     * <p><strong>Header Parameters</strong>
     *
     * <table border="1">
     *     <caption>Header Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>If-None-Match</td><td>String</td><td>No</td><td>Defines the If-None-Match condition. The operation will be performed only if the ETag on the server does not match this value.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addHeader}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Required)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Required)
     *             message: String (Optional)
     *             errorDetail: String (Optional)
     *             innerError (Optional): (recursive schema, see innerError above)
     *         }
     *         occurredDateTime: OffsetDateTime (Optional)
     *     }
     *     traceId: String (Optional)
     *     lastActionDateTime: OffsetDateTime (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     etag: String (Optional)
     * }
     * }</pre>
     *
     * @param operationId Operation identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return operation metadata along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getOperationStatusWithResponse(String operationId, RequestOptions requestOptions) {
        return this.client.getOperationStatusWithResponse(operationId, requestOptions).block();
    }

    /**
     * Get a list of all device import operations. Completed operations are kept for 7 days before auto-deleted.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of operations returned. Only one specific filter is supported: "status eq 'NotStarted' or status eq 'Running'"</td></tr>
     *     <tr><td>top</td><td>Integer</td><td>No</td><td>Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the number of available items up to but not greater than the specified value n.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             operationId: String (Required)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *             error (Optional): {
     *                 code: String (Required)
     *                 message: String (Required)
     *                 target: String (Optional)
     *                 details (Optional): [
     *                     (recursive schema, see above)
     *                 ]
     *                 innererror (Optional): {
     *                     code: String (Required)
     *                     message: String (Optional)
     *                     errorDetail: String (Optional)
     *                     innerError (Optional): (recursive schema, see innerError above)
     *                 }
     *                 occurredDateTime: OffsetDateTime (Optional)
     *             }
     *             traceId: String (Optional)
     *             lastActionDateTime: OffsetDateTime (Required)
     *             createdDateTime: OffsetDateTime (Required)
     *             etag: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device import operations as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperationStatuses(RequestOptions requestOptions) {
        return new PagedIterable<>(this.client.listOperationStatuses(requestOptions));
    }

    /**
     * Start the device diagnostics log collection on specified devices.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     deviceList (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     deviceList (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     * }
     * }</pre>
     *
     * @param logCollectionId Log collection identifier.
     * @param logCollection The log collection properties.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return diagnostics request body along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> startLogCollectionWithResponse(
            String logCollectionId, BinaryData logCollection, RequestOptions requestOptions) {
        return this.client.startLogCollectionWithResponse(logCollectionId, logCollection, requestOptions).block();
    }

    /**
     * Get the device diagnostics log collection.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     deviceList (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     * }
     * }</pre>
     *
     * @param logCollectionId Log collection identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device diagnostics log collection along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getLogCollectionWithResponse(String logCollectionId, RequestOptions requestOptions) {
        return this.client.getLogCollectionWithResponse(logCollectionId, requestOptions).block();
    }

    /**
     * Get all device diagnostics log collections.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             operationId: String (Optional)
     *             deviceList (Required): [
     *                  (Required){
     *                     deviceId: String (Required)
     *                     moduleId: String (Optional)
     *                 }
     *             ]
     *             description: String (Optional)
     *             createdDateTime: String (Optional)
     *             lastActionDateTime: String (Optional)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return all device diagnostics log collections as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listLogCollections(RequestOptions requestOptions) {
        return new PagedIterable<>(this.client.listLogCollections(requestOptions));
    }

    /**
     * Get log collection with detailed status.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     *     deviceStatus (Optional): [
     *          (Optional){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *             resultCode: String (Optional)
     *             extendedResultCode: String (Optional)
     *             logLocation: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     * }
     * }</pre>
     *
     * @param logCollectionId Log collection identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return log collection with detailed status along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getLogCollectionDetailedStatusWithResponse(
            String logCollectionId, RequestOptions requestOptions) {
        return this.client.getLogCollectionDetailedStatusWithResponse(logCollectionId, requestOptions).block();
    }

    /**
     * Get list of device health.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             state: String(healthy/unhealthy) (Required)
     *             digitalTwinModelId: String (Optional)
     *             healthChecks (Required): [
     *                  (Required){
     *                     name: String (Optional)
     *                     result: String(success/userError) (Optional)
     *                 }
     *             ]
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param filter Restricts the set of devices for which device health is returned. You can filter on status, device
     *     id and module id.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return list of device health as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listHealthOfDevices(String filter, RequestOptions requestOptions) {
        return new PagedIterable<>(this.client.listHealthOfDevices(filter, requestOptions));
    }
}
