// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.iot.deviceupdate.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DeviceManagements. */
public final class DeviceManagementsImpl {
    /** The proxy service used to perform REST calls. */
    private final DeviceManagementsService service;

    /** The service client containing this operation class. */
    private final DeviceUpdateClientImpl client;

    /**
     * Initializes an instance of DeviceManagementsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DeviceManagementsImpl(DeviceUpdateClientImpl client) {
        this.service =
                RestProxy.create(
                        DeviceManagementsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for DeviceUpdateClientDeviceManagements to be used by the proxy service
     * to perform REST calls.
     */
    @Host("https://{endpoint}")
    @ServiceInterface(name = "DeviceUpdateClientDe")
    public interface DeviceManagementsService {
        @Get("/deviceUpdate/{instanceId}/management/deviceClasses")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDeviceClasses(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/deviceClasses/{deviceClassId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeviceClass(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("deviceClassId") String deviceClassId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Patch("/deviceUpdate/{instanceId}/management/deviceClasses/{deviceClassId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> updateDeviceClass(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("deviceClassId") String deviceClassId,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/merge-patch+json") BinaryData deviceClassPatch,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Delete("/deviceUpdate/{instanceId}/management/deviceClasses/{deviceClassId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> deleteDeviceClass(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("deviceClassId") String deviceClassId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/deviceClasses/{deviceClassId}/installableUpdates")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listInstallableUpdatesForDeviceClass(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("deviceClassId") String deviceClassId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/devices")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDevices(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Post("/deviceUpdate/{instanceId}/management/devices:import")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> importDevices(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") BinaryData importType,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/devices/{deviceId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDevice(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("deviceId") String deviceId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/devices/{deviceId}/modules/{moduleId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeviceModule(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("deviceId") String deviceId,
                @PathParam("moduleId") String moduleId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/updateCompliance")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getUpdateCompliance(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listGroups(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups/{groupId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getGroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Delete("/deviceUpdate/{instanceId}/management/groups/{groupId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> deleteGroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups/{groupId}/updateCompliance")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getUpdateComplianceForGroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups/{groupId}/bestUpdates")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listBestUpdatesForGroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups/{groupId}/deployments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDeploymentsForGroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeployment(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deploymentId") String deploymentId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Put("/deviceUpdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> createOrUpdateDeployment(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deploymentId") String deploymentId,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") BinaryData deployment,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Delete("/deviceUpdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> deleteDeployment(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deploymentId") String deploymentId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups/{groupId}/deployments/{deploymentId}/status")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeploymentStatus(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deploymentId") String deploymentId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDeviceClassSubgroupsForGroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeviceClassSubgroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Delete("/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> deleteDeviceClassSubgroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get(
                "/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}/updateCompliance")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeviceClassSubgroupUpdateCompliance(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}/bestUpdates")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getBestUpdatesForDeviceClassSubgroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}/deployments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDeploymentsForDeviceClassSubgroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get(
                "/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}/deployments/{deploymentId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeploymentForDeviceClassSubgroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @PathParam("deploymentId") String deploymentId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Delete(
                "/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}/deployments/{deploymentId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> deleteDeploymentForDeviceClassSubgroup(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @PathParam("deploymentId") String deploymentId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Post(
                "/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}/deployments/{deploymentId}:cancel")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> stopDeployment(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @PathParam("deploymentId") String deploymentId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Post(
                "/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}/deployments/{deploymentId}:retry")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> retryDeployment(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @PathParam("deploymentId") String deploymentId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get(
                "/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}/deployments/{deploymentId}/status")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getDeviceClassSubgroupDeploymentStatus(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @PathParam("deploymentId") String deploymentId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get(
                "/deviceUpdate/{instanceId}/management/groups/{groupId}/deviceClassSubgroups/{deviceClassId}/deployments/{deploymentId}/devicestates")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDeviceStatesForDeviceClassSubgroupDeployment(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("groupId") String groupId,
                @PathParam("deviceClassId") String deviceClassId,
                @PathParam("deploymentId") String deploymentId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/operations/{operationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getOperationStatus(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("operationId") String operationId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/operations")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listOperationStatuses(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Put("/deviceUpdate/{instanceId}/management/deviceDiagnostics/logCollections/{operationId}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> startLogCollection(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("operationId") String logCollectionId,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") BinaryData logCollection,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/deviceDiagnostics/logCollections/{operationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getLogCollection(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("operationId") String logCollectionId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/deviceDiagnostics/logCollections")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listLogCollections(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/deviceDiagnostics/logCollections/{operationId}/detailedStatus")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getLogCollectionDetailedStatus(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @PathParam("operationId") String logCollectionId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("/deviceUpdate/{instanceId}/management/deviceDiagnostics/deviceHealth")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listHealthOfDevices(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "instanceId", encoded = true) String instanceId,
                @QueryParam("api-version") String apiVersion,
                @QueryParam("filter") String filter,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDeviceClassesNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listInstallableUpdatesForDeviceClassNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDevicesNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listGroupsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listBestUpdatesForGroupNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDeploymentsForGroupNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDeviceClassSubgroupsForGroupNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDeploymentsForDeviceClassSubgroupNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listDeviceStatesForDeviceClassSubgroupDeploymentNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listOperationStatusesNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listLogCollectionsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(
                value = ClientAuthenticationException.class,
                code = {401})
        @UnexpectedResponseExceptionType(
                value = ResourceNotFoundException.class,
                code = {404})
        @UnexpectedResponseExceptionType(
                value = ResourceModifiedException.class,
                code = {409})
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listHealthOfDevicesNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                RequestOptions requestOptions,
                Context context);
    }

    /**
     * Gets a list of all device classes (sets of devices compatible with the same updates based on the model Id and
     * compat properties reported in the Device Update PnP interface in IoT Hub) for all devices connected to Device
     * Update for IoT Hub.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of device classes returned. You can filter on friendly name.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceClassId: String (Required)
     *             friendlyName: String (Optional)
     *             deviceClassProperties (Required): {
     *                 contractModel (Optional): {
     *                     id: String (Required)
     *                     name: String (Required)
     *                 }
     *                 compatProperties (Required): {
     *                     String: String (Required)
     *                 }
     *             }
     *             bestCompatibleUpdate (Optional): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device classes (sets of devices compatible with the same updates based on the model Id and
     *     compat properties reported in the Device Update PnP interface in IoT Hub) for all devices connected to Device
     *     Update for IoT Hub along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceClassesSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDeviceClasses(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Gets a list of all device classes (sets of devices compatible with the same updates based on the model Id and
     * compat properties reported in the Device Update PnP interface in IoT Hub) for all devices connected to Device
     * Update for IoT Hub.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of device classes returned. You can filter on friendly name.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceClassId: String (Required)
     *             friendlyName: String (Optional)
     *             deviceClassProperties (Required): {
     *                 contractModel (Optional): {
     *                     id: String (Required)
     *                     name: String (Required)
     *                 }
     *                 compatProperties (Required): {
     *                     String: String (Required)
     *                 }
     *             }
     *             bestCompatibleUpdate (Optional): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device classes (sets of devices compatible with the same updates based on the model Id and
     *     compat properties reported in the Device Update PnP interface in IoT Hub) for all devices connected to Device
     *     Update for IoT Hub as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceClassesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listDeviceClassesSinglePageAsync(requestOptions),
                nextLink -> listDeviceClassesNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Gets a list of all device classes (sets of devices compatible with the same updates based on the model Id and
     * compat properties reported in the Device Update PnP interface in IoT Hub) for all devices connected to Device
     * Update for IoT Hub.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of device classes returned. You can filter on friendly name.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceClassId: String (Required)
     *             friendlyName: String (Optional)
     *             deviceClassProperties (Required): {
     *                 contractModel (Optional): {
     *                     id: String (Required)
     *                     name: String (Required)
     *                 }
     *                 compatProperties (Required): {
     *                     String: String (Required)
     *                 }
     *             }
     *             bestCompatibleUpdate (Optional): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device classes (sets of devices compatible with the same updates based on the model Id and
     *     compat properties reported in the Device Update PnP interface in IoT Hub) for all devices connected to Device
     *     Update for IoT Hub as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceClasses(RequestOptions requestOptions) {
        return new PagedIterable<>(listDeviceClassesAsync(requestOptions));
    }

    /**
     * Gets the properties of a device class.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceClassId: String (Required)
     *     friendlyName: String (Optional)
     *     deviceClassProperties (Required): {
     *         contractModel (Optional): {
     *             id: String (Required)
     *             name: String (Required)
     *         }
     *         compatProperties (Required): {
     *             String: String (Required)
     *         }
     *     }
     *     bestCompatibleUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     * }
     * }</pre>
     *
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the properties of a device class along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassWithResponseAsync(
            String deviceClassId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getDeviceClass(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                deviceClassId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets the properties of a device class.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceClassId: String (Required)
     *     friendlyName: String (Optional)
     *     deviceClassProperties (Required): {
     *         contractModel (Optional): {
     *             id: String (Required)
     *             name: String (Required)
     *         }
     *         compatProperties (Required): {
     *             String: String (Required)
     *         }
     *     }
     *     bestCompatibleUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     * }
     * }</pre>
     *
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the properties of a device class along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return getDeviceClassWithResponseAsync(deviceClassId, requestOptions).block();
    }

    /**
     * Update device class details.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     friendlyName: String (Required)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceClassId: String (Required)
     *     friendlyName: String (Optional)
     *     deviceClassProperties (Required): {
     *         contractModel (Optional): {
     *             id: String (Required)
     *             name: String (Required)
     *         }
     *         compatProperties (Required): {
     *             String: String (Required)
     *         }
     *     }
     *     bestCompatibleUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     * }
     * }</pre>
     *
     * @param deviceClassId Device class identifier.
     * @param deviceClassPatch The device class json merge patch body. Currently only supports patching friendlyName.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device class metadata along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateDeviceClassWithResponseAsync(
            String deviceClassId, BinaryData deviceClassPatch, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.updateDeviceClass(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                deviceClassId,
                                this.client.getServiceVersion().getVersion(),
                                deviceClassPatch,
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Update device class details.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     friendlyName: String (Required)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceClassId: String (Required)
     *     friendlyName: String (Optional)
     *     deviceClassProperties (Required): {
     *         contractModel (Optional): {
     *             id: String (Required)
     *             name: String (Required)
     *         }
     *         compatProperties (Required): {
     *             String: String (Required)
     *         }
     *     }
     *     bestCompatibleUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     * }
     * }</pre>
     *
     * @param deviceClassId Device class identifier.
     * @param deviceClassPatch The device class json merge patch body. Currently only supports patching friendlyName.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device class metadata along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateDeviceClassWithResponse(
            String deviceClassId, BinaryData deviceClassPatch, RequestOptions requestOptions) {
        return updateDeviceClassWithResponseAsync(deviceClassId, deviceClassPatch, requestOptions).block();
    }

    /**
     * Deletes a device class. Device classes are created automatically when Device Update-enabled devices are connected
     * to the hub but are not automatically cleaned up since they are referenced by DeviceClassSubgroups. If the user
     * has deleted all DeviceClassSubgroups for a device class they can also delete the device class to remove the
     * records from the system and to stop checking the compatibility of this device class with new updates. If a device
     * is ever reconnected for this device class it will be re-created.
     *
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeviceClassWithResponseAsync(
            String deviceClassId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteDeviceClass(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                deviceClassId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Deletes a device class. Device classes are created automatically when Device Update-enabled devices are connected
     * to the hub but are not automatically cleaned up since they are referenced by DeviceClassSubgroups. If the user
     * has deleted all DeviceClassSubgroups for a device class they can also delete the device class to remove the
     * records from the system and to stop checking the compatibility of this device class with new updates. If a device
     * is ever reconnected for this device class it will be re-created.
     *
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return deleteDeviceClassWithResponseAsync(deviceClassId, requestOptions).block();
    }

    /**
     * Gets a list of installable updates for a device class.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             updateId (Required): {
     *                 provider: String (Required)
     *                 name: String (Required)
     *                 version: String (Required)
     *             }
     *             description: String (Optional)
     *             friendlyName: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of installable updates for a device class along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listInstallableUpdatesForDeviceClassSinglePageAsync(
            String deviceClassId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listInstallableUpdatesForDeviceClass(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        deviceClassId,
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Gets a list of installable updates for a device class.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             updateId (Required): {
     *                 provider: String (Required)
     *                 name: String (Required)
     *                 version: String (Required)
     *             }
     *             description: String (Optional)
     *             friendlyName: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of installable updates for a device class as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listInstallableUpdatesForDeviceClassAsync(
            String deviceClassId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listInstallableUpdatesForDeviceClassSinglePageAsync(deviceClassId, requestOptions),
                nextLink ->
                        listInstallableUpdatesForDeviceClassNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Gets a list of installable updates for a device class.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             updateId (Required): {
     *                 provider: String (Required)
     *                 name: String (Required)
     *                 version: String (Required)
     *             }
     *             description: String (Optional)
     *             friendlyName: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of installable updates for a device class as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listInstallableUpdatesForDeviceClass(
            String deviceClassId, RequestOptions requestOptions) {
        return new PagedIterable<>(listInstallableUpdatesForDeviceClassAsync(deviceClassId, requestOptions));
    }

    /**
     * Gets a list of devices connected to Device Update for IoT Hub.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of devices returned. You can filter on GroupId, DeviceClassId, or GroupId and DeploymentStatus. Use DeploymentStatus eq null to query for devices with no deployment status (that have never been deployed to).</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             deviceClassId: String (Required)
     *             groupId: String (Optional)
     *             lastAttemptedUpdate (Optional): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *             installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *             onLatestUpdate: boolean (Required)
     *             lastDeploymentId: String (Optional)
     *             lastInstallResult (Optional): {
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *                 stepResults (Optional): [
     *                      (Optional){
     *                         update (Optional): (recursive schema, see update above)
     *                         description: String (Optional)
     *                         resultCode: int (Required)
     *                         extendedResultCode: int (Required)
     *                         resultDetails: String (Optional)
     *                     }
     *                 ]
     *             }
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of devices connected to Device Update for IoT Hub along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDevicesSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDevices(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Gets a list of devices connected to Device Update for IoT Hub.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of devices returned. You can filter on GroupId, DeviceClassId, or GroupId and DeploymentStatus. Use DeploymentStatus eq null to query for devices with no deployment status (that have never been deployed to).</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             deviceClassId: String (Required)
     *             groupId: String (Optional)
     *             lastAttemptedUpdate (Optional): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *             installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *             onLatestUpdate: boolean (Required)
     *             lastDeploymentId: String (Optional)
     *             lastInstallResult (Optional): {
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *                 stepResults (Optional): [
     *                      (Optional){
     *                         update (Optional): (recursive schema, see update above)
     *                         description: String (Optional)
     *                         resultCode: int (Required)
     *                         extendedResultCode: int (Required)
     *                         resultDetails: String (Optional)
     *                     }
     *                 ]
     *             }
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of devices connected to Device Update for IoT Hub as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDevicesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listDevicesSinglePageAsync(requestOptions),
                nextLink -> listDevicesNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Gets a list of devices connected to Device Update for IoT Hub.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of devices returned. You can filter on GroupId, DeviceClassId, or GroupId and DeploymentStatus. Use DeploymentStatus eq null to query for devices with no deployment status (that have never been deployed to).</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             deviceClassId: String (Required)
     *             groupId: String (Optional)
     *             lastAttemptedUpdate (Optional): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *             installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *             onLatestUpdate: boolean (Required)
     *             lastDeploymentId: String (Optional)
     *             lastInstallResult (Optional): {
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *                 stepResults (Optional): [
     *                      (Optional){
     *                         update (Optional): (recursive schema, see update above)
     *                         description: String (Optional)
     *                         resultCode: int (Required)
     *                         extendedResultCode: int (Required)
     *                         resultDetails: String (Optional)
     *                     }
     *                 ]
     *             }
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of devices connected to Device Update for IoT Hub as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDevices(RequestOptions requestOptions) {
        return new PagedIterable<>(listDevicesAsync(requestOptions));
    }

    /**
     * Import existing devices from IoT Hub. This is a long-running-operation; use Operation-Location response header
     * value to check for operation status.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * String(Devices/Modules/All)
     * }</pre>
     *
     * @param importType The types of devices to import.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> importDevicesWithResponseAsync(BinaryData importType, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.importDevices(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                this.client.getServiceVersion().getVersion(),
                                importType,
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Import existing devices from IoT Hub. This is a long-running-operation; use Operation-Location response header
     * value to check for operation status.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * String(Devices/Modules/All)
     * }</pre>
     *
     * @param importType The types of devices to import.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginImportDevicesAsync(
            BinaryData importType, RequestOptions requestOptions) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.importDevicesWithResponseAsync(importType, requestOptions),
                new OperationResourcePollingStrategyWithEndpoint<>(
                        this.client.getHttpPipeline(),
                        "https://" + this.client.getEndpoint(),
                        null,
                        null,
                        requestOptions != null && requestOptions.getContext() != null
                                ? requestOptions.getContext()
                                : Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Import existing devices from IoT Hub. This is a long-running-operation; use Operation-Location response header
     * value to check for operation status.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * String(Devices/Modules/All)
     * }</pre>
     *
     * @param importType The types of devices to import.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginImportDevices(BinaryData importType, RequestOptions requestOptions) {
        return this.beginImportDevicesAsync(importType, requestOptions).getSyncPoller();
    }

    /**
     * Gets the device properties and latest deployment status for a device connected to Device Update for IoT Hub.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceId: String (Required)
     *     moduleId: String (Optional)
     *     deviceClassId: String (Required)
     *     groupId: String (Optional)
     *     lastAttemptedUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *     installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *     onLatestUpdate: boolean (Required)
     *     lastDeploymentId: String (Optional)
     *     lastInstallResult (Optional): {
     *         resultCode: int (Required)
     *         extendedResultCode: int (Required)
     *         resultDetails: String (Optional)
     *         stepResults (Optional): [
     *              (Optional){
     *                 update (Optional): (recursive schema, see update above)
     *                 description: String (Optional)
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *             }
     *         ]
     *     }
     * }
     * }</pre>
     *
     * @param deviceId Device identifier in Azure IoT Hub.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device properties and latest deployment status for a device connected to Device Update for IoT Hub
     *     along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceWithResponseAsync(String deviceId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getDevice(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                deviceId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets the device properties and latest deployment status for a device connected to Device Update for IoT Hub.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceId: String (Required)
     *     moduleId: String (Optional)
     *     deviceClassId: String (Required)
     *     groupId: String (Optional)
     *     lastAttemptedUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *     installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *     onLatestUpdate: boolean (Required)
     *     lastDeploymentId: String (Optional)
     *     lastInstallResult (Optional): {
     *         resultCode: int (Required)
     *         extendedResultCode: int (Required)
     *         resultDetails: String (Optional)
     *         stepResults (Optional): [
     *              (Optional){
     *                 update (Optional): (recursive schema, see update above)
     *                 description: String (Optional)
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *             }
     *         ]
     *     }
     * }
     * }</pre>
     *
     * @param deviceId Device identifier in Azure IoT Hub.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device properties and latest deployment status for a device connected to Device Update for IoT Hub
     *     along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceWithResponse(String deviceId, RequestOptions requestOptions) {
        return getDeviceWithResponseAsync(deviceId, requestOptions).block();
    }

    /**
     * Gets the device module properties and latest deployment status for a device module connected to Device Update for
     * IoT Hub.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceId: String (Required)
     *     moduleId: String (Optional)
     *     deviceClassId: String (Required)
     *     groupId: String (Optional)
     *     lastAttemptedUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *     installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *     onLatestUpdate: boolean (Required)
     *     lastDeploymentId: String (Optional)
     *     lastInstallResult (Optional): {
     *         resultCode: int (Required)
     *         extendedResultCode: int (Required)
     *         resultDetails: String (Optional)
     *         stepResults (Optional): [
     *              (Optional){
     *                 update (Optional): (recursive schema, see update above)
     *                 description: String (Optional)
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *             }
     *         ]
     *     }
     * }
     * }</pre>
     *
     * @param deviceId Device identifier in Azure IoT Hub.
     * @param moduleId Device module identifier in Azure IoT Hub.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device module properties and latest deployment status for a device module connected to Device Update
     *     for IoT Hub along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceModuleWithResponseAsync(
            String deviceId, String moduleId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getDeviceModule(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                deviceId,
                                moduleId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets the device module properties and latest deployment status for a device module connected to Device Update for
     * IoT Hub.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceId: String (Required)
     *     moduleId: String (Optional)
     *     deviceClassId: String (Required)
     *     groupId: String (Optional)
     *     lastAttemptedUpdate (Optional): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *     installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *     onLatestUpdate: boolean (Required)
     *     lastDeploymentId: String (Optional)
     *     lastInstallResult (Optional): {
     *         resultCode: int (Required)
     *         extendedResultCode: int (Required)
     *         resultDetails: String (Optional)
     *         stepResults (Optional): [
     *              (Optional){
     *                 update (Optional): (recursive schema, see update above)
     *                 description: String (Optional)
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *             }
     *         ]
     *     }
     * }
     * }</pre>
     *
     * @param deviceId Device identifier in Azure IoT Hub.
     * @param moduleId Device module identifier in Azure IoT Hub.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device module properties and latest deployment status for a device module connected to Device Update
     *     for IoT Hub along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceModuleWithResponse(
            String deviceId, String moduleId, RequestOptions requestOptions) {
        return getDeviceModuleWithResponseAsync(deviceId, moduleId, requestOptions).block();
    }

    /**
     * Gets the breakdown of how many devices are on their latest update, have new updates available, or are in progress
     * receiving new updates.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     totalDeviceCount: int (Required)
     *     onLatestUpdateDeviceCount: int (Required)
     *     newUpdatesAvailableDeviceCount: int (Required)
     *     updatesInProgressDeviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the breakdown of how many devices are on their latest update, have new updates available, or are in
     *     progress receiving new updates along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUpdateComplianceWithResponseAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getUpdateCompliance(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets the breakdown of how many devices are on their latest update, have new updates available, or are in progress
     * receiving new updates.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     totalDeviceCount: int (Required)
     *     onLatestUpdateDeviceCount: int (Required)
     *     newUpdatesAvailableDeviceCount: int (Required)
     *     updatesInProgressDeviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the breakdown of how many devices are on their latest update, have new updates available, or are in
     *     progress receiving new updates along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getUpdateComplianceWithResponse(RequestOptions requestOptions) {
        return getUpdateComplianceWithResponseAsync(requestOptions).block();
    }

    /**
     * Gets a list of all device groups. The $default group will always be returned first.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of groups returned. You can order by groupId, deviceCount, createdDate, subgroupsWithNewUpdatesAvailableCount, subgroupsWithUpdatesInProgressCount, or subgroupsOnLatestUpdateCount.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             groupType: String(IoTHubTag/DefaultNoTag) (Required)
     *             createdDateTime: String (Required)
     *             deviceCount: Integer (Optional)
     *             subgroupsWithNewUpdatesAvailableCount: Integer (Optional)
     *             subgroupsWithUpdatesInProgressCount: Integer (Optional)
     *             subgroupsWithOnLatestUpdateCount: Integer (Optional)
     *             deployments (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device groups along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listGroupsSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listGroups(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Gets a list of all device groups. The $default group will always be returned first.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of groups returned. You can order by groupId, deviceCount, createdDate, subgroupsWithNewUpdatesAvailableCount, subgroupsWithUpdatesInProgressCount, or subgroupsOnLatestUpdateCount.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             groupType: String(IoTHubTag/DefaultNoTag) (Required)
     *             createdDateTime: String (Required)
     *             deviceCount: Integer (Optional)
     *             subgroupsWithNewUpdatesAvailableCount: Integer (Optional)
     *             subgroupsWithUpdatesInProgressCount: Integer (Optional)
     *             subgroupsWithOnLatestUpdateCount: Integer (Optional)
     *             deployments (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device groups as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listGroupsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listGroupsSinglePageAsync(requestOptions),
                nextLink -> listGroupsNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Gets a list of all device groups. The $default group will always be returned first.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of groups returned. You can order by groupId, deviceCount, createdDate, subgroupsWithNewUpdatesAvailableCount, subgroupsWithUpdatesInProgressCount, or subgroupsOnLatestUpdateCount.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             groupType: String(IoTHubTag/DefaultNoTag) (Required)
     *             createdDateTime: String (Required)
     *             deviceCount: Integer (Optional)
     *             subgroupsWithNewUpdatesAvailableCount: Integer (Optional)
     *             subgroupsWithUpdatesInProgressCount: Integer (Optional)
     *             subgroupsWithOnLatestUpdateCount: Integer (Optional)
     *             deployments (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device groups as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listGroups(RequestOptions requestOptions) {
        return new PagedIterable<>(listGroupsAsync(requestOptions));
    }

    /**
     * Gets the device group properties.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     groupType: String(IoTHubTag/DefaultNoTag) (Required)
     *     createdDateTime: String (Required)
     *     deviceCount: Integer (Optional)
     *     subgroupsWithNewUpdatesAvailableCount: Integer (Optional)
     *     subgroupsWithUpdatesInProgressCount: Integer (Optional)
     *     subgroupsWithOnLatestUpdateCount: Integer (Optional)
     *     deployments (Optional): [
     *         String (Optional)
     *     ]
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device group properties along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getGroupWithResponseAsync(String groupId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getGroup(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets the device group properties.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     groupType: String(IoTHubTag/DefaultNoTag) (Required)
     *     createdDateTime: String (Required)
     *     deviceCount: Integer (Optional)
     *     subgroupsWithNewUpdatesAvailableCount: Integer (Optional)
     *     subgroupsWithUpdatesInProgressCount: Integer (Optional)
     *     subgroupsWithOnLatestUpdateCount: Integer (Optional)
     *     deployments (Optional): [
     *         String (Optional)
     *     ]
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device group properties along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return getGroupWithResponseAsync(groupId, requestOptions).block();
    }

    /**
     * Deletes a device group. This group is automatically created when a Device Update-enabled device is connected to
     * the hub and reports its properties. Groups, subgroups, and deployments are not automatically cleaned up but are
     * retained for history purposes. Users can call this method to delete a group if they do not need to retain any of
     * the history of the group and no longer need it. If a device is ever connected again for this group after the
     * group was deleted it will be automatically re-created but there will be no history.
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteGroupWithResponseAsync(String groupId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteGroup(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Deletes a device group. This group is automatically created when a Device Update-enabled device is connected to
     * the hub and reports its properties. Groups, subgroups, and deployments are not automatically cleaned up but are
     * retained for history purposes. Users can call this method to delete a group if they do not need to retain any of
     * the history of the group and no longer need it. If a device is ever connected again for this group after the
     * group was deleted it will be automatically re-created but there will be no history.
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return deleteGroupWithResponseAsync(groupId, requestOptions).block();
    }

    /**
     * Get device group update compliance information such as how many devices are on their latest update, how many need
     * new updates, and how many are in progress on receiving a new update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     totalDeviceCount: int (Required)
     *     onLatestUpdateDeviceCount: int (Required)
     *     newUpdatesAvailableDeviceCount: int (Required)
     *     updatesInProgressDeviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device group update compliance information such as how many devices are on their latest update, how many
     *     need new updates, and how many are in progress on receiving a new update along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUpdateComplianceForGroupWithResponseAsync(
            String groupId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getUpdateComplianceForGroup(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Get device group update compliance information such as how many devices are on their latest update, how many need
     * new updates, and how many are in progress on receiving a new update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     totalDeviceCount: int (Required)
     *     onLatestUpdateDeviceCount: int (Required)
     *     newUpdatesAvailableDeviceCount: int (Required)
     *     updatesInProgressDeviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device group update compliance information such as how many devices are on their latest update, how many
     *     need new updates, and how many are in progress on receiving a new update along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getUpdateComplianceForGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return getUpdateComplianceForGroupWithResponseAsync(groupId, requestOptions).block();
    }

    /**
     * Get the best available updates for a device group and a count of how many devices need each update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             deviceClassId: String (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             deviceCount: int (Required)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the best available updates for a device group and a count of how many devices need each update along with
     *     {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listBestUpdatesForGroupSinglePageAsync(
            String groupId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listBestUpdatesForGroup(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        groupId,
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the best available updates for a device group and a count of how many devices need each update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             deviceClassId: String (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             deviceCount: int (Required)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the best available updates for a device group and a count of how many devices need each update as
     *     paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listBestUpdatesForGroupAsync(String groupId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listBestUpdatesForGroupSinglePageAsync(groupId, requestOptions),
                nextLink -> listBestUpdatesForGroupNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Get the best available updates for a device group and a count of how many devices need each update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             deviceClassId: String (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             deviceCount: int (Required)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the best available updates for a device group and a count of how many devices need each update as
     *     paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listBestUpdatesForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable<>(listBestUpdatesForGroupAsync(groupId, requestOptions));
    }

    /**
     * Gets a list of deployments for a device group.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of deployments returned. You can order by start date.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deploymentId: String (Required)
     *             startDateTime: OffsetDateTime (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             groupId: String (Required)
     *             deviceClassSubgroups (Optional): [
     *                 String (Optional)
     *             ]
     *             isCanceled: Boolean (Optional)
     *             isRetried: Boolean (Optional)
     *             rollbackPolicy (Optional): {
     *                 update (Required): (recursive schema, see update above)
     *                 failure (Required): {
     *                     devicesFailedPercentage: int (Required)
     *                     devicesFailedCount: int (Required)
     *                 }
     *             }
     *             isCloudInitiatedRollback: Boolean (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of deployments for a device group along with {@link PagedResponse} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentsForGroupSinglePageAsync(
            String groupId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDeploymentsForGroup(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        groupId,
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Gets a list of deployments for a device group.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of deployments returned. You can order by start date.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deploymentId: String (Required)
     *             startDateTime: OffsetDateTime (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             groupId: String (Required)
     *             deviceClassSubgroups (Optional): [
     *                 String (Optional)
     *             ]
     *             isCanceled: Boolean (Optional)
     *             isRetried: Boolean (Optional)
     *             rollbackPolicy (Optional): {
     *                 update (Required): (recursive schema, see update above)
     *                 failure (Required): {
     *                     devicesFailedPercentage: int (Required)
     *                     devicesFailedCount: int (Required)
     *                 }
     *             }
     *             isCloudInitiatedRollback: Boolean (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of deployments for a device group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeploymentsForGroupAsync(String groupId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listDeploymentsForGroupSinglePageAsync(groupId, requestOptions),
                nextLink -> listDeploymentsForGroupNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Gets a list of deployments for a device group.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of deployments returned. You can order by start date.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deploymentId: String (Required)
     *             startDateTime: OffsetDateTime (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             groupId: String (Required)
     *             deviceClassSubgroups (Optional): [
     *                 String (Optional)
     *             ]
     *             isCanceled: Boolean (Optional)
     *             isRetried: Boolean (Optional)
     *             rollbackPolicy (Optional): {
     *                 update (Required): (recursive schema, see update above)
     *                 failure (Required): {
     *                     devicesFailedPercentage: int (Required)
     *                     devicesFailedCount: int (Required)
     *                 }
     *             }
     *             isCloudInitiatedRollback: Boolean (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of deployments for a device group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeploymentsForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable<>(listDeploymentsForGroupAsync(groupId, requestOptions));
    }

    /**
     * Gets the deployment properties.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the deployment properties along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentWithResponseAsync(
            String groupId, String deploymentId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getDeployment(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deploymentId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets the deployment properties.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the deployment properties along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentWithResponse(
            String groupId, String deploymentId, RequestOptions requestOptions) {
        return getDeploymentWithResponseAsync(groupId, deploymentId, requestOptions).block();
    }

    /**
     * Creates or updates a deployment.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param deployment The deployment properties.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return deployment metadata along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateDeploymentWithResponseAsync(
            String groupId, String deploymentId, BinaryData deployment, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.createOrUpdateDeployment(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deploymentId,
                                this.client.getServiceVersion().getVersion(),
                                deployment,
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Creates or updates a deployment.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param deployment The deployment properties.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return deployment metadata along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateDeploymentWithResponse(
            String groupId, String deploymentId, BinaryData deployment, RequestOptions requestOptions) {
        return createOrUpdateDeploymentWithResponseAsync(groupId, deploymentId, deployment, requestOptions).block();
    }

    /**
     * Deletes a deployment.
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeploymentWithResponseAsync(
            String groupId, String deploymentId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteDeployment(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deploymentId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Deletes a deployment.
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDeploymentWithResponse(
            String groupId, String deploymentId, RequestOptions requestOptions) {
        return deleteDeploymentWithResponseAsync(groupId, deploymentId, requestOptions).block();
    }

    /**
     * Gets the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     * completed, or failed.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     deploymentState: String(Active/ActiveWithSubgroupFailures/Failed/Inactive/Canceled) (Required)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Required)
     *             message: String (Optional)
     *             errorDetail: String (Optional)
     *             innerError (Optional): (recursive schema, see innerError above)
     *         }
     *         occurredDateTime: OffsetDateTime (Optional)
     *     }
     *     subgroupStatus (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             deviceClassId: String (Required)
     *             deploymentState: String(Active/Failed/Inactive/Canceled) (Required)
     *             error (Optional): (recursive schema, see error above)
     *             totalDevices: Integer (Optional)
     *             devicesInProgressCount: Integer (Optional)
     *             devicesCompletedFailedCount: Integer (Optional)
     *             devicesCompletedSucceededCount: Integer (Optional)
     *             devicesCanceledCount: Integer (Optional)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     *     completed, or failed along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentStatusWithResponseAsync(
            String groupId, String deploymentId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getDeploymentStatus(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deploymentId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     * completed, or failed.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     deploymentState: String(Active/ActiveWithSubgroupFailures/Failed/Inactive/Canceled) (Required)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Required)
     *             message: String (Optional)
     *             errorDetail: String (Optional)
     *             innerError (Optional): (recursive schema, see innerError above)
     *         }
     *         occurredDateTime: OffsetDateTime (Optional)
     *     }
     *     subgroupStatus (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             deviceClassId: String (Required)
     *             deploymentState: String(Active/Failed/Inactive/Canceled) (Required)
     *             error (Optional): (recursive schema, see error above)
     *             totalDevices: Integer (Optional)
     *             devicesInProgressCount: Integer (Optional)
     *             devicesCompletedFailedCount: Integer (Optional)
     *             devicesCompletedSucceededCount: Integer (Optional)
     *             devicesCanceledCount: Integer (Optional)
     *         }
     *     ]
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     *     completed, or failed along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentStatusWithResponse(
            String groupId, String deploymentId, RequestOptions requestOptions) {
        return getDeploymentStatusWithResponseAsync(groupId, deploymentId, requestOptions).block();
    }

    /**
     * Get the device class subgroups for the group. A device class subgroup is the set of devices within the group that
     * share the same device class. All devices within the same device class are compatible with the same updates.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of device class subgroups returned. You can filter on compat properties by name and value. (i.e. filter=compatProperties/propertyName1 eq 'value1' and compatProperties/propertyName2 eq 'value2')</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceClassId: String (Required)
     *             groupId: String (Required)
     *             createdDateTime: String (Required)
     *             deviceCount: Integer (Optional)
     *             deploymentId: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device class subgroups for the group along with {@link PagedResponse} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceClassSubgroupsForGroupSinglePageAsync(
            String groupId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDeviceClassSubgroupsForGroup(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        groupId,
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the device class subgroups for the group. A device class subgroup is the set of devices within the group that
     * share the same device class. All devices within the same device class are compatible with the same updates.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of device class subgroups returned. You can filter on compat properties by name and value. (i.e. filter=compatProperties/propertyName1 eq 'value1' and compatProperties/propertyName2 eq 'value2')</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceClassId: String (Required)
     *             groupId: String (Required)
     *             createdDateTime: String (Required)
     *             deviceCount: Integer (Optional)
     *             deploymentId: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device class subgroups for the group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceClassSubgroupsForGroupAsync(String groupId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listDeviceClassSubgroupsForGroupSinglePageAsync(groupId, requestOptions),
                nextLink -> listDeviceClassSubgroupsForGroupNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Get the device class subgroups for the group. A device class subgroup is the set of devices within the group that
     * share the same device class. All devices within the same device class are compatible with the same updates.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of device class subgroups returned. You can filter on compat properties by name and value. (i.e. filter=compatProperties/propertyName1 eq 'value1' and compatProperties/propertyName2 eq 'value2')</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceClassId: String (Required)
     *             groupId: String (Required)
     *             createdDateTime: String (Required)
     *             deviceCount: Integer (Optional)
     *             deploymentId: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device class subgroups for the group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceClassSubgroupsForGroup(String groupId, RequestOptions requestOptions) {
        return new PagedIterable<>(listDeviceClassSubgroupsForGroupAsync(groupId, requestOptions));
    }

    /**
     * Gets device class subgroup details. A device class subgroup is the set of devices within the group that share the
     * same device class. All devices within the same device class are compatible with the same updates.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceClassId: String (Required)
     *     groupId: String (Required)
     *     createdDateTime: String (Required)
     *     deviceCount: Integer (Optional)
     *     deploymentId: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device class subgroup details along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassSubgroupWithResponseAsync(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getDeviceClassSubgroup(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deviceClassId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets device class subgroup details. A device class subgroup is the set of devices within the group that share the
     * same device class. All devices within the same device class are compatible with the same updates.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deviceClassId: String (Required)
     *     groupId: String (Required)
     *     createdDateTime: String (Required)
     *     deviceCount: Integer (Optional)
     *     deploymentId: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device class subgroup details along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassSubgroupWithResponse(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        return getDeviceClassSubgroupWithResponseAsync(groupId, deviceClassId, requestOptions).block();
    }

    /**
     * Deletes a device class subgroup. This subgroup is automatically created when a Device Update-enabled device is
     * connected to the hub and reports its properties. Groups, subgroups, and deployments are not automatically cleaned
     * up but are retained for history purposes. Users can call this method to delete a subgroup if they do not need to
     * retain any of the history of the subgroup and no longer need it. If a device is ever connected again for this
     * subgroup after the subgroup was deleted it will be automatically re-created but there will be no history.
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeviceClassSubgroupWithResponseAsync(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteDeviceClassSubgroup(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deviceClassId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Deletes a device class subgroup. This subgroup is automatically created when a Device Update-enabled device is
     * connected to the hub and reports its properties. Groups, subgroups, and deployments are not automatically cleaned
     * up but are retained for history purposes. Users can call this method to delete a subgroup if they do not need to
     * retain any of the history of the subgroup and no longer need it. If a device is ever connected again for this
     * subgroup after the subgroup was deleted it will be automatically re-created but there will be no history.
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDeviceClassSubgroupWithResponse(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        return deleteDeviceClassSubgroupWithResponseAsync(groupId, deviceClassId, requestOptions).block();
    }

    /**
     * Get device class subgroup update compliance information such as how many devices are on their latest update, how
     * many need new updates, and how many are in progress on receiving a new update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     totalDeviceCount: int (Required)
     *     onLatestUpdateDeviceCount: int (Required)
     *     newUpdatesAvailableDeviceCount: int (Required)
     *     updatesInProgressDeviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device class subgroup update compliance information such as how many devices are on their latest update,
     *     how many need new updates, and how many are in progress on receiving a new update along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassSubgroupUpdateComplianceWithResponseAsync(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getDeviceClassSubgroupUpdateCompliance(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deviceClassId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Get device class subgroup update compliance information such as how many devices are on their latest update, how
     * many need new updates, and how many are in progress on receiving a new update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     totalDeviceCount: int (Required)
     *     onLatestUpdateDeviceCount: int (Required)
     *     newUpdatesAvailableDeviceCount: int (Required)
     *     updatesInProgressDeviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return device class subgroup update compliance information such as how many devices are on their latest update,
     *     how many need new updates, and how many are in progress on receiving a new update along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassSubgroupUpdateComplianceWithResponse(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        return getDeviceClassSubgroupUpdateComplianceWithResponseAsync(groupId, deviceClassId, requestOptions).block();
    }

    /**
     * Get the best available update for a device class subgroup and a count of how many devices need this update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     deviceClassId: String (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     deviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the best available update for a device class subgroup and a count of how many devices need this update
     *     along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getBestUpdatesForDeviceClassSubgroupWithResponseAsync(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getBestUpdatesForDeviceClassSubgroup(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deviceClassId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Get the best available update for a device class subgroup and a count of how many devices need this update.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     deviceClassId: String (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     deviceCount: int (Required)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the best available update for a device class subgroup and a count of how many devices need this update
     *     along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getBestUpdatesForDeviceClassSubgroupWithResponse(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        return getBestUpdatesForDeviceClassSubgroupWithResponseAsync(groupId, deviceClassId, requestOptions).block();
    }

    /**
     * Gets a list of deployments for a device class subgroup.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of deployments returned. You can order by start date.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deploymentId: String (Required)
     *             startDateTime: OffsetDateTime (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             groupId: String (Required)
     *             deviceClassSubgroups (Optional): [
     *                 String (Optional)
     *             ]
     *             isCanceled: Boolean (Optional)
     *             isRetried: Boolean (Optional)
     *             rollbackPolicy (Optional): {
     *                 update (Required): (recursive schema, see update above)
     *                 failure (Required): {
     *                     devicesFailedPercentage: int (Required)
     *                     devicesFailedCount: int (Required)
     *                 }
     *             }
     *             isCloudInitiatedRollback: Boolean (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of deployments for a device class subgroup along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentsForDeviceClassSubgroupSinglePageAsync(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDeploymentsForDeviceClassSubgroup(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        groupId,
                                        deviceClassId,
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Gets a list of deployments for a device class subgroup.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of deployments returned. You can order by start date.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deploymentId: String (Required)
     *             startDateTime: OffsetDateTime (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             groupId: String (Required)
     *             deviceClassSubgroups (Optional): [
     *                 String (Optional)
     *             ]
     *             isCanceled: Boolean (Optional)
     *             isRetried: Boolean (Optional)
     *             rollbackPolicy (Optional): {
     *                 update (Required): (recursive schema, see update above)
     *                 failure (Required): {
     *                     devicesFailedPercentage: int (Required)
     *                     devicesFailedCount: int (Required)
     *                 }
     *             }
     *             isCloudInitiatedRollback: Boolean (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of deployments for a device class subgroup as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeploymentsForDeviceClassSubgroupAsync(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listDeploymentsForDeviceClassSubgroupSinglePageAsync(groupId, deviceClassId, requestOptions),
                nextLink ->
                        listDeploymentsForDeviceClassSubgroupNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Gets a list of deployments for a device class subgroup.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>orderby</td><td>String</td><td>No</td><td>Orders the set of deployments returned. You can order by start date.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deploymentId: String (Required)
     *             startDateTime: OffsetDateTime (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             groupId: String (Required)
     *             deviceClassSubgroups (Optional): [
     *                 String (Optional)
     *             ]
     *             isCanceled: Boolean (Optional)
     *             isRetried: Boolean (Optional)
     *             rollbackPolicy (Optional): {
     *                 update (Required): (recursive schema, see update above)
     *                 failure (Required): {
     *                     devicesFailedPercentage: int (Required)
     *                     devicesFailedCount: int (Required)
     *                 }
     *             }
     *             isCloudInitiatedRollback: Boolean (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of deployments for a device class subgroup as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeploymentsForDeviceClassSubgroup(
            String groupId, String deviceClassId, RequestOptions requestOptions) {
        return new PagedIterable<>(listDeploymentsForDeviceClassSubgroupAsync(groupId, deviceClassId, requestOptions));
    }

    /**
     * Gets the deployment properties.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the deployment properties along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentForDeviceClassSubgroupWithResponseAsync(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getDeploymentForDeviceClassSubgroup(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deviceClassId,
                                deploymentId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets the deployment properties.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the deployment properties along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeploymentForDeviceClassSubgroupWithResponse(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return getDeploymentForDeviceClassSubgroupWithResponseAsync(
                        groupId, deviceClassId, deploymentId, requestOptions)
                .block();
    }

    /**
     * Deletes a device class subgroup deployment.
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeploymentForDeviceClassSubgroupWithResponseAsync(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteDeploymentForDeviceClassSubgroup(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deviceClassId,
                                deploymentId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Deletes a device class subgroup deployment.
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDeploymentForDeviceClassSubgroupWithResponse(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return deleteDeploymentForDeviceClassSubgroupWithResponseAsync(
                        groupId, deviceClassId, deploymentId, requestOptions)
                .block();
    }

    /**
     * Stops a deployment.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return deployment metadata along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> stopDeploymentWithResponseAsync(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.stopDeployment(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deviceClassId,
                                deploymentId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Stops a deployment.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return deployment metadata along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> stopDeploymentWithResponse(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return stopDeploymentWithResponseAsync(groupId, deviceClassId, deploymentId, requestOptions).block();
    }

    /**
     * Retries a deployment with failed devices.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return deployment metadata along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> retryDeploymentWithResponseAsync(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.retryDeployment(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deviceClassId,
                                deploymentId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Retries a deployment with failed devices.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     deploymentId: String (Required)
     *     startDateTime: OffsetDateTime (Required)
     *     update (Required): {
     *         updateId (Required): {
     *             provider: String (Required)
     *             name: String (Required)
     *             version: String (Required)
     *         }
     *         description: String (Optional)
     *         friendlyName: String (Optional)
     *     }
     *     groupId: String (Required)
     *     deviceClassSubgroups (Optional): [
     *         String (Optional)
     *     ]
     *     isCanceled: Boolean (Optional)
     *     isRetried: Boolean (Optional)
     *     rollbackPolicy (Optional): {
     *         update (Required): (recursive schema, see update above)
     *         failure (Required): {
     *             devicesFailedPercentage: int (Required)
     *             devicesFailedCount: int (Required)
     *         }
     *     }
     *     isCloudInitiatedRollback: Boolean (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return deployment metadata along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> retryDeploymentWithResponse(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return retryDeploymentWithResponseAsync(groupId, deviceClassId, deploymentId, requestOptions).block();
    }

    /**
     * Gets the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     * completed, or failed.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     deviceClassId: String (Required)
     *     deploymentState: String(Active/Failed/Inactive/Canceled) (Required)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Required)
     *             message: String (Optional)
     *             errorDetail: String (Optional)
     *             innerError (Optional): (recursive schema, see innerError above)
     *         }
     *         occurredDateTime: OffsetDateTime (Optional)
     *     }
     *     totalDevices: Integer (Optional)
     *     devicesInProgressCount: Integer (Optional)
     *     devicesCompletedFailedCount: Integer (Optional)
     *     devicesCompletedSucceededCount: Integer (Optional)
     *     devicesCanceledCount: Integer (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     *     completed, or failed along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassSubgroupDeploymentStatusWithResponseAsync(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getDeviceClassSubgroupDeploymentStatus(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                groupId,
                                deviceClassId,
                                deploymentId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Gets the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     * completed, or failed.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     groupId: String (Required)
     *     deviceClassId: String (Required)
     *     deploymentState: String(Active/Failed/Inactive/Canceled) (Required)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Required)
     *             message: String (Optional)
     *             errorDetail: String (Optional)
     *             innerError (Optional): (recursive schema, see innerError above)
     *         }
     *         occurredDateTime: OffsetDateTime (Optional)
     *     }
     *     totalDevices: Integer (Optional)
     *     devicesInProgressCount: Integer (Optional)
     *     devicesCompletedFailedCount: Integer (Optional)
     *     devicesCompletedSucceededCount: Integer (Optional)
     *     devicesCanceledCount: Integer (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a deployment including a breakdown of how many devices in the deployment are in progress,
     *     completed, or failed along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getDeviceClassSubgroupDeploymentStatusWithResponse(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return getDeviceClassSubgroupDeploymentStatusWithResponseAsync(
                        groupId, deviceClassId, deploymentId, requestOptions)
                .block();
    }

    /**
     * Gets a list of devices in a deployment along with their state. Useful for getting a list of failed devices.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of deployment device states returned. You can filter on deviceId and moduleId and/or deviceState.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             retryCount: int (Required)
     *             movedOnToNewDeployment: boolean (Required)
     *             deviceState: String(Succeeded/InProgress/Canceled/Failed) (Required)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of devices in a deployment along with their state along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceStatesForDeviceClassSubgroupDeploymentSinglePageAsync(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDeviceStatesForDeviceClassSubgroupDeployment(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        groupId,
                                        deviceClassId,
                                        deploymentId,
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Gets a list of devices in a deployment along with their state. Useful for getting a list of failed devices.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of deployment device states returned. You can filter on deviceId and moduleId and/or deviceState.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             retryCount: int (Required)
     *             movedOnToNewDeployment: boolean (Required)
     *             deviceState: String(Succeeded/InProgress/Canceled/Failed) (Required)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of devices in a deployment along with their state as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceStatesForDeviceClassSubgroupDeploymentAsync(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () ->
                        listDeviceStatesForDeviceClassSubgroupDeploymentSinglePageAsync(
                                groupId, deviceClassId, deploymentId, requestOptions),
                nextLink ->
                        listDeviceStatesForDeviceClassSubgroupDeploymentNextSinglePageAsync(
                                nextLink, requestOptionsForNextPage));
    }

    /**
     * Gets a list of devices in a deployment along with their state. Useful for getting a list of failed devices.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of deployment device states returned. You can filter on deviceId and moduleId and/or deviceState.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             retryCount: int (Required)
     *             movedOnToNewDeployment: boolean (Required)
     *             deviceState: String(Succeeded/InProgress/Canceled/Failed) (Required)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param groupId Group identifier.
     * @param deviceClassId Device class identifier.
     * @param deploymentId Deployment identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of devices in a deployment along with their state as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDeviceStatesForDeviceClassSubgroupDeployment(
            String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return new PagedIterable<>(
                listDeviceStatesForDeviceClassSubgroupDeploymentAsync(
                        groupId, deviceClassId, deploymentId, requestOptions));
    }

    /**
     * Retrieve operation status.
     *
     * <p><strong>Header Parameters</strong>
     *
     * <table border="1">
     *     <caption>Header Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>If-None-Match</td><td>String</td><td>No</td><td>Defines the If-None-Match condition. The operation will be performed only if the ETag on the server does not match this value.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addHeader}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Required)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Required)
     *             message: String (Optional)
     *             errorDetail: String (Optional)
     *             innerError (Optional): (recursive schema, see innerError above)
     *         }
     *         occurredDateTime: OffsetDateTime (Optional)
     *     }
     *     traceId: String (Optional)
     *     lastActionDateTime: OffsetDateTime (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     etag: String (Optional)
     * }
     * }</pre>
     *
     * @param operationId Operation identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return operation metadata along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationStatusWithResponseAsync(
            String operationId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getOperationStatus(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                operationId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Retrieve operation status.
     *
     * <p><strong>Header Parameters</strong>
     *
     * <table border="1">
     *     <caption>Header Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>If-None-Match</td><td>String</td><td>No</td><td>Defines the If-None-Match condition. The operation will be performed only if the ETag on the server does not match this value.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addHeader}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Required)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Required)
     *             message: String (Optional)
     *             errorDetail: String (Optional)
     *             innerError (Optional): (recursive schema, see innerError above)
     *         }
     *         occurredDateTime: OffsetDateTime (Optional)
     *     }
     *     traceId: String (Optional)
     *     lastActionDateTime: OffsetDateTime (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     etag: String (Optional)
     * }
     * }</pre>
     *
     * @param operationId Operation identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return operation metadata along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getOperationStatusWithResponse(String operationId, RequestOptions requestOptions) {
        return getOperationStatusWithResponseAsync(operationId, requestOptions).block();
    }

    /**
     * Get a list of all device import operations. Completed operations are kept for 7 days before auto-deleted.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of operations returned. Only one specific filter is supported: "status eq 'NotStarted' or status eq 'Running'"</td></tr>
     *     <tr><td>top</td><td>Integer</td><td>No</td><td>Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the number of available items up to but not greater than the specified value n.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             operationId: String (Required)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *             error (Optional): {
     *                 code: String (Required)
     *                 message: String (Required)
     *                 target: String (Optional)
     *                 details (Optional): [
     *                     (recursive schema, see above)
     *                 ]
     *                 innererror (Optional): {
     *                     code: String (Required)
     *                     message: String (Optional)
     *                     errorDetail: String (Optional)
     *                     innerError (Optional): (recursive schema, see innerError above)
     *                 }
     *                 occurredDateTime: OffsetDateTime (Optional)
     *             }
     *             traceId: String (Optional)
     *             lastActionDateTime: OffsetDateTime (Required)
     *             createdDateTime: OffsetDateTime (Required)
     *             etag: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device import operations along with {@link PagedResponse} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listOperationStatusesSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listOperationStatuses(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get a list of all device import operations. Completed operations are kept for 7 days before auto-deleted.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of operations returned. Only one specific filter is supported: "status eq 'NotStarted' or status eq 'Running'"</td></tr>
     *     <tr><td>top</td><td>Integer</td><td>No</td><td>Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the number of available items up to but not greater than the specified value n.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             operationId: String (Required)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *             error (Optional): {
     *                 code: String (Required)
     *                 message: String (Required)
     *                 target: String (Optional)
     *                 details (Optional): [
     *                     (recursive schema, see above)
     *                 ]
     *                 innererror (Optional): {
     *                     code: String (Required)
     *                     message: String (Optional)
     *                     errorDetail: String (Optional)
     *                     innerError (Optional): (recursive schema, see innerError above)
     *                 }
     *                 occurredDateTime: OffsetDateTime (Optional)
     *             }
     *             traceId: String (Optional)
     *             lastActionDateTime: OffsetDateTime (Required)
     *             createdDateTime: OffsetDateTime (Required)
     *             etag: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device import operations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperationStatusesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listOperationStatusesSinglePageAsync(requestOptions),
                nextLink -> listOperationStatusesNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Get a list of all device import operations. Completed operations are kept for 7 days before auto-deleted.
     *
     * <p><strong>Query Parameters</strong>
     *
     * <table border="1">
     *     <caption>Query Parameters</caption>
     *     <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     *     <tr><td>filter</td><td>String</td><td>No</td><td>Restricts the set of operations returned. Only one specific filter is supported: "status eq 'NotStarted' or status eq 'Running'"</td></tr>
     *     <tr><td>top</td><td>Integer</td><td>No</td><td>Specifies a non-negative integer n that limits the number of items returned from a collection. The service returns the number of available items up to but not greater than the specified value n.</td></tr>
     * </table>
     *
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             operationId: String (Required)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *             error (Optional): {
     *                 code: String (Required)
     *                 message: String (Required)
     *                 target: String (Optional)
     *                 details (Optional): [
     *                     (recursive schema, see above)
     *                 ]
     *                 innererror (Optional): {
     *                     code: String (Required)
     *                     message: String (Optional)
     *                     errorDetail: String (Optional)
     *                     innerError (Optional): (recursive schema, see innerError above)
     *                 }
     *                 occurredDateTime: OffsetDateTime (Optional)
     *             }
     *             traceId: String (Optional)
     *             lastActionDateTime: OffsetDateTime (Required)
     *             createdDateTime: OffsetDateTime (Required)
     *             etag: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of all device import operations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperationStatuses(RequestOptions requestOptions) {
        return new PagedIterable<>(listOperationStatusesAsync(requestOptions));
    }

    /**
     * Start the device diagnostics log collection on specified devices.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     deviceList (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     deviceList (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     * }
     * }</pre>
     *
     * @param logCollectionId Log collection identifier.
     * @param logCollection The log collection properties.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return diagnostics request body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> startLogCollectionWithResponseAsync(
            String logCollectionId, BinaryData logCollection, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.startLogCollection(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                logCollectionId,
                                this.client.getServiceVersion().getVersion(),
                                logCollection,
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Start the device diagnostics log collection on specified devices.
     *
     * <p><strong>Request Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     deviceList (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     * }
     * }</pre>
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     deviceList (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     * }
     * }</pre>
     *
     * @param logCollectionId Log collection identifier.
     * @param logCollection The log collection properties.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return diagnostics request body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> startLogCollectionWithResponse(
            String logCollectionId, BinaryData logCollection, RequestOptions requestOptions) {
        return startLogCollectionWithResponseAsync(logCollectionId, logCollection, requestOptions).block();
    }

    /**
     * Get the device diagnostics log collection.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     deviceList (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     * }
     * }</pre>
     *
     * @param logCollectionId Log collection identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device diagnostics log collection along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogCollectionWithResponseAsync(
            String logCollectionId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getLogCollection(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                logCollectionId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Get the device diagnostics log collection.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     deviceList (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     * }
     * }</pre>
     *
     * @param logCollectionId Log collection identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the device diagnostics log collection along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getLogCollectionWithResponse(String logCollectionId, RequestOptions requestOptions) {
        return getLogCollectionWithResponseAsync(logCollectionId, requestOptions).block();
    }

    /**
     * Get all device diagnostics log collections.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             operationId: String (Optional)
     *             deviceList (Required): [
     *                  (Required){
     *                     deviceId: String (Required)
     *                     moduleId: String (Optional)
     *                 }
     *             ]
     *             description: String (Optional)
     *             createdDateTime: String (Optional)
     *             lastActionDateTime: String (Optional)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return all device diagnostics log collections along with {@link PagedResponse} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listLogCollectionsSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listLogCollections(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        this.client.getServiceVersion().getVersion(),
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get all device diagnostics log collections.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             operationId: String (Optional)
     *             deviceList (Required): [
     *                  (Required){
     *                     deviceId: String (Required)
     *                     moduleId: String (Optional)
     *                 }
     *             ]
     *             description: String (Optional)
     *             createdDateTime: String (Optional)
     *             lastActionDateTime: String (Optional)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return all device diagnostics log collections as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLogCollectionsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listLogCollectionsSinglePageAsync(requestOptions),
                nextLink -> listLogCollectionsNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Get all device diagnostics log collections.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             operationId: String (Optional)
     *             deviceList (Required): [
     *                  (Required){
     *                     deviceId: String (Required)
     *                     moduleId: String (Optional)
     *                 }
     *             ]
     *             description: String (Optional)
     *             createdDateTime: String (Optional)
     *             lastActionDateTime: String (Optional)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return all device diagnostics log collections as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listLogCollections(RequestOptions requestOptions) {
        return new PagedIterable<>(listLogCollectionsAsync(requestOptions));
    }

    /**
     * Get log collection with detailed status.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     *     deviceStatus (Optional): [
     *          (Optional){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *             resultCode: String (Optional)
     *             extendedResultCode: String (Optional)
     *             logLocation: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     * }
     * }</pre>
     *
     * @param logCollectionId Log collection identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return log collection with detailed status along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogCollectionDetailedStatusWithResponseAsync(
            String logCollectionId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getLogCollectionDetailedStatus(
                                this.client.getEndpoint(),
                                this.client.getInstanceId(),
                                logCollectionId,
                                this.client.getServiceVersion().getVersion(),
                                accept,
                                requestOptions,
                                context));
    }

    /**
     * Get log collection with detailed status.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     operationId: String (Optional)
     *     createdDateTime: String (Optional)
     *     lastActionDateTime: String (Optional)
     *     status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     *     deviceStatus (Optional): [
     *          (Optional){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *             resultCode: String (Optional)
     *             extendedResultCode: String (Optional)
     *             logLocation: String (Optional)
     *         }
     *     ]
     *     description: String (Optional)
     * }
     * }</pre>
     *
     * @param logCollectionId Log collection identifier.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return log collection with detailed status along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getLogCollectionDetailedStatusWithResponse(
            String logCollectionId, RequestOptions requestOptions) {
        return getLogCollectionDetailedStatusWithResponseAsync(logCollectionId, requestOptions).block();
    }

    /**
     * Get list of device health.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             state: String(healthy/unhealthy) (Required)
     *             digitalTwinModelId: String (Optional)
     *             healthChecks (Required): [
     *                  (Required){
     *                     name: String (Optional)
     *                     result: String(success/userError) (Optional)
     *                 }
     *             ]
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param filter Restricts the set of devices for which device health is returned. You can filter on status, device
     *     id and module id.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return list of device health along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listHealthOfDevicesSinglePageAsync(
            String filter, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listHealthOfDevices(
                                        this.client.getEndpoint(),
                                        this.client.getInstanceId(),
                                        this.client.getServiceVersion().getVersion(),
                                        filter,
                                        accept,
                                        requestOptions,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get list of device health.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             state: String(healthy/unhealthy) (Required)
     *             digitalTwinModelId: String (Optional)
     *             healthChecks (Required): [
     *                  (Required){
     *                     name: String (Optional)
     *                     result: String(success/userError) (Optional)
     *                 }
     *             ]
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param filter Restricts the set of devices for which device health is returned. You can filter on status, device
     *     id and module id.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return list of device health as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listHealthOfDevicesAsync(String filter, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
                requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE);
        return new PagedFlux<>(
                () -> listHealthOfDevicesSinglePageAsync(filter, requestOptions),
                nextLink -> listHealthOfDevicesNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Get list of device health.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             state: String(healthy/unhealthy) (Required)
     *             digitalTwinModelId: String (Optional)
     *             healthChecks (Required): [
     *                  (Required){
     *                     name: String (Optional)
     *                     result: String(success/userError) (Optional)
     *                 }
     *             ]
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param filter Restricts the set of devices for which device health is returned. You can filter on status, device
     *     id and module id.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return list of device health as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listHealthOfDevices(String filter, RequestOptions requestOptions) {
        return new PagedIterable<>(listHealthOfDevicesAsync(filter, requestOptions));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceClassId: String (Required)
     *             friendlyName: String (Optional)
     *             deviceClassProperties (Required): {
     *                 contractModel (Optional): {
     *                     id: String (Required)
     *                     name: String (Required)
     *                 }
     *                 compatProperties (Required): {
     *                     String: String (Required)
     *                 }
     *             }
     *             bestCompatibleUpdate (Optional): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the list of device classes along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceClassesNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDeviceClassesNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             updateId (Required): {
     *                 provider: String (Required)
     *                 name: String (Required)
     *                 version: String (Required)
     *             }
     *             description: String (Optional)
     *             friendlyName: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return list of update information along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listInstallableUpdatesForDeviceClassNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listInstallableUpdatesForDeviceClassNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             deviceClassId: String (Required)
     *             groupId: String (Optional)
     *             lastAttemptedUpdate (Optional): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             deploymentStatus: String(Succeeded/InProgress/Canceled/Failed) (Optional)
     *             installedUpdate (Optional): (recursive schema, see installedUpdate above)
     *             onLatestUpdate: boolean (Required)
     *             lastDeploymentId: String (Optional)
     *             lastInstallResult (Optional): {
     *                 resultCode: int (Required)
     *                 extendedResultCode: int (Required)
     *                 resultDetails: String (Optional)
     *                 stepResults (Optional): [
     *                      (Optional){
     *                         update (Optional): (recursive schema, see update above)
     *                         description: String (Optional)
     *                         resultCode: int (Required)
     *                         extendedResultCode: int (Required)
     *                         resultDetails: String (Optional)
     *                     }
     *                 ]
     *             }
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the list of devices along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDevicesNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDevicesNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             groupType: String(IoTHubTag/DefaultNoTag) (Required)
     *             createdDateTime: String (Required)
     *             deviceCount: Integer (Optional)
     *             subgroupsWithNewUpdatesAvailableCount: Integer (Optional)
     *             subgroupsWithUpdatesInProgressCount: Integer (Optional)
     *             subgroupsWithOnLatestUpdateCount: Integer (Optional)
     *             deployments (Optional): [
     *                 String (Optional)
     *             ]
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the list of groups along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listGroupsNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listGroupsNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             groupId: String (Required)
     *             deviceClassId: String (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             deviceCount: int (Required)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the list of updatable devices for a device class subgroup along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listBestUpdatesForGroupNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listBestUpdatesForGroupNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deploymentId: String (Required)
     *             startDateTime: OffsetDateTime (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             groupId: String (Required)
     *             deviceClassSubgroups (Optional): [
     *                 String (Optional)
     *             ]
     *             isCanceled: Boolean (Optional)
     *             isRetried: Boolean (Optional)
     *             rollbackPolicy (Optional): {
     *                 update (Required): (recursive schema, see update above)
     *                 failure (Required): {
     *                     devicesFailedPercentage: int (Required)
     *                     devicesFailedCount: int (Required)
     *                 }
     *             }
     *             isCloudInitiatedRollback: Boolean (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentsForGroupNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDeploymentsForGroupNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceClassId: String (Required)
     *             groupId: String (Required)
     *             createdDateTime: String (Required)
     *             deviceCount: Integer (Optional)
     *             deploymentId: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the list of device class subgroups within a group along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceClassSubgroupsForGroupNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDeviceClassSubgroupsForGroupNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deploymentId: String (Required)
     *             startDateTime: OffsetDateTime (Required)
     *             update (Required): {
     *                 updateId (Required): {
     *                     provider: String (Required)
     *                     name: String (Required)
     *                     version: String (Required)
     *                 }
     *                 description: String (Optional)
     *                 friendlyName: String (Optional)
     *             }
     *             groupId: String (Required)
     *             deviceClassSubgroups (Optional): [
     *                 String (Optional)
     *             ]
     *             isCanceled: Boolean (Optional)
     *             isRetried: Boolean (Optional)
     *             rollbackPolicy (Optional): {
     *                 update (Required): (recursive schema, see update above)
     *                 failure (Required): {
     *                     devicesFailedPercentage: int (Required)
     *                     devicesFailedCount: int (Required)
     *                 }
     *             }
     *             isCloudInitiatedRollback: Boolean (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the list of deployments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeploymentsForDeviceClassSubgroupNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDeploymentsForDeviceClassSubgroupNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             retryCount: int (Required)
     *             movedOnToNewDeployment: boolean (Required)
     *             deviceState: String(Succeeded/InProgress/Canceled/Failed) (Required)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the list of deployment device states along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listDeviceStatesForDeviceClassSubgroupDeploymentNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDeviceStatesForDeviceClassSubgroupDeploymentNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             operationId: String (Required)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Required)
     *             error (Optional): {
     *                 code: String (Required)
     *                 message: String (Required)
     *                 target: String (Optional)
     *                 details (Optional): [
     *                     (recursive schema, see above)
     *                 ]
     *                 innererror (Optional): {
     *                     code: String (Required)
     *                     message: String (Optional)
     *                     errorDetail: String (Optional)
     *                     innerError (Optional): (recursive schema, see innerError above)
     *                 }
     *                 occurredDateTime: OffsetDateTime (Optional)
     *             }
     *             traceId: String (Optional)
     *             lastActionDateTime: OffsetDateTime (Required)
     *             createdDateTime: OffsetDateTime (Required)
     *             etag: String (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the list of device operations with server paging support along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listOperationStatusesNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listOperationStatusesNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             operationId: String (Optional)
     *             deviceList (Required): [
     *                  (Required){
     *                     deviceId: String (Required)
     *                     moduleId: String (Optional)
     *                 }
     *             ]
     *             description: String (Optional)
     *             createdDateTime: String (Optional)
     *             lastActionDateTime: String (Optional)
     *             status: String(NotStarted/Running/Succeeded/Failed) (Optional)
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the list of log collections with server paging support along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listLogCollectionsNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listLogCollectionsNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * <p><strong>Response Body Schema</strong>
     *
     * <pre>{@code
     * {
     *     value (Required): [
     *          (Required){
     *             deviceId: String (Required)
     *             moduleId: String (Optional)
     *             state: String(healthy/unhealthy) (Required)
     *             digitalTwinModelId: String (Optional)
     *             healthChecks (Required): [
     *                  (Required){
     *                     name: String (Optional)
     *                     result: String(success/userError) (Optional)
     *                 }
     *             ]
     *         }
     *     ]
     *     nextLink: String (Optional)
     * }
     * }</pre>
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return array of Device Health, with server paging support along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<BinaryData>> listHealthOfDevicesNextSinglePageAsync(
            String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listHealthOfDevicesNext(
                                        nextLink, this.client.getEndpoint(), accept, requestOptions, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        getValues(res.getValue(), "value"),
                                        getNextLink(res.getValue(), "nextLink"),
                                        null));
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            List<?> values = (List<?>) obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        } catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            return (String) obj.get(path);
        } catch (RuntimeException e) {
            return null;
        }
    }
}
