/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.ingestion;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.monitor.ingestion.LogsIngestionAsyncClient;
import com.azure.monitor.ingestion.LogsIngestionClientBuilder;
import com.azure.monitor.ingestion.models.LogsUploadOptions;

@ServiceClient(builder=LogsIngestionClientBuilder.class)
public final class LogsIngestionClient {
    private final LogsIngestionAsyncClient asyncClient;

    LogsIngestionClient(LogsIngestionAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(String ruleId, String streamName, Iterable<Object> logs) {
        this.asyncClient.upload(ruleId, streamName, logs).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(String ruleId, String streamName, Iterable<Object> logs, LogsUploadOptions options) {
        this.asyncClient.upload(ruleId, streamName, logs, options, Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(String ruleId, String streamName, Iterable<Object> logs, LogsUploadOptions options, Context context) {
        this.asyncClient.upload(ruleId, streamName, logs, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> uploadWithResponse(String ruleId, String streamName, BinaryData logs, RequestOptions requestOptions) {
        return (Response)this.asyncClient.uploadWithResponse(ruleId, streamName, logs, requestOptions).block();
    }
}

