/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.certificates;

import com.azure.security.keyvault.jca.implementation.JreKeyStoreFactory;
import com.azure.security.keyvault.jca.implementation.certificates.AzureCertificates;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JreCertificates
implements AzureCertificates {
    private static final Logger LOGGER = Logger.getLogger(JreCertificates.class.getName());
    private final List<String> aliases;
    private final Map<String, Certificate> certs;
    private final Map<String, Key> keys;
    private static final JreCertificates INSTANCE = new JreCertificates();

    private JreCertificates() {
        KeyStore jreKeyStore = JreKeyStoreFactory.getDefaultKeyStore();
        this.aliases = Optional.ofNullable(jreKeyStore).map(a -> {
            try {
                return Collections.unmodifiableList(Collections.list(a.aliases()));
            }
            catch (KeyStoreException e) {
                LOGGER.log(Level.WARNING, "Unable to load the jre key store aliases.", e);
                return null;
            }
        }).orElseGet(Collections::emptyList);
        this.certs = this.aliases.stream().collect(HashMap::new, (m, v) -> {
            try {
                m.put(v, jreKeyStore.getCertificate((String)v));
            }
            catch (KeyStoreException e) {
                LOGGER.log(Level.WARNING, "Unable to get the jre key store certificate.", e);
            }
        }, HashMap::putAll);
        this.keys = Collections.emptyMap();
    }

    public static JreCertificates getInstance() {
        return INSTANCE;
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public Map<String, Certificate> getCertificates() {
        return this.certs;
    }

    @Override
    public Map<String, Key> getCertificateKeys() {
        return this.keys;
    }

    @Override
    public void deleteEntry(String alias) {
    }
}

