/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.client.protocol;

import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.HttpEntity;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.HttpEntityEnclosingRequest;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.HttpException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.HttpRequest;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.HttpRequestInterceptor;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.HttpVersion;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.ProtocolVersion;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.annotation.Contract;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.annotation.ThreadingBehavior;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.client.config.RequestConfig;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.client.protocol.HttpClientContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.protocol.HttpContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

