/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import reactor.core.publisher.Mono;

public final class ServiceVersionValidationPolicy
implements HttpPipelinePolicy {
    private final String expectedServiceVersion;

    public ServiceVersionValidationPolicy(String expectedServiceVersion) {
        this.expectedServiceVersion = expectedServiceVersion;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        String actualServiceVersion = httpPipelineCallContext.getHttpRequest().getHeaders().getValue("x-ms-version");
        assert (this.expectedServiceVersion.equals(actualServiceVersion));
        return httpPipelineNextPolicy.process();
    }

    public HttpPipelinePosition getPipelinePosition() {
        return HttpPipelinePosition.PER_CALL;
    }
}

