/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.credentials;

import com.azure.core.implementation.util.ImplUtils;
import java.util.HashMap;

public final class SASTokenCredential {
    private static final String SIGNED_VERSION = "sv";
    private static final String SIGNED_SERVICES = "ss";
    private static final String SIGNED_RESOURCE_TYPES = "srt";
    private static final String SIGNED_PERMISSIONS = "sp";
    private static final String SIGNED_EXPIRY = "se";
    private static final String SIGNATURE = "sig";
    private static final String SIGNED_START = "st";
    private static final String SIGNED_PROTOCOL = "spr";
    private static final String SIGNED_IP = "sip";
    private final String sasToken;

    public SASTokenCredential(String sasToken) {
        this.sasToken = sasToken;
    }

    public String sasToken() {
        return this.sasToken;
    }

    public static SASTokenCredential fromQuery(String query) {
        if (ImplUtils.isNullOrEmpty((CharSequence)query)) {
            return null;
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (String queryParam : query.split("&")) {
            String key = queryParam.split("=", 2)[0];
            queryParams.put(key, queryParam);
        }
        if (!(queryParams.size() >= 6 && queryParams.containsKey(SIGNED_VERSION) && queryParams.containsKey(SIGNED_SERVICES) && queryParams.containsKey(SIGNED_RESOURCE_TYPES) && queryParams.containsKey(SIGNED_PERMISSIONS) && queryParams.containsKey(SIGNED_EXPIRY) && queryParams.containsKey(SIGNATURE))) {
            return null;
        }
        StringBuilder sasTokenBuilder = new StringBuilder((String)queryParams.get(SIGNED_VERSION)).append("&").append((String)queryParams.get(SIGNED_SERVICES)).append("&").append((String)queryParams.get(SIGNED_RESOURCE_TYPES)).append("&").append((String)queryParams.get(SIGNED_PERMISSIONS));
        if (queryParams.containsKey(SIGNED_START)) {
            sasTokenBuilder.append("&").append((String)queryParams.get(SIGNED_START));
        }
        sasTokenBuilder.append("&").append((String)queryParams.get(SIGNED_EXPIRY));
        if (queryParams.containsKey(SIGNED_IP)) {
            sasTokenBuilder.append("&").append((String)queryParams.get(SIGNED_IP));
        }
        if (queryParams.containsKey(SIGNED_PROTOCOL)) {
            sasTokenBuilder.append("&").append((String)queryParams.get(SIGNED_PROTOCOL));
        }
        sasTokenBuilder.append("&").append((String)queryParams.get(SIGNATURE));
        return new SASTokenCredential(sasTokenBuilder.toString());
    }
}

