/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.credentials;

import com.azure.core.implementation.util.ImplUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.credentials.SASTokenCredential;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class SharedKeyCredential {
    private final ClientLogger logger = new ClientLogger(SASTokenCredential.class);
    private static final String AUTHORIZATION_HEADER_FORMAT = "SharedKey %s:%s";
    private static final String ACCOUNT_NAME = "accountname";
    private static final String ACCOUNT_KEY = "accountkey";
    private final String accountName;
    private final byte[] accountKey;

    public SharedKeyCredential(String accountName, String accountKey) {
        Objects.requireNonNull(accountName);
        Objects.requireNonNull(accountKey);
        this.accountName = accountName;
        this.accountKey = Base64.getDecoder().decode(accountKey);
    }

    public static SharedKeyCredential fromConnectionString(String connectionString) {
        HashMap<String, String> connectionStringPieces = new HashMap<String, String>();
        for (String connectionStringPiece : connectionString.split(";")) {
            String[] kvp = connectionStringPiece.split("=", 2);
            connectionStringPieces.put(kvp[0].toLowerCase(Locale.ROOT), kvp[1]);
        }
        String accountName = (String)connectionStringPieces.get(ACCOUNT_NAME);
        String accountKey = (String)connectionStringPieces.get(ACCOUNT_KEY);
        if (ImplUtils.isNullOrEmpty((CharSequence)accountName) || ImplUtils.isNullOrEmpty((CharSequence)accountKey)) {
            throw new IllegalArgumentException("Connection string must contain 'AccountName' and 'AccountKey'.");
        }
        return new SharedKeyCredential(accountName, accountKey);
    }

    public String accountName() {
        return this.accountName;
    }

    public String generateAuthorizationHeader(URL requestURL, String httpMethod, Map<String, String> headers) {
        return this.computeHMACSHA256(this.buildStringToSign(requestURL, httpMethod, headers));
    }

    public String computeHmac256(String stringToSign) {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            hmacSha256.init(new SecretKeySpec(this.accountKey, "HmacSHA256"));
            byte[] utf8Bytes = stringToSign.getBytes(StandardCharsets.UTF_8);
            return Base64.getEncoder().encodeToString(hmacSha256.doFinal(utf8Bytes));
        }
        catch (NoSuchAlgorithmException e) {
            String errorMsg = "There is no such algorithm. Error Details: " + e.getMessage();
            this.logger.warning(errorMsg, new Object[0]);
            throw new RuntimeException(errorMsg);
        }
        catch (InvalidKeyException e) {
            String errorMsg = "Please double check the account key. Error details: " + e.getMessage();
            this.logger.warning(errorMsg, new Object[0]);
            throw new RuntimeException(errorMsg);
        }
    }

    private String buildStringToSign(URL requestURL, String httpMethod, Map<String, String> headers) {
        String contentLength = headers.get("Content-Length");
        contentLength = contentLength.equals("0") ? "" : contentLength;
        String dateHeader = headers.containsKey("x-ms-date") ? "" : this.getStandardHeaderValue(headers, "Date");
        return String.join((CharSequence)"\n", httpMethod, this.getStandardHeaderValue(headers, "Content-Encoding"), this.getStandardHeaderValue(headers, "Content-Language"), contentLength, this.getStandardHeaderValue(headers, "Content-MD5"), this.getStandardHeaderValue(headers, "Content-Type"), dateHeader, this.getStandardHeaderValue(headers, "If-Modified-Since"), this.getStandardHeaderValue(headers, "If-Match"), this.getStandardHeaderValue(headers, "If-None-Match"), this.getStandardHeaderValue(headers, "If-Unmodified-Since"), this.getStandardHeaderValue(headers, "Range"), this.getAdditionalXmsHeaders(headers), this.getCanonicalizedResource(requestURL));
    }

    private String getStandardHeaderValue(Map<String, String> headers, String headerName) {
        String headerValue = headers.get(headerName);
        return headerValue == null ? "" : headerValue;
    }

    private String getAdditionalXmsHeaders(Map<String, String> headers) {
        List xmsHeaderNameArray = headers.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase(Locale.ROOT).startsWith("x-ms-")).filter(entry -> entry.getValue() != null).map(Map.Entry::getKey).collect(Collectors.toList());
        if (xmsHeaderNameArray.isEmpty()) {
            return "";
        }
        Collections.sort(xmsHeaderNameArray);
        StringBuilder canonicalizedHeaders = new StringBuilder();
        for (String key : xmsHeaderNameArray) {
            if (canonicalizedHeaders.length() > 0) {
                canonicalizedHeaders.append('\n');
            }
            canonicalizedHeaders.append(key).append(':').append(headers.get(key));
        }
        return canonicalizedHeaders.toString();
    }

    private String getCanonicalizedResource(URL requestURL) {
        StringBuilder canonicalizedResource = new StringBuilder("/");
        canonicalizedResource.append(this.accountName);
        if (requestURL.getPath().length() > 0) {
            canonicalizedResource.append(requestURL.getPath());
        } else {
            canonicalizedResource.append('/');
        }
        if (requestURL.getQuery() == null) {
            return canonicalizedResource.toString();
        }
        QueryStringDecoder queryDecoder = new QueryStringDecoder("?" + requestURL.getQuery());
        Map queryParams = queryDecoder.parameters();
        ArrayList queryParamNames = new ArrayList(queryParams.keySet());
        Collections.sort(queryParamNames);
        for (String queryParamName : queryParamNames) {
            List queryParamValues = (List)queryParams.get(queryParamName);
            Collections.sort(queryParamValues);
            String queryParamValuesStr = String.join((CharSequence)",", queryParamValues);
            canonicalizedResource.append("\n").append(queryParamName.toLowerCase(Locale.ROOT)).append(":").append(queryParamValuesStr);
        }
        return canonicalizedResource.toString();
    }

    private String computeHMACSHA256(String stringToSign) {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            hmacSha256.init(new SecretKeySpec(this.accountKey, "HmacSHA256"));
            byte[] utf8Bytes = stringToSign.getBytes(StandardCharsets.UTF_8);
            String signature = Base64.getEncoder().encodeToString(hmacSha256.doFinal(utf8Bytes));
            return String.format(AUTHORIZATION_HEADER_FORMAT, this.accountName, signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            this.logger.warning(ex.getMessage(), new Object[0]);
            throw new Error(ex);
        }
    }
}

