/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.exception;

import com.azure.core.exception.HttpResponseException;
import com.azure.storage.file.models.StorageErrorCode;
import com.azure.storage.file.models.StorageErrorException;

public final class StorageException
extends HttpResponseException {
    private static final String ERROR_CODE = "x-ms-error-code";
    private final String message;

    StorageException(StorageErrorException e, String responseBody) {
        super(e.getMessage(), e.response(), (Throwable)((Object)e));
        this.message = responseBody;
    }

    public StorageErrorCode errorCode() {
        return StorageErrorCode.fromString(super.response().headers().value(ERROR_CODE));
    }

    public String message() {
        return this.message;
    }

    public int statusCode() {
        return super.response().statusCode();
    }
}

