/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.storage.common.policy.RetryPolicyType;
import java.util.concurrent.TimeUnit;

public final class RequestRetryOptions {
    private final int maxTries;
    private final int tryTimeout;
    private final long retryDelayInMs;
    private final long maxRetryDelayInMs;
    private RetryPolicyType retryPolicyType;
    private String secondaryHost;

    public RequestRetryOptions() {
        this(RetryPolicyType.EXPONENTIAL, null, null, null, null, null);
    }

    public RequestRetryOptions(RetryPolicyType retryPolicyType, Integer maxTries, Integer tryTimeout, Long retryDelayInMs, Long maxRetryDelayInMs, String secondaryHost) {
        RetryPolicyType retryPolicyType2 = this.retryPolicyType = retryPolicyType == null ? RetryPolicyType.EXPONENTIAL : retryPolicyType;
        if (maxTries != null) {
            RequestRetryOptions.assertInBounds("maxRetries", maxTries.intValue(), 1L, Integer.MAX_VALUE);
            this.maxTries = maxTries;
        } else {
            this.maxTries = 4;
        }
        if (tryTimeout != null) {
            RequestRetryOptions.assertInBounds("tryTimeout", tryTimeout.intValue(), 1L, Integer.MAX_VALUE);
            this.tryTimeout = tryTimeout;
        } else {
            this.tryTimeout = 60;
        }
        if (retryDelayInMs == null && maxRetryDelayInMs != null || retryDelayInMs != null && maxRetryDelayInMs == null) {
            throw new IllegalArgumentException("Both retryDelay and maxRetryDelay must be null or neither can be null");
        }
        if (retryDelayInMs != null && maxRetryDelayInMs != null) {
            RequestRetryOptions.assertInBounds("maxRetryDelayInMs", maxRetryDelayInMs, 1L, Long.MAX_VALUE);
            RequestRetryOptions.assertInBounds("retryDelayInMs", retryDelayInMs, 1L, maxRetryDelayInMs);
            this.maxRetryDelayInMs = maxRetryDelayInMs;
            this.retryDelayInMs = retryDelayInMs;
        } else {
            switch (this.retryPolicyType) {
                case EXPONENTIAL: {
                    this.retryDelayInMs = TimeUnit.SECONDS.toMillis(4L);
                    break;
                }
                case FIXED: {
                    this.retryDelayInMs = TimeUnit.SECONDS.toMillis(30L);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognize retry policy type.");
                }
            }
            this.maxRetryDelayInMs = TimeUnit.SECONDS.toMillis(120L);
        }
        this.secondaryHost = secondaryHost;
    }

    int maxTries() {
        return this.maxTries;
    }

    int tryTimeout() {
        return this.tryTimeout;
    }

    String secondaryHost() {
        return this.secondaryHost;
    }

    long retryDelayInMs() {
        return this.retryDelayInMs;
    }

    long maxRetryDelayInMs() {
        return this.maxRetryDelayInMs;
    }

    long calculateDelayInMs(int tryCount) {
        long delay = 0L;
        switch (this.retryPolicyType) {
            case EXPONENTIAL: {
                delay = (this.pow(2L, tryCount - 1) - 1L) * this.retryDelayInMs;
                break;
            }
            case FIXED: {
                delay = this.retryDelayInMs;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid retry policy type.");
            }
        }
        return Math.min(delay, this.maxRetryDelayInMs);
    }

    private long pow(long number, int exponent) {
        long result = 1L;
        for (int i = 0; i < exponent; ++i) {
            result *= number;
        }
        return result;
    }

    private static void assertInBounds(String param, long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(String.format("The value of the parameter '%s' should be between %s and %s.", param, min, max));
        }
    }
}

