/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.storage.common.credentials.SASTokenCredential;
import java.net.MalformedURLException;
import java.net.URL;
import reactor.core.publisher.Mono;

public final class SASTokenCredentialPolicy
implements HttpPipelinePolicy {
    private final SASTokenCredential credential;

    public SASTokenCredentialPolicy(SASTokenCredential credential) {
        this.credential = credential;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        try {
            URL requestURL = context.httpRequest().url();
            String delimiter = !ImplUtils.isNullOrEmpty((CharSequence)requestURL.getQuery()) ? "&" : "?";
            String newURL = requestURL.toString() + delimiter + this.credential.sasToken();
            context.httpRequest().url(new URL(newURL));
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
        return next.process();
    }
}

