/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.core.util.Context;
import com.azure.storage.file.FileAsyncClient;
import com.azure.storage.file.implementation.AzureFileStorageBuilder;
import com.azure.storage.file.implementation.AzureFileStorageImpl;
import com.azure.storage.file.models.DirectoryCreateHeaders;
import com.azure.storage.file.models.DirectoryForceCloseHandlesHeaders;
import com.azure.storage.file.models.DirectoryGetPropertiesHeaders;
import com.azure.storage.file.models.DirectoryInfo;
import com.azure.storage.file.models.DirectoryProperties;
import com.azure.storage.file.models.DirectorySetMetadataHeaders;
import com.azure.storage.file.models.DirectorySetMetadataInfo;
import com.azure.storage.file.models.DirectorysCreateResponse;
import com.azure.storage.file.models.DirectorysForceCloseHandlesResponse;
import com.azure.storage.file.models.DirectorysGetPropertiesResponse;
import com.azure.storage.file.models.DirectorysListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.models.DirectorysListHandlesResponse;
import com.azure.storage.file.models.DirectorysSetMetadataResponse;
import com.azure.storage.file.models.FileHTTPHeaders;
import com.azure.storage.file.models.FileRef;
import com.azure.storage.file.models.HandleItem;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DirectoryAsyncClient {
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String directoryPath;
    private final String snapshot;

    DirectoryAsyncClient(AzureFileStorageImpl azureFileStorageClient, String shareName, String directoryPath, String snapshot) {
        this.shareName = shareName;
        this.directoryPath = directoryPath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = azureFileStorageClient;
    }

    DirectoryAsyncClient(URL endpoint, HttpPipeline httpPipeline, String shareName, String directoryPath, String snapshot) {
        this.shareName = shareName;
        this.directoryPath = directoryPath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = new AzureFileStorageBuilder().pipeline(httpPipeline).url(endpoint.toString()).build();
    }

    public URL getDirectoryUrl() {
        try {
            return new URL(this.azureFileStorageClient.getUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Invalid URL on %s: %s" + this.getClass().getSimpleName(), this.azureFileStorageClient.getUrl()), e);
        }
    }

    public FileAsyncClient getFileClient(String fileName) {
        String filePath = this.directoryPath + "/" + fileName;
        return new FileAsyncClient(this.azureFileStorageClient, this.shareName, filePath, null);
    }

    public DirectoryAsyncClient getSubDirectoryClient(String subDirectoryName) {
        String directoryPath = this.directoryPath + "/" + subDirectoryName;
        return new DirectoryAsyncClient(this.azureFileStorageClient, this.shareName, directoryPath, this.snapshot);
    }

    public Mono<Response<DirectoryInfo>> create() {
        return this.create(null);
    }

    public Mono<Response<DirectoryInfo>> create(Map<String, String> metadata) {
        return this.azureFileStorageClient.directorys().createWithRestResponseAsync(this.shareName, this.directoryPath, null, metadata, Context.NONE).map(this::createWithRestResponse);
    }

    public Mono<VoidResponse> delete() {
        return this.azureFileStorageClient.directorys().deleteWithRestResponseAsync(this.shareName, this.directoryPath, Context.NONE).map(VoidResponse::new).map(VoidResponse::new);
    }

    public Mono<Response<DirectoryProperties>> getProperties() {
        return this.azureFileStorageClient.directorys().getPropertiesWithRestResponseAsync(this.shareName, this.directoryPath, this.snapshot, null, Context.NONE).map(this::getPropertiesResponse);
    }

    public Mono<Response<DirectorySetMetadataInfo>> setMetadata(Map<String, String> metadata) {
        return this.azureFileStorageClient.directorys().setMetadataWithRestResponseAsync(this.shareName, this.directoryPath, null, metadata, Context.NONE).map(this::setMetadataResponse);
    }

    public Flux<FileRef> listFilesAndDirectories() {
        return this.listFilesAndDirectories(null, null);
    }

    public Flux<FileRef> listFilesAndDirectories(String prefix, Integer maxResults) {
        return this.azureFileStorageClient.directorys().listFilesAndDirectoriesSegmentWithRestResponseAsync(this.shareName, this.directoryPath, prefix, this.snapshot, null, maxResults, null, Context.NONE).flatMapMany(response -> this.nextPageForFileAndDirecotries((DirectorysListFilesAndDirectoriesSegmentResponse)((Object)response), prefix, maxResults));
    }

    public Flux<HandleItem> getHandles(Integer maxResult, boolean recursive) {
        return this.azureFileStorageClient.directorys().listHandlesWithRestResponseAsync(this.shareName, this.directoryPath, null, maxResult, null, this.snapshot, recursive, Context.NONE).flatMapMany(response -> this.nextPageForHandles((DirectorysListHandlesResponse)((Object)response), maxResult, recursive));
    }

    public Flux<Integer> forceCloseHandles(String handleId, boolean recursive) {
        return this.azureFileStorageClient.directorys().forceCloseHandlesWithRestResponseAsync(this.shareName, this.directoryPath, handleId, null, null, this.snapshot, recursive, Context.NONE).flatMapMany(response -> this.nextPageForForceCloseHandles((DirectorysForceCloseHandlesResponse)((Object)response), handleId, recursive));
    }

    public Mono<Response<DirectoryAsyncClient>> createSubDirectory(String subDirectoryName) {
        return this.createSubDirectory(subDirectoryName, null);
    }

    public Mono<Response<DirectoryAsyncClient>> createSubDirectory(String subDirectoryName, Map<String, String> metadata) {
        DirectoryAsyncClient createSubClient = this.getSubDirectoryClient(subDirectoryName);
        return createSubClient.create(metadata).map(response -> new SimpleResponse(response, (Object)createSubClient));
    }

    public Mono<VoidResponse> deleteSubDirectory(String subDirectoryName) {
        DirectoryAsyncClient deleteSubClient = this.getSubDirectoryClient(subDirectoryName);
        return deleteSubClient.delete().map(VoidResponse::new);
    }

    public Mono<Response<FileAsyncClient>> createFile(String fileName, long maxSize) {
        return this.createFile(fileName, maxSize, null, null);
    }

    public Mono<Response<FileAsyncClient>> createFile(String fileName, long maxSize, FileHTTPHeaders httpHeaders, Map<String, String> metadata) {
        FileAsyncClient fileAsyncClient = this.getFileClient(fileName);
        return fileAsyncClient.create(maxSize, httpHeaders, metadata).map(response -> new SimpleResponse(response, (Object)fileAsyncClient));
    }

    public Mono<VoidResponse> deleteFile(String fileName) {
        FileAsyncClient fileAsyncClient = this.getFileClient(fileName);
        return fileAsyncClient.delete().map(VoidResponse::new);
    }

    public String getShareSnapshotId() {
        return this.snapshot;
    }

    private Response<DirectoryInfo> createWithRestResponse(DirectorysCreateResponse response) {
        String eTag = ((DirectoryCreateHeaders)response.deserializedHeaders()).eTag();
        OffsetDateTime lastModified = ((DirectoryCreateHeaders)response.deserializedHeaders()).lastModified();
        DirectoryInfo directoryInfo = new DirectoryInfo(eTag, lastModified);
        return new SimpleResponse((Response)response, (Object)directoryInfo);
    }

    private Response<DirectoryProperties> getPropertiesResponse(DirectorysGetPropertiesResponse response) {
        Map<String, String> metadata = ((DirectoryGetPropertiesHeaders)response.deserializedHeaders()).metadata();
        String eTag = ((DirectoryGetPropertiesHeaders)response.deserializedHeaders()).eTag();
        OffsetDateTime offsetDateTime = ((DirectoryGetPropertiesHeaders)response.deserializedHeaders()).lastModified();
        boolean isServerEncrypted = ((DirectoryGetPropertiesHeaders)response.deserializedHeaders()).isServerEncrypted();
        DirectoryProperties directoryProperties = new DirectoryProperties(metadata, eTag, offsetDateTime, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)directoryProperties);
    }

    private Response<DirectorySetMetadataInfo> setMetadataResponse(DirectorysSetMetadataResponse response) {
        String eTag = ((DirectorySetMetadataHeaders)response.deserializedHeaders()).eTag();
        boolean isServerEncrypted = ((DirectorySetMetadataHeaders)response.deserializedHeaders()).isServerEncrypted();
        DirectorySetMetadataInfo directorySetMetadataInfo = new DirectorySetMetadataInfo(eTag, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)directorySetMetadataInfo);
    }

    private Flux<FileRef> nextPageForFileAndDirecotries(DirectorysListFilesAndDirectoriesSegmentResponse response, String prefix, Integer maxResult) {
        List<FileRef> fileRefs = this.convertResponseAndGetNumOfResults(response);
        if (response.value().nextMarker() == null) {
            return Flux.fromIterable(fileRefs);
        }
        Mono<DirectorysListFilesAndDirectoriesSegmentResponse> listResponse = this.azureFileStorageClient.directorys().listFilesAndDirectoriesSegmentWithRestResponseAsync(this.shareName, this.directoryPath, prefix, this.snapshot, response.value().nextMarker(), maxResult, null, Context.NONE);
        Flux fileRefPublisher = listResponse.flatMapMany(newResponse -> this.nextPageForFileAndDirecotries((DirectorysListFilesAndDirectoriesSegmentResponse)((Object)newResponse), prefix, maxResult));
        return Flux.fromIterable(fileRefs).concatWith((Publisher)fileRefPublisher);
    }

    private Flux<HandleItem> nextPageForHandles(DirectorysListHandlesResponse response, Integer maxResult, boolean recursive) {
        List<HandleItem> handleItems = response.value().handleList();
        if (response.value().nextMarker() == null) {
            return Flux.fromIterable(handleItems);
        }
        Mono<DirectorysListHandlesResponse> listResponse = this.azureFileStorageClient.directorys().listHandlesWithRestResponseAsync(this.shareName, this.directoryPath, response.value().nextMarker(), maxResult, null, this.snapshot, recursive, Context.NONE);
        Flux fileRefPublisher = listResponse.flatMapMany(newResponse -> this.nextPageForHandles((DirectorysListHandlesResponse)((Object)newResponse), maxResult, recursive));
        return Flux.fromIterable(handleItems).concatWith((Publisher)fileRefPublisher);
    }

    private Flux<Integer> nextPageForForceCloseHandles(DirectorysForceCloseHandlesResponse response, String handleId, boolean recursive) {
        List<Integer> handleCount = Arrays.asList(((DirectoryForceCloseHandlesHeaders)response.deserializedHeaders()).numberOfHandlesClosed());
        if (((DirectoryForceCloseHandlesHeaders)response.deserializedHeaders()).marker() == null) {
            return Flux.fromIterable(handleCount);
        }
        Mono<DirectorysForceCloseHandlesResponse> listResponse = this.azureFileStorageClient.directorys().forceCloseHandlesWithRestResponseAsync(this.shareName, this.directoryPath, handleId, null, ((DirectoryForceCloseHandlesHeaders)response.deserializedHeaders()).marker(), this.snapshot, recursive, Context.NONE);
        Flux fileRefPublisher = listResponse.flatMapMany(newResponse -> this.nextPageForForceCloseHandles((DirectorysForceCloseHandlesResponse)((Object)newResponse), handleId, recursive));
        return Flux.fromIterable(handleCount).concatWith((Publisher)fileRefPublisher);
    }

    private List<FileRef> convertResponseAndGetNumOfResults(DirectorysListFilesAndDirectoriesSegmentResponse response) {
        ArrayList<FileRef> fileRefs = new ArrayList<FileRef>();
        response.value().segment().directoryItems().forEach(directoryItem -> fileRefs.add(new FileRef(directoryItem.name(), true, null)));
        response.value().segment().fileItems().forEach(fileItem -> fileRefs.add(new FileRef(fileItem.name(), false, fileItem.properties())));
        return fileRefs;
    }
}

