/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.storage.file.DirectoryAsyncClient;
import com.azure.storage.file.FileAsyncClient;
import com.azure.storage.file.FileClient;
import com.azure.storage.file.models.DirectoryInfo;
import com.azure.storage.file.models.DirectoryProperties;
import com.azure.storage.file.models.DirectorySetMetadataInfo;
import com.azure.storage.file.models.FileHTTPHeaders;
import com.azure.storage.file.models.FileRef;
import com.azure.storage.file.models.HandleItem;
import java.net.URL;
import java.util.Map;

public class DirectoryClient {
    private final DirectoryAsyncClient directoryAsyncClient;

    DirectoryClient(DirectoryAsyncClient directoryAsyncClient) {
        this.directoryAsyncClient = directoryAsyncClient;
    }

    public URL getDirectoryUrl() {
        return this.directoryAsyncClient.getDirectoryUrl();
    }

    public FileClient getFileClient(String fileName) {
        return new FileClient(this.directoryAsyncClient.getFileClient(fileName));
    }

    public DirectoryClient getSubDirectoryClient(String subDirectoryName) {
        return new DirectoryClient(this.directoryAsyncClient.getSubDirectoryClient(subDirectoryName));
    }

    public Response<DirectoryInfo> create() {
        return this.create(null);
    }

    public Response<DirectoryInfo> create(Map<String, String> metadata) {
        return (Response)this.directoryAsyncClient.create(metadata).block();
    }

    public VoidResponse delete() {
        return (VoidResponse)this.directoryAsyncClient.delete().block();
    }

    public Response<DirectoryProperties> getProperties() {
        return (Response)this.directoryAsyncClient.getProperties().block();
    }

    public Response<DirectorySetMetadataInfo> setMetadata(Map<String, String> metadata) {
        return (Response)this.directoryAsyncClient.setMetadata(metadata).block();
    }

    public Iterable<FileRef> listFilesAndDirectories() {
        return this.listFilesAndDirectories(null, null);
    }

    public Iterable<FileRef> listFilesAndDirectories(String prefix, Integer maxResults) {
        return this.directoryAsyncClient.listFilesAndDirectories(prefix, maxResults).toIterable();
    }

    public Iterable<HandleItem> getHandles(Integer maxResult, boolean recursive) {
        return (Iterable)this.directoryAsyncClient.getHandles(maxResult, recursive).collectList().block();
    }

    public Iterable<Integer> forceCloseHandles(String handleId, boolean recursive) {
        return (Iterable)this.directoryAsyncClient.forceCloseHandles(handleId, recursive).collectList().block();
    }

    public Response<DirectoryClient> createSubDirectory(String subDirectoryName) {
        return this.createSubDirectory(subDirectoryName, null);
    }

    public Response<DirectoryClient> createSubDirectory(String subDirectoryName, Map<String, String> metadata) {
        DirectoryClient directoryClient = this.getSubDirectoryClient(subDirectoryName);
        return new SimpleResponse(directoryClient.create(metadata), (Object)directoryClient);
    }

    public VoidResponse deleteSubDirectory(String subDirectoryName) {
        return (VoidResponse)this.directoryAsyncClient.deleteSubDirectory(subDirectoryName).block();
    }

    public Response<FileClient> createFile(String fileName, long maxSize) {
        return this.createFile(fileName, maxSize, null, null);
    }

    public Response<FileClient> createFile(String fileName, long maxSize, FileHTTPHeaders httpHeaders, Map<String, String> metadata) {
        return (Response)this.directoryAsyncClient.createFile(fileName, maxSize, httpHeaders, metadata).map(response -> new SimpleResponse(response, (Object)new FileClient((FileAsyncClient)response.value()))).block();
    }

    public VoidResponse deleteFile(String fileName) {
        return (VoidResponse)this.directoryAsyncClient.deleteFile(fileName).block();
    }

    public String getShareSnapshotId() {
        return this.directoryAsyncClient.getShareSnapshotId();
    }
}

