/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.core.implementation.util.FluxUtil;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.file.implementation.AzureFileStorageBuilder;
import com.azure.storage.file.implementation.AzureFileStorageImpl;
import com.azure.storage.file.models.CopyStatusType;
import com.azure.storage.file.models.FileCopyInfo;
import com.azure.storage.file.models.FileCreateHeaders;
import com.azure.storage.file.models.FileDownloadHeaders;
import com.azure.storage.file.models.FileDownloadInfo;
import com.azure.storage.file.models.FileForceCloseHandlesHeaders;
import com.azure.storage.file.models.FileGetPropertiesHeaders;
import com.azure.storage.file.models.FileHTTPHeaders;
import com.azure.storage.file.models.FileInfo;
import com.azure.storage.file.models.FileMetadataInfo;
import com.azure.storage.file.models.FileProperties;
import com.azure.storage.file.models.FileRange;
import com.azure.storage.file.models.FileRangeWriteType;
import com.azure.storage.file.models.FileSetHTTPHeadersHeaders;
import com.azure.storage.file.models.FileSetMetadataHeaders;
import com.azure.storage.file.models.FileStartCopyHeaders;
import com.azure.storage.file.models.FileUploadInfo;
import com.azure.storage.file.models.FileUploadRangeHeaders;
import com.azure.storage.file.models.FilesCreateResponse;
import com.azure.storage.file.models.FilesDownloadResponse;
import com.azure.storage.file.models.FilesForceCloseHandlesResponse;
import com.azure.storage.file.models.FilesGetPropertiesResponse;
import com.azure.storage.file.models.FilesGetRangeListResponse;
import com.azure.storage.file.models.FilesListHandlesResponse;
import com.azure.storage.file.models.FilesSetHTTPHeadersResponse;
import com.azure.storage.file.models.FilesSetMetadataResponse;
import com.azure.storage.file.models.FilesStartCopyResponse;
import com.azure.storage.file.models.FilesUploadRangeResponse;
import com.azure.storage.file.models.HandleItem;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class FileAsyncClient {
    private final ClientLogger logger = new ClientLogger(FileAsyncClient.class);
    private static final long FILE_DEFAULT_BLOCK_SIZE = 0x400000L;
    private static final long DOWNLOAD_UPLOAD_CHUNK_TIMEOUT = 300L;
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String filePath;
    private final String snapshot;

    FileAsyncClient(AzureFileStorageImpl azureFileStorageClient, String shareName, String filePath, String snapshot) {
        this.shareName = shareName;
        this.filePath = filePath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = azureFileStorageClient;
    }

    FileAsyncClient(URL endpoint, HttpPipeline httpPipeline, String shareName, String filePath, String snapshot) {
        this.shareName = shareName;
        this.filePath = filePath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = new AzureFileStorageBuilder().pipeline(httpPipeline).url(endpoint.toString()).build();
    }

    public URL getFileUrl() {
        try {
            return new URL(this.azureFileStorageClient.getUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Invalid URL on %s: %s" + this.getClass().getSimpleName(), this.azureFileStorageClient.getUrl()), e);
        }
    }

    public Mono<Response<FileInfo>> create(long maxSize) {
        return this.create(maxSize, null, null);
    }

    public Mono<Response<FileInfo>> create(long maxSize, FileHTTPHeaders httpHeaders, Map<String, String> metadata) {
        return this.azureFileStorageClient.files().createWithRestResponseAsync(this.shareName, this.filePath, maxSize, null, metadata, httpHeaders, Context.NONE).map(this::createFileInfoResponse);
    }

    public Mono<Response<FileCopyInfo>> startCopy(String sourceUrl, Map<String, String> metadata) {
        return this.azureFileStorageClient.files().startCopyWithRestResponseAsync(this.shareName, this.filePath, sourceUrl, null, metadata, Context.NONE).map(this::startCopyResponse);
    }

    public Mono<VoidResponse> abortCopy(String copyId) {
        return this.azureFileStorageClient.files().abortCopyWithRestResponseAsync(this.shareName, this.filePath, copyId, Context.NONE).map(VoidResponse::new);
    }

    public Mono<Void> downloadToFile(String downloadFilePath) {
        return this.downloadToFile(downloadFilePath, null);
    }

    public Mono<Void> downloadToFile(String downloadFilePath, FileRange range) {
        AsynchronousFileChannel channel = this.channelSetup(downloadFilePath);
        return this.sliceFileRange(range).flatMap(chunk -> this.downloadWithProperties((FileRange)chunk, false).map(dar -> ((FileDownloadInfo)dar.value()).body()).subscribeOn(Schedulers.elastic()).flatMap(fbb -> FluxUtil.bytebufStreamToFile((Flux)fbb, (AsynchronousFileChannel)channel, (long)(chunk.start() - (range == null ? 0L : range.start()))).subscribeOn(Schedulers.elastic()).timeout(Duration.ofSeconds(300L)).retry(3L, throwable -> throwable instanceof IOException || throwable instanceof TimeoutException))).then().doOnTerminate(() -> this.channelCleanUp(channel));
    }

    private AsynchronousFileChannel channelSetup(String filePath) {
        try {
            return AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void channelCleanUp(AsynchronousFileChannel channel) {
        try {
            channel.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Flux<FileRange> sliceFileRange(FileRange fileRange) {
        long offset = fileRange == null ? 0L : fileRange.start();
        Mono end = fileRange != null ? Mono.just((Object)fileRange.end()) : Mono.empty();
        end = end.switchIfEmpty(this.getProperties().map(rb -> ((FileProperties)rb.value()).contentLength()));
        return end.map(e -> {
            ArrayList<FileRange> chunks = new ArrayList<FileRange>();
            for (long pos = offset; pos < e; pos += 0x400000L) {
                long count = 0x400000L;
                if (pos + count > e) {
                    count = e - pos;
                }
                chunks.add(new FileRange(pos, pos + count - 1L));
            }
            return chunks;
        }).flatMapMany(Flux::fromIterable);
    }

    public Mono<Response<FileDownloadInfo>> downloadWithProperties() {
        return this.downloadWithProperties(null, null);
    }

    public Mono<Response<FileDownloadInfo>> downloadWithProperties(FileRange range, Boolean rangeGetContentMD5) {
        String rangeString = range == null ? null : range.toString();
        return this.azureFileStorageClient.files().downloadWithRestResponseAsync(this.shareName, this.filePath, null, rangeString, rangeGetContentMD5, Context.NONE).map(this::downloadWithPropertiesResponse);
    }

    public Mono<VoidResponse> delete() {
        return this.azureFileStorageClient.files().deleteWithRestResponseAsync(this.shareName, this.filePath, Context.NONE).map(VoidResponse::new);
    }

    public Mono<Response<FileProperties>> getProperties() {
        return this.azureFileStorageClient.files().getPropertiesWithRestResponseAsync(this.shareName, this.filePath, this.snapshot, null, Context.NONE).map(this::getPropertiesResponse);
    }

    public Mono<Response<FileInfo>> setHttpHeaders(long newFileSize, FileHTTPHeaders httpHeaders) {
        return this.azureFileStorageClient.files().setHTTPHeadersWithRestResponseAsync(this.shareName, this.filePath, null, newFileSize, httpHeaders, Context.NONE).map(this::setHttpHeadersResponse);
    }

    public Mono<Response<FileMetadataInfo>> setMetadata(Map<String, String> metadata) {
        return this.azureFileStorageClient.files().setMetadataWithRestResponseAsync(this.shareName, this.filePath, null, metadata, Context.NONE).map(this::setMetadataResponse);
    }

    public Mono<Response<FileUploadInfo>> upload(Flux<ByteBuf> data, long length) {
        FileRange range = new FileRange(0L, length - 1L);
        return this.azureFileStorageClient.files().uploadRangeWithRestResponseAsync(this.shareName, this.filePath, range.toString(), FileRangeWriteType.UPDATE, length, data, null, null, Context.NONE).map(this::uploadResponse);
    }

    public Mono<Response<FileUploadInfo>> upload(Flux<ByteBuf> data, long length, long offset, FileRangeWriteType type) {
        FileRange range = new FileRange(offset, offset + length - 1L);
        return this.azureFileStorageClient.files().uploadRangeWithRestResponseAsync(this.shareName, this.filePath, range.toString(), type, length, data, null, null, Context.NONE).map(this::uploadResponse);
    }

    public Mono<Void> uploadFromFile(String uploadFilePath) {
        return this.uploadFromFile(uploadFilePath, FileRangeWriteType.UPDATE);
    }

    public Mono<Void> uploadFromFile(String uploadFilePath, FileRangeWriteType type) {
        AsynchronousFileChannel channel = this.channelSetup(uploadFilePath);
        return Flux.fromIterable(this.sliceFile(uploadFilePath)).flatMap(chunk -> this.upload((Flux<ByteBuf>)FluxUtil.byteBufStreamFromFile((AsynchronousFileChannel)channel, (long)chunk.start(), (long)(chunk.end() - chunk.start() + 1L)), chunk.end() - chunk.start() + 1L, chunk.start(), type).timeout(Duration.ofSeconds(300L)).retry(3L, throwable -> throwable instanceof IOException || throwable instanceof TimeoutException)).then().doOnTerminate(() -> this.channelCleanUp(channel));
    }

    private List<FileRange> sliceFile(String path) {
        File file = new File(path);
        assert (file.exists());
        ArrayList<FileRange> ranges = new ArrayList<FileRange>();
        for (long pos = 0L; pos < file.length(); pos += 0x400000L) {
            long count = 0x400000L;
            if (pos + count > file.length()) {
                count = file.length() - pos;
            }
            ranges.add(new FileRange(pos, pos + count - 1L));
        }
        return ranges;
    }

    public Flux<FileRange> listRanges() {
        return this.azureFileStorageClient.files().getRangeListWithRestResponseAsync(this.shareName, this.filePath, this.snapshot, null, null, Context.NONE).flatMapMany(this::convertListRangesResponseToFileRangeInfo);
    }

    public Flux<FileRange> listRanges(FileRange range) {
        String rangeString = range == null ? null : range.toString();
        return this.azureFileStorageClient.files().getRangeListWithRestResponseAsync(this.shareName, this.filePath, this.snapshot, null, rangeString, Context.NONE).flatMapMany(this::convertListRangesResponseToFileRangeInfo);
    }

    public Flux<HandleItem> listHandles() {
        return this.listHandles(null);
    }

    public Flux<HandleItem> listHandles(Integer maxResults) {
        return this.azureFileStorageClient.files().listHandlesWithRestResponseAsync(this.shareName, this.filePath, null, maxResults, null, this.snapshot, Context.NONE).flatMapMany(response -> this.nextPageForHandles((FilesListHandlesResponse)((Object)response), maxResults));
    }

    public Flux<Integer> forceCloseHandles(String handleId) {
        return this.azureFileStorageClient.files().forceCloseHandlesWithRestResponseAsync(this.shareName, this.filePath, handleId, null, null, this.snapshot, Context.NONE).flatMapMany(response -> this.nextPageForForceCloseHandles((FilesForceCloseHandlesResponse)((Object)response), handleId));
    }

    public String getShareSnapshotId() {
        return this.snapshot;
    }

    private Flux<Integer> nextPageForForceCloseHandles(FilesForceCloseHandlesResponse response, String handleId) {
        List<Integer> handleCount = Arrays.asList(((FileForceCloseHandlesHeaders)response.deserializedHeaders()).numberOfHandlesClosed());
        if (((FileForceCloseHandlesHeaders)response.deserializedHeaders()).marker() == null) {
            return Flux.fromIterable(handleCount);
        }
        Mono<FilesForceCloseHandlesResponse> listResponse = this.azureFileStorageClient.files().forceCloseHandlesWithRestResponseAsync(this.shareName, this.filePath, handleId, null, ((FileForceCloseHandlesHeaders)response.deserializedHeaders()).marker(), this.snapshot, Context.NONE);
        Flux fileRefPublisher = listResponse.flatMapMany(newResponse -> this.nextPageForForceCloseHandles((FilesForceCloseHandlesResponse)((Object)newResponse), handleId));
        return Flux.fromIterable(handleCount).concatWith((Publisher)fileRefPublisher);
    }

    private Flux<HandleItem> nextPageForHandles(FilesListHandlesResponse response, Integer maxResults) {
        List<HandleItem> handleItems = response.value().handleList();
        if (response.value().nextMarker() == null) {
            return Flux.fromIterable(handleItems);
        }
        Mono<FilesListHandlesResponse> listResponse = this.azureFileStorageClient.files().listHandlesWithRestResponseAsync(this.shareName, this.filePath, response.value().nextMarker(), maxResults, null, this.snapshot, Context.NONE);
        Flux fileRefPublisher = listResponse.flatMapMany(newResponse -> this.nextPageForHandles((FilesListHandlesResponse)((Object)newResponse), maxResults));
        return Flux.fromIterable(handleItems).concatWith((Publisher)fileRefPublisher);
    }

    private Response<FileInfo> createFileInfoResponse(FilesCreateResponse response) {
        String eTag = ((FileCreateHeaders)response.deserializedHeaders()).eTag();
        OffsetDateTime lastModified = ((FileCreateHeaders)response.deserializedHeaders()).lastModified();
        boolean isServerEncrypted = ((FileCreateHeaders)response.deserializedHeaders()).isServerEncrypted();
        FileInfo fileInfo = new FileInfo(eTag, lastModified, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)fileInfo);
    }

    private Response<FileCopyInfo> startCopyResponse(FilesStartCopyResponse response) {
        String eTag = ((FileStartCopyHeaders)response.deserializedHeaders()).eTag();
        OffsetDateTime lastModified = ((FileStartCopyHeaders)response.deserializedHeaders()).lastModified();
        String copyId = ((FileStartCopyHeaders)response.deserializedHeaders()).copyId();
        CopyStatusType copyStatus = ((FileStartCopyHeaders)response.deserializedHeaders()).copyStatus();
        FileCopyInfo fileCopyInfo = new FileCopyInfo(eTag, lastModified, copyId, copyStatus);
        return new SimpleResponse((Response)response, (Object)fileCopyInfo);
    }

    private Response<FileInfo> setHttpHeadersResponse(FilesSetHTTPHeadersResponse response) {
        String eTag = ((FileSetHTTPHeadersHeaders)response.deserializedHeaders()).eTag();
        OffsetDateTime lastModified = ((FileSetHTTPHeadersHeaders)response.deserializedHeaders()).lastModified();
        boolean isServerEncrypted = ((FileSetHTTPHeadersHeaders)response.deserializedHeaders()).isServerEncrypted();
        FileInfo fileInfo = new FileInfo(eTag, lastModified, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)fileInfo);
    }

    private Response<FileDownloadInfo> downloadWithPropertiesResponse(FilesDownloadResponse response) {
        String eTag = ((FileDownloadHeaders)response.deserializedHeaders()).eTag();
        OffsetDateTime lastModified = ((FileDownloadHeaders)response.deserializedHeaders()).lastModified();
        Map<String, String> metadata = ((FileDownloadHeaders)response.deserializedHeaders()).metadata();
        Long contentLength = ((FileDownloadHeaders)response.deserializedHeaders()).contentLength();
        String contentType = ((FileDownloadHeaders)response.deserializedHeaders()).contentType();
        String contentRange = ((FileDownloadHeaders)response.deserializedHeaders()).contentRange();
        Flux<ByteBuf> body = response.value();
        FileDownloadInfo fileDownloadInfo = new FileDownloadInfo(eTag, lastModified, metadata, contentLength, contentType, contentRange, body);
        return new SimpleResponse((Response)response, (Object)fileDownloadInfo);
    }

    private Response<FileProperties> getPropertiesResponse(FilesGetPropertiesResponse response) {
        byte[] contentMD5;
        FileGetPropertiesHeaders headers = (FileGetPropertiesHeaders)response.deserializedHeaders();
        String eTag = headers.eTag();
        OffsetDateTime lastModified = headers.lastModified();
        Map<String, String> metadata = headers.metadata();
        String fileType = headers.fileType();
        Long contentLength = headers.contentLength();
        String contentType = headers.contentType();
        try {
            contentMD5 = headers.contentMD5();
        }
        catch (NullPointerException e) {
            contentMD5 = null;
        }
        String contentEncoding = headers.contentEncoding();
        String cacheControl = headers.cacheControl();
        String contentDisposition = headers.contentDisposition();
        OffsetDateTime copyCompletionTime = headers.copyCompletionTime();
        String copyStatusDescription = headers.copyStatusDescription();
        String copyId = headers.copyId();
        String copyProgress = headers.copyProgress();
        String copySource = headers.copySource();
        CopyStatusType copyStatus = headers.copyStatus();
        Boolean isServerEncrpted = headers.isServerEncrypted();
        FileProperties fileProperties = new FileProperties(eTag, lastModified, metadata, fileType, contentLength, contentType, contentMD5, contentEncoding, cacheControl, contentDisposition, copyCompletionTime, copyStatusDescription, copyId, copyProgress, copySource, copyStatus, isServerEncrpted);
        return new SimpleResponse((Response)response, (Object)fileProperties);
    }

    private Response<FileUploadInfo> uploadResponse(FilesUploadRangeResponse response) {
        byte[] contentMD5;
        FileUploadRangeHeaders headers = (FileUploadRangeHeaders)response.deserializedHeaders();
        String eTag = headers.eTag();
        OffsetDateTime lastModified = headers.lastModified();
        try {
            contentMD5 = headers.contentMD5();
        }
        catch (NullPointerException e) {
            contentMD5 = null;
        }
        Boolean isServerEncrypted = headers.isServerEncrypted();
        FileUploadInfo fileUploadInfo = new FileUploadInfo(eTag, lastModified, contentMD5, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)fileUploadInfo);
    }

    private Response<FileMetadataInfo> setMetadataResponse(FilesSetMetadataResponse response) {
        String eTag = ((FileSetMetadataHeaders)response.deserializedHeaders()).eTag();
        boolean isServerEncrypted = ((FileSetMetadataHeaders)response.deserializedHeaders()).isServerEncrypted();
        FileMetadataInfo fileMetadataInfo = new FileMetadataInfo(eTag, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)fileMetadataInfo);
    }

    private Flux<FileRange> convertListRangesResponseToFileRangeInfo(FilesGetRangeListResponse response) {
        ArrayList fileRanges = new ArrayList();
        response.value().forEach(range -> {
            long start = range.start();
            long end = range.end();
            fileRanges.add(new FileRange(start, end));
        });
        return Flux.fromIterable(fileRanges);
    }
}

