/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.VoidResponse;
import com.azure.storage.file.FileAsyncClient;
import com.azure.storage.file.models.FileCopyInfo;
import com.azure.storage.file.models.FileDownloadInfo;
import com.azure.storage.file.models.FileHTTPHeaders;
import com.azure.storage.file.models.FileInfo;
import com.azure.storage.file.models.FileMetadataInfo;
import com.azure.storage.file.models.FileProperties;
import com.azure.storage.file.models.FileRange;
import com.azure.storage.file.models.FileRangeWriteType;
import com.azure.storage.file.models.FileUploadInfo;
import com.azure.storage.file.models.HandleItem;
import io.netty.buffer.ByteBuf;
import java.net.URL;
import java.util.Map;
import reactor.core.publisher.Flux;

public class FileClient {
    private final FileAsyncClient fileAsyncClient;

    FileClient(FileAsyncClient fileAsyncClient) {
        this.fileAsyncClient = fileAsyncClient;
    }

    public URL getFileUrl() {
        return this.fileAsyncClient.getFileUrl();
    }

    public Response<FileInfo> create(long maxSize) {
        return (Response)this.fileAsyncClient.create(maxSize).block();
    }

    public Response<FileInfo> create(long maxSize, FileHTTPHeaders httpHeaders, Map<String, String> metadata) {
        return (Response)this.fileAsyncClient.create(maxSize, httpHeaders, metadata).block();
    }

    public Response<FileCopyInfo> startCopy(String sourceUrl, Map<String, String> metadata) {
        return (Response)this.fileAsyncClient.startCopy(sourceUrl, metadata).block();
    }

    public VoidResponse abortCopy(String copyId) {
        return (VoidResponse)this.fileAsyncClient.abortCopy(copyId).block();
    }

    public void downloadToFile(String downloadFilePath) {
        this.downloadToFile(downloadFilePath, null);
    }

    public void downloadToFile(String downloadFilePath, FileRange range) {
        this.fileAsyncClient.downloadToFile(downloadFilePath, range).block();
    }

    public Response<FileDownloadInfo> downloadWithProperties() {
        return (Response)this.fileAsyncClient.downloadWithProperties(null, null).block();
    }

    public Response<FileDownloadInfo> downloadWithProperties(FileRange range, Boolean rangeGetContentMD5) {
        return (Response)this.fileAsyncClient.downloadWithProperties(range, rangeGetContentMD5).block();
    }

    public VoidResponse delete() {
        return (VoidResponse)this.fileAsyncClient.delete().block();
    }

    public Response<FileProperties> getProperties() {
        return (Response)this.fileAsyncClient.getProperties().block();
    }

    public Response<FileInfo> setHttpHeaders(long newFileSize, FileHTTPHeaders httpHeaders) {
        return (Response)this.fileAsyncClient.setHttpHeaders(newFileSize, httpHeaders).block();
    }

    public Response<FileMetadataInfo> setMetadata(Map<String, String> metadata) {
        return (Response)this.fileAsyncClient.setMetadata(metadata).block();
    }

    public Response<FileUploadInfo> upload(ByteBuf data, long length) {
        return (Response)this.fileAsyncClient.upload((Flux<ByteBuf>)Flux.just((Object)data), length).block();
    }

    public Response<FileUploadInfo> upload(ByteBuf data, long length, int offset, FileRangeWriteType type) {
        return (Response)this.fileAsyncClient.upload((Flux<ByteBuf>)Flux.just((Object)data), length, offset, type).block();
    }

    public void uploadFromFile(String uploadFilePath) {
        this.uploadFromFile(uploadFilePath, FileRangeWriteType.UPDATE);
    }

    public void uploadFromFile(String uploadFilePath, FileRangeWriteType type) {
        this.fileAsyncClient.uploadFromFile(uploadFilePath, type).block();
    }

    public Iterable<FileRange> listRanges() {
        return this.fileAsyncClient.listRanges(null).toIterable();
    }

    public Iterable<FileRange> listRanges(FileRange range) {
        return this.fileAsyncClient.listRanges(range).toIterable();
    }

    public Iterable<HandleItem> listHandles() {
        return this.listHandles(null);
    }

    public Iterable<HandleItem> listHandles(Integer maxResults) {
        return this.fileAsyncClient.listHandles(maxResults).toIterable();
    }

    public Iterable<Integer> forceCloseHandles(String handleId) {
        return this.fileAsyncClient.forceCloseHandles(handleId).toIterable();
    }

    public String getShareSnapshotId() {
        return this.fileAsyncClient.getShareSnapshotId();
    }
}

