/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.core.util.Context;
import com.azure.storage.file.ShareAsyncClient;
import com.azure.storage.file.implementation.AzureFileStorageBuilder;
import com.azure.storage.file.implementation.AzureFileStorageImpl;
import com.azure.storage.file.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.models.FileServiceProperties;
import com.azure.storage.file.models.ListSharesIncludeType;
import com.azure.storage.file.models.ListSharesOptions;
import com.azure.storage.file.models.ListSharesResponse;
import com.azure.storage.file.models.ServicesListSharesSegmentResponse;
import com.azure.storage.file.models.ShareItem;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FileServiceAsyncClient {
    private final AzureFileStorageImpl azureFileStorageClient;

    FileServiceAsyncClient(URL endpoint, HttpPipeline httpPipeline) {
        this.azureFileStorageClient = new AzureFileStorageBuilder().pipeline(httpPipeline).url(endpoint.toString()).build();
    }

    public URL getFileServiceUrl() {
        try {
            return new URL(this.azureFileStorageClient.getUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Invalid URL on %s: %s" + this.getClass().getSimpleName(), this.azureFileStorageClient.getUrl()), e);
        }
    }

    public ShareAsyncClient getShareAsyncClient(String shareName) {
        return new ShareAsyncClient(this.azureFileStorageClient, shareName);
    }

    public Flux<ShareItem> listShares() {
        return this.listShares(null);
    }

    public Flux<ShareItem> listShares(ListSharesOptions options) {
        return this.listShares(null, options);
    }

    private Flux<ShareItem> listShares(String marker, ListSharesOptions options) {
        String prefix = null;
        Integer maxResults = null;
        ArrayList<ListSharesIncludeType> include = new ArrayList<ListSharesIncludeType>();
        if (options != null) {
            prefix = options.prefix();
            maxResults = options.maxResults();
            if (options.includeMetadata()) {
                include.add(ListSharesIncludeType.fromString(ListSharesIncludeType.METADATA.toString()));
            }
            if (options.includeSnapshots()) {
                include.add(ListSharesIncludeType.fromString(ListSharesIncludeType.SNAPSHOTS.toString()));
            }
        }
        return this.azureFileStorageClient.services().listSharesSegmentWithRestResponseAsync(prefix, marker, maxResults, include, null, Context.NONE).flatMapMany(response -> Flux.fromIterable(response.value().shareItems()));
    }

    private Flux<ShareItem> listShares(ServicesListSharesSegmentResponse response, List<ListSharesIncludeType> include, Context context) {
        ListSharesResponse value = response.value();
        Mono<ServicesListSharesSegmentResponse> result = this.azureFileStorageClient.services().listSharesSegmentWithRestResponseAsync(value.prefix(), value.marker(), value.maxResults(), include, null, context);
        return result.flatMapMany(r -> this.extractAndFetchShares((ServicesListSharesSegmentResponse)((Object)r), include, context));
    }

    private Publisher<ShareItem> extractAndFetchShares(ServicesListSharesSegmentResponse response, List<ListSharesIncludeType> include, Context context) {
        String nextPageLink = response.value().nextMarker();
        if (ImplUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Flux.fromIterable(response.value().shareItems());
        }
        return Flux.fromIterable(response.value().shareItems()).concatWith(this.listShares(response, include, context));
    }

    public Mono<Response<FileServiceProperties>> getProperties() {
        return this.azureFileStorageClient.services().getPropertiesWithRestResponseAsync(Context.NONE).map(response -> new SimpleResponse((Response)response, (Object)response.value()));
    }

    public Mono<VoidResponse> setProperties(FileServiceProperties properties) {
        return this.azureFileStorageClient.services().setPropertiesWithRestResponseAsync(properties, Context.NONE).map(VoidResponse::new);
    }

    public Mono<Response<ShareAsyncClient>> createShare(String shareName) {
        return this.createShare(shareName, null, null);
    }

    public Mono<Response<ShareAsyncClient>> createShare(String shareName, Map<String, String> metadata, Integer quotaInGB) {
        ShareAsyncClient shareAsyncClient = new ShareAsyncClient(this.azureFileStorageClient, shareName);
        return shareAsyncClient.create(metadata, quotaInGB).map(response -> new SimpleResponse(response, (Object)shareAsyncClient));
    }

    public Mono<VoidResponse> deleteShare(String shareName) {
        return this.deleteShare(shareName, null);
    }

    public Mono<VoidResponse> deleteShare(String shareName, String snapshot) {
        DeleteSnapshotsOptionType deleteSnapshots = null;
        if (ImplUtils.isNullOrEmpty((CharSequence)snapshot)) {
            deleteSnapshots = DeleteSnapshotsOptionType.fromString(DeleteSnapshotsOptionType.INCLUDE.toString());
        }
        return this.azureFileStorageClient.shares().deleteWithRestResponseAsync(shareName, snapshot, null, deleteSnapshots, Context.NONE).map(VoidResponse::new);
    }
}

