/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.storage.file.FileServiceAsyncClient;
import com.azure.storage.file.ShareClient;
import com.azure.storage.file.models.FileServiceProperties;
import com.azure.storage.file.models.ListSharesOptions;
import com.azure.storage.file.models.ShareItem;
import java.net.URL;
import java.util.Map;

public final class FileServiceClient {
    private final FileServiceAsyncClient fileServiceAsyncClient;

    FileServiceClient(FileServiceAsyncClient client) {
        this.fileServiceAsyncClient = client;
    }

    public URL getFileServiceUrl() {
        return this.fileServiceAsyncClient.getFileServiceUrl();
    }

    public ShareClient getShareClient(String shareName) {
        return new ShareClient(this.fileServiceAsyncClient.getShareAsyncClient(shareName));
    }

    public Iterable<ShareItem> listShares() {
        return this.listShares(null);
    }

    public Iterable<ShareItem> listShares(ListSharesOptions options) {
        return this.fileServiceAsyncClient.listShares(options).toIterable();
    }

    public Response<FileServiceProperties> getProperties() {
        return (Response)this.fileServiceAsyncClient.getProperties().block();
    }

    public VoidResponse setProperties(FileServiceProperties properties) {
        return (VoidResponse)this.fileServiceAsyncClient.setProperties(properties).block();
    }

    public Response<ShareClient> createShare(String shareName) {
        return this.createShare(shareName, null, null);
    }

    public Response<ShareClient> createShare(String shareName, Map<String, String> metadata, Integer quotaInGB) {
        ShareClient shareClient = this.getShareClient(shareName);
        return new SimpleResponse(shareClient.create(metadata, quotaInGB), (Object)shareClient);
    }

    public VoidResponse deleteShare(String shareName) {
        return this.deleteShare(shareName, null);
    }

    public VoidResponse deleteShare(String shareName, String snapshot) {
        return (VoidResponse)this.fileServiceAsyncClient.deleteShare(shareName, snapshot).block();
    }
}

