/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.implementation.http.policy.spi.HttpPolicyProviders;
import com.azure.core.util.configuration.Configuration;
import com.azure.core.util.configuration.ConfigurationManager;
import com.azure.storage.common.credentials.SASTokenCredential;
import com.azure.storage.common.credentials.SharedKeyCredential;
import com.azure.storage.common.policy.SASTokenCredentialPolicy;
import com.azure.storage.common.policy.SharedKeyCredentialPolicy;
import com.azure.storage.file.FileServiceAsyncClient;
import com.azure.storage.file.FileServiceClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class FileServiceClientBuilder {
    private static final String ACCOUNT_NAME = "accountname";
    private final List<HttpPipelinePolicy> policies;
    private URL endpoint;
    private SASTokenCredential sasTokenCredential;
    private SharedKeyCredential sharedKeyCredential;
    private HttpClient httpClient;
    private HttpPipeline pipeline;
    private HttpLogDetailLevel logLevel;
    private RetryPolicy retryPolicy = new RetryPolicy();
    private Configuration configuration;

    public FileServiceClientBuilder() {
        this.logLevel = HttpLogDetailLevel.NONE;
        this.policies = new ArrayList<HttpPipelinePolicy>();
        this.configuration = ConfigurationManager.getConfiguration();
    }

    public FileServiceAsyncClient buildAsyncClient() {
        if (this.pipeline != null) {
            return new FileServiceAsyncClient(this.endpoint, this.pipeline);
        }
        if (this.sasTokenCredential == null && this.sharedKeyCredential == null) {
            throw new IllegalArgumentException("Credentials are required for authorization");
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(new UserAgentPolicy("azure-storage-file", "12.0.0-preview.2", this.configuration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddDatePolicy());
        if (this.sharedKeyCredential != null) {
            policies.add(new SharedKeyCredentialPolicy(this.sharedKeyCredential));
        } else {
            policies.add(new SASTokenCredentialPolicy(this.sasTokenCredential));
        }
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy);
        policies.addAll(this.policies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.logLevel));
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return new FileServiceAsyncClient(this.endpoint, pipeline);
    }

    public FileServiceClient buildClient() {
        return new FileServiceClient(this.buildAsyncClient());
    }

    public FileServiceClientBuilder endpoint(String endpoint) {
        try {
            URL fullURL = new URL(endpoint);
            this.endpoint = new URL(fullURL.getProtocol() + "://" + fullURL.getHost());
            this.sasTokenCredential = SASTokenCredential.fromQuery(fullURL.getQuery());
            if (this.sasTokenCredential != null) {
                this.sharedKeyCredential = null;
            }
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("The Azure Storage File Service endpoint url is malformed.");
        }
        return this;
    }

    public FileServiceClientBuilder credential(SASTokenCredential credential) {
        this.sasTokenCredential = Objects.requireNonNull(credential);
        this.sharedKeyCredential = null;
        return this;
    }

    public FileServiceClientBuilder credential(SharedKeyCredential credential) {
        this.sharedKeyCredential = Objects.requireNonNull(credential);
        this.sasTokenCredential = null;
        return this;
    }

    public FileServiceClientBuilder connectionString(String connectionString) {
        Objects.requireNonNull(connectionString);
        this.sharedKeyCredential = SharedKeyCredential.fromConnectionString(connectionString);
        this.getEndPointFromConnectionString(connectionString);
        return this;
    }

    private void getEndPointFromConnectionString(String connectionString) {
        HashMap<String, String> connectionStringPieces = new HashMap<String, String>();
        for (String connectionStringPiece : connectionString.split(";")) {
            String[] kvp = connectionStringPiece.split("=", 2);
            connectionStringPieces.put(kvp[0].toLowerCase(Locale.ROOT), kvp[1]);
        }
        String accountName = (String)connectionStringPieces.get(ACCOUNT_NAME);
        try {
            this.endpoint = new URL(String.format("https://%s.file.core.windows.net", accountName));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("There is no valid endpoint for the connection string. Connection String: %s", connectionString));
        }
    }

    public FileServiceClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient);
        return this;
    }

    public FileServiceClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        Objects.requireNonNull(pipelinePolicy);
        this.policies.add(pipelinePolicy);
        return this;
    }

    public FileServiceClientBuilder httpLogDetailLevel(HttpLogDetailLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public FileServiceClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = Objects.requireNonNull(pipeline);
        return this;
    }

    public FileServiceClientBuilder configuration(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        return this;
    }
}

