/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.core.util.Context;
import com.azure.storage.file.DirectoryAsyncClient;
import com.azure.storage.file.FileAsyncClient;
import com.azure.storage.file.implementation.AzureFileStorageBuilder;
import com.azure.storage.file.implementation.AzureFileStorageImpl;
import com.azure.storage.file.models.FileHTTPHeaders;
import com.azure.storage.file.models.ShareCreateSnapshotHeaders;
import com.azure.storage.file.models.ShareGetPropertiesHeaders;
import com.azure.storage.file.models.ShareInfo;
import com.azure.storage.file.models.ShareProperties;
import com.azure.storage.file.models.ShareSnapshotInfo;
import com.azure.storage.file.models.ShareStatistics;
import com.azure.storage.file.models.SharesCreateSnapshotResponse;
import com.azure.storage.file.models.SharesGetPropertiesResponse;
import com.azure.storage.file.models.SharesGetStatisticsResponse;
import com.azure.storage.file.models.SignedIdentifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ShareAsyncClient {
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String snapshot;

    ShareAsyncClient(AzureFileStorageImpl client, String shareName) {
        this.shareName = shareName;
        this.snapshot = null;
        this.azureFileStorageClient = client;
    }

    ShareAsyncClient(URL endpoint, HttpPipeline httpPipeline, String shareName, String snapshot) {
        this.shareName = shareName;
        this.snapshot = snapshot;
        this.azureFileStorageClient = new AzureFileStorageBuilder().pipeline(httpPipeline).url(endpoint.toString()).build();
    }

    public URL getShareUrl() {
        try {
            return new URL(this.azureFileStorageClient.getUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Invalid URL on %s: %s" + this.getClass().getSimpleName(), this.azureFileStorageClient.getUrl()), e);
        }
    }

    public DirectoryAsyncClient getRootDirectoryClient() {
        return this.getDirectoryClient("");
    }

    public DirectoryAsyncClient getDirectoryClient(String directoryName) {
        return new DirectoryAsyncClient(this.azureFileStorageClient, this.shareName, directoryName, this.snapshot);
    }

    public FileAsyncClient getFileClient(String filePath) {
        return new FileAsyncClient(this.azureFileStorageClient, this.shareName, filePath, null);
    }

    public Mono<Response<ShareInfo>> create() {
        return this.create(null, null);
    }

    public Mono<Response<ShareInfo>> create(Map<String, String> metadata, Integer quotaInGB) {
        return this.azureFileStorageClient.shares().createWithRestResponseAsync(this.shareName, null, metadata, quotaInGB, Context.NONE).map(this::mapToShareInfoResponse);
    }

    public Mono<Response<ShareSnapshotInfo>> createSnapshot() {
        return this.createSnapshot(null);
    }

    public Mono<Response<ShareSnapshotInfo>> createSnapshot(Map<String, String> metadata) {
        return this.azureFileStorageClient.shares().createSnapshotWithRestResponseAsync(this.shareName, null, metadata, Context.NONE).map(this::mapCreateSnapshotResponse);
    }

    public Mono<VoidResponse> delete() {
        return this.azureFileStorageClient.shares().deleteWithRestResponseAsync(this.shareName, this.snapshot, null, null, Context.NONE).map(VoidResponse::new);
    }

    public Mono<Response<ShareProperties>> getProperties() {
        return this.azureFileStorageClient.shares().getPropertiesWithRestResponseAsync(this.shareName, this.snapshot, null, Context.NONE).map(this::mapGetPropertiesResponse);
    }

    public Mono<Response<ShareInfo>> setQuota(int quotaInGB) {
        return this.azureFileStorageClient.shares().setQuotaWithRestResponseAsync(this.shareName, null, quotaInGB, Context.NONE).map(this::mapToShareInfoResponse);
    }

    public Mono<Response<ShareInfo>> setMetadata(Map<String, String> metadata) {
        return this.azureFileStorageClient.shares().setMetadataWithRestResponseAsync(this.shareName, null, metadata, Context.NONE).map(this::mapToShareInfoResponse);
    }

    public Flux<SignedIdentifier> getAccessPolicy() {
        return this.azureFileStorageClient.shares().getAccessPolicyWithRestResponseAsync(this.shareName, Context.NONE).flatMapMany(response -> Flux.fromIterable((Iterable)response.value()));
    }

    public Mono<Response<ShareInfo>> setAccessPolicy(List<SignedIdentifier> permissions) {
        return this.azureFileStorageClient.shares().setAccessPolicyWithRestResponseAsync(this.shareName, permissions, null, Context.NONE).map(this::mapToShareInfoResponse);
    }

    public Mono<Response<ShareStatistics>> getStatistics() {
        return this.azureFileStorageClient.shares().getStatisticsWithRestResponseAsync(this.shareName, Context.NONE).map(this::mapGetStatisticsResponse);
    }

    public Mono<Response<DirectoryAsyncClient>> createDirectory(String directoryName) {
        return this.createDirectory(directoryName, null);
    }

    public Mono<Response<DirectoryAsyncClient>> createDirectory(String directoryName, Map<String, String> metadata) {
        DirectoryAsyncClient directoryAsyncClient = this.getDirectoryClient(directoryName);
        return directoryAsyncClient.create(metadata).map(response -> new SimpleResponse(response, (Object)directoryAsyncClient));
    }

    public Mono<Response<FileAsyncClient>> createFile(String fileName, long maxSize) {
        return this.createFile(fileName, maxSize, null, null);
    }

    public Mono<Response<FileAsyncClient>> createFile(String fileName, long maxSize, FileHTTPHeaders httpHeaders, Map<String, String> metadata) {
        FileAsyncClient fileAsyncClient = this.getFileClient(fileName);
        return fileAsyncClient.create(maxSize, httpHeaders, metadata).map(response -> new SimpleResponse(response, (Object)fileAsyncClient));
    }

    public Mono<VoidResponse> deleteDirectory(String directoryName) {
        return this.getDirectoryClient(directoryName).delete().map(VoidResponse::new);
    }

    public Mono<VoidResponse> deleteFile(String fileName) {
        return this.getFileClient(fileName).delete().map(VoidResponse::new);
    }

    public String getSnapshotId() {
        return this.snapshot;
    }

    private Response<ShareInfo> mapToShareInfoResponse(Response<?> response) {
        String eTag = response.headers().value("ETag");
        OffsetDateTime lastModified = new DateTimeRfc1123(response.headers().value("Last-Modified")).dateTime();
        return new SimpleResponse(response.request(), response.statusCode(), response.headers(), (Object)new ShareInfo(eTag, lastModified));
    }

    private Response<ShareSnapshotInfo> mapCreateSnapshotResponse(SharesCreateSnapshotResponse response) {
        ShareCreateSnapshotHeaders headers = (ShareCreateSnapshotHeaders)response.deserializedHeaders();
        ShareSnapshotInfo snapshotInfo = new ShareSnapshotInfo(headers.snapshot(), headers.eTag(), headers.lastModified());
        return new SimpleResponse(response.request(), response.statusCode(), response.headers(), (Object)snapshotInfo);
    }

    private Response<ShareProperties> mapGetPropertiesResponse(SharesGetPropertiesResponse response) {
        ShareGetPropertiesHeaders headers = (ShareGetPropertiesHeaders)response.deserializedHeaders();
        ShareProperties shareProperties = new ShareProperties().quota(headers.quota()).etag(headers.eTag()).lastModified(headers.lastModified()).metadata(headers.metadata());
        return new SimpleResponse(response.request(), response.statusCode(), response.headers(), (Object)shareProperties);
    }

    private Response<ShareStatistics> mapGetStatisticsResponse(SharesGetStatisticsResponse response) {
        ShareStatistics shareStatistics = new ShareStatistics((int)(response.value().shareUsageBytes() / 1024L));
        return new SimpleResponse(response.request(), response.statusCode(), response.headers(), (Object)shareStatistics);
    }
}

