/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.storage.file.DirectoryClient;
import com.azure.storage.file.FileClient;
import com.azure.storage.file.ShareAsyncClient;
import com.azure.storage.file.models.FileHTTPHeaders;
import com.azure.storage.file.models.ShareInfo;
import com.azure.storage.file.models.ShareProperties;
import com.azure.storage.file.models.ShareSnapshotInfo;
import com.azure.storage.file.models.ShareStatistics;
import com.azure.storage.file.models.SignedIdentifier;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class ShareClient {
    private final ShareAsyncClient client;

    ShareClient(ShareAsyncClient client) {
        this.client = client;
    }

    public URL getShareUrl() {
        return this.client.getShareUrl();
    }

    public DirectoryClient getRootDirectoryClient() {
        return this.getDirectoryClient("");
    }

    public DirectoryClient getDirectoryClient(String directoryName) {
        return new DirectoryClient(this.client.getDirectoryClient(directoryName));
    }

    public FileClient getFileClient(String filePath) {
        return new FileClient(this.client.getFileClient(filePath));
    }

    public Response<ShareInfo> create() {
        return this.create(null, null);
    }

    public Response<ShareInfo> create(Map<String, String> metadata, Integer quotaInGB) {
        return (Response)this.client.create(metadata, quotaInGB).block();
    }

    public Response<ShareSnapshotInfo> createSnapshot() {
        return this.createSnapshot(null);
    }

    public Response<ShareSnapshotInfo> createSnapshot(Map<String, String> metadata) {
        return (Response)this.client.createSnapshot(metadata).block();
    }

    public VoidResponse delete() {
        return (VoidResponse)this.client.delete().block();
    }

    public Response<ShareProperties> getProperties() {
        return (Response)this.client.getProperties().block();
    }

    public Response<ShareInfo> setQuota(int quotaInGB) {
        return (Response)this.client.setQuota(quotaInGB).block();
    }

    public Response<ShareInfo> setMetadata(Map<String, String> metadata) {
        return (Response)this.client.setMetadata(metadata).block();
    }

    public Iterable<SignedIdentifier> getAccessPolicy() {
        return this.client.getAccessPolicy().toIterable();
    }

    public Response<ShareInfo> setAccessPolicy(List<SignedIdentifier> permissions) {
        return (Response)this.client.setAccessPolicy(permissions).block();
    }

    public Response<ShareStatistics> getStatistics() {
        return (Response)this.client.getStatistics().block();
    }

    public Response<DirectoryClient> createDirectory(String directoryName) {
        return this.createDirectory(directoryName, null);
    }

    public Response<DirectoryClient> createDirectory(String directoryName, Map<String, String> metadata) {
        DirectoryClient directoryClient = this.getDirectoryClient(directoryName);
        return new SimpleResponse(directoryClient.create(metadata), (Object)directoryClient);
    }

    public Response<FileClient> createFile(String fileName, long maxSize) {
        return this.createFile(fileName, maxSize, null, null);
    }

    public Response<FileClient> createFile(String fileName, long maxSize, FileHTTPHeaders httpHeaders, Map<String, String> metadata) {
        FileClient fileClient = this.getFileClient(fileName);
        return new SimpleResponse(fileClient.create(maxSize, httpHeaders, metadata), (Object)fileClient);
    }

    public VoidResponse deleteDirectory(String directoryName) {
        return (VoidResponse)this.client.deleteDirectory(directoryName).block();
    }

    public VoidResponse deleteFile(String fileName) {
        return (VoidResponse)this.client.deleteFile(fileName).block();
    }

    public String getSnapshotId() {
        return this.client.getSnapshotId();
    }
}

