/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.implementation.RestProxy;
import com.azure.core.implementation.annotation.ServiceClientBuilder;
import com.azure.storage.file.implementation.AzureFileStorageImpl;

@ServiceClientBuilder(serviceClients={AzureFileStorageImpl.class})
public final class AzureFileStorageBuilder {
    private String version;
    private String url;
    private HttpPipeline pipeline;

    public AzureFileStorageBuilder version(String version) {
        this.version = version;
        return this;
    }

    public AzureFileStorageBuilder url(String url) {
        this.url = url;
        return this;
    }

    public AzureFileStorageBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public AzureFileStorageImpl build() {
        if (this.pipeline == null) {
            this.pipeline = RestProxy.createDefaultPipeline();
        }
        AzureFileStorageImpl client = new AzureFileStorageImpl(this.pipeline);
        if (this.version != null) {
            client.setVersion(this.version);
        } else {
            client.setVersion("2018-11-09");
        }
        if (this.url != null) {
            client.setUrl(this.url);
        }
        return client;
    }
}

