/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.implementation.RestProxy;
import com.azure.core.implementation.annotation.BodyParam;
import com.azure.core.implementation.annotation.Delete;
import com.azure.core.implementation.annotation.ExpectedResponses;
import com.azure.core.implementation.annotation.Get;
import com.azure.core.implementation.annotation.Head;
import com.azure.core.implementation.annotation.HeaderParam;
import com.azure.core.implementation.annotation.Host;
import com.azure.core.implementation.annotation.HostParam;
import com.azure.core.implementation.annotation.PathParam;
import com.azure.core.implementation.annotation.Put;
import com.azure.core.implementation.annotation.QueryParam;
import com.azure.core.implementation.annotation.ServiceInterface;
import com.azure.core.implementation.annotation.UnexpectedResponseExceptionType;
import com.azure.core.implementation.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.storage.file.implementation.AzureFileStorageImpl;
import com.azure.storage.file.models.FileHTTPHeaders;
import com.azure.storage.file.models.FileRangeWriteType;
import com.azure.storage.file.models.FilesAbortCopyResponse;
import com.azure.storage.file.models.FilesCreateResponse;
import com.azure.storage.file.models.FilesDeleteResponse;
import com.azure.storage.file.models.FilesDownloadResponse;
import com.azure.storage.file.models.FilesForceCloseHandlesResponse;
import com.azure.storage.file.models.FilesGetPropertiesResponse;
import com.azure.storage.file.models.FilesGetRangeListResponse;
import com.azure.storage.file.models.FilesListHandlesResponse;
import com.azure.storage.file.models.FilesSetHTTPHeadersResponse;
import com.azure.storage.file.models.FilesSetMetadataResponse;
import com.azure.storage.file.models.FilesStartCopyResponse;
import com.azure.storage.file.models.FilesUploadRangeResponse;
import com.azure.storage.file.models.StorageErrorException;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FilesImpl {
    private FilesService service;
    private AzureFileStorageImpl client;

    public FilesImpl(AzureFileStorageImpl client) {
        this.service = (FilesService)RestProxy.create(FilesService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<FilesCreateResponse> createWithRestResponseAsync(String shareName, String filePath, long fileContentLength, Context context) {
        Integer timeout = null;
        String fileTypeConstant = "file";
        Map<String, String> metadata = null;
        String fileContentType = null;
        String fileContentEncoding = null;
        String fileContentLanguage = null;
        String fileCacheControl = null;
        String fileContentDisposition = null;
        String fileContentMD5Converted = null;
        return this.service.create(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, "file", metadata, fileContentType, fileContentEncoding, fileContentLanguage, fileCacheControl, fileContentMD5Converted, fileContentDisposition, context);
    }

    public Mono<FilesCreateResponse> createWithRestResponseAsync(String shareName, String filePath, long fileContentLength, Integer timeout, Map<String, String> metadata, FileHTTPHeaders fileHTTPHeaders, Context context) {
        String fileTypeConstant = "file";
        String fileContentType = null;
        if (fileHTTPHeaders != null) {
            fileContentType = fileHTTPHeaders.fileContentType();
        }
        String fileContentEncoding = null;
        if (fileHTTPHeaders != null) {
            fileContentEncoding = fileHTTPHeaders.fileContentEncoding();
        }
        String fileContentLanguage = null;
        if (fileHTTPHeaders != null) {
            fileContentLanguage = fileHTTPHeaders.fileContentLanguage();
        }
        String fileCacheControl = null;
        if (fileHTTPHeaders != null) {
            fileCacheControl = fileHTTPHeaders.fileCacheControl();
        }
        byte[] fileContentMD5 = null;
        if (fileHTTPHeaders != null) {
            fileContentMD5 = fileHTTPHeaders.fileContentMD5();
        }
        String fileContentDisposition = null;
        if (fileHTTPHeaders != null) {
            fileContentDisposition = fileHTTPHeaders.fileContentDisposition();
        }
        String fileContentMD5Converted = Base64Util.encodeToString((byte[])fileContentMD5);
        return this.service.create(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, "file", metadata, fileContentType, fileContentEncoding, fileContentLanguage, fileCacheControl, fileContentMD5Converted, fileContentDisposition, context);
    }

    public Mono<FilesDownloadResponse> downloadWithRestResponseAsync(String shareName, String filePath, Context context) {
        Integer timeout = null;
        String range = null;
        Boolean rangeGetContentMD5 = null;
        return this.service.download(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), range, rangeGetContentMD5, context);
    }

    public Mono<FilesDownloadResponse> downloadWithRestResponseAsync(String shareName, String filePath, Integer timeout, String range, Boolean rangeGetContentMD5, Context context) {
        return this.service.download(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), range, rangeGetContentMD5, context);
    }

    public Mono<FilesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, String filePath, Context context) {
        String sharesnapshot = null;
        Integer timeout = null;
        return this.service.getProperties(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), context);
    }

    public Mono<FilesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, String filePath, String sharesnapshot, Integer timeout, Context context) {
        return this.service.getProperties(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), context);
    }

    public Mono<FilesDeleteResponse> deleteWithRestResponseAsync(String shareName, String filePath, Context context) {
        Integer timeout = null;
        return this.service.delete(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), context);
    }

    public Mono<FilesDeleteResponse> deleteWithRestResponseAsync(String shareName, String filePath, Integer timeout, Context context) {
        return this.service.delete(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), context);
    }

    public Mono<FilesSetHTTPHeadersResponse> setHTTPHeadersWithRestResponseAsync(String shareName, String filePath, Context context) {
        Integer timeout = null;
        Long fileContentLength = null;
        String comp = "properties";
        String fileContentType = null;
        String fileContentEncoding = null;
        String fileContentLanguage = null;
        String fileCacheControl = null;
        String fileContentDisposition = null;
        String fileContentMD5Converted = null;
        return this.service.setHTTPHeaders(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, "properties", fileContentType, fileContentEncoding, fileContentLanguage, fileCacheControl, fileContentMD5Converted, fileContentDisposition, context);
    }

    public Mono<FilesSetHTTPHeadersResponse> setHTTPHeadersWithRestResponseAsync(String shareName, String filePath, Integer timeout, Long fileContentLength, FileHTTPHeaders fileHTTPHeaders, Context context) {
        String comp = "properties";
        String fileContentType = null;
        if (fileHTTPHeaders != null) {
            fileContentType = fileHTTPHeaders.fileContentType();
        }
        String fileContentEncoding = null;
        if (fileHTTPHeaders != null) {
            fileContentEncoding = fileHTTPHeaders.fileContentEncoding();
        }
        String fileContentLanguage = null;
        if (fileHTTPHeaders != null) {
            fileContentLanguage = fileHTTPHeaders.fileContentLanguage();
        }
        String fileCacheControl = null;
        if (fileHTTPHeaders != null) {
            fileCacheControl = fileHTTPHeaders.fileCacheControl();
        }
        byte[] fileContentMD5 = null;
        if (fileHTTPHeaders != null) {
            fileContentMD5 = fileHTTPHeaders.fileContentMD5();
        }
        String fileContentDisposition = null;
        if (fileHTTPHeaders != null) {
            fileContentDisposition = fileHTTPHeaders.fileContentDisposition();
        }
        String fileContentMD5Converted = Base64Util.encodeToString((byte[])fileContentMD5);
        return this.service.setHTTPHeaders(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), fileContentLength, "properties", fileContentType, fileContentEncoding, fileContentLanguage, fileCacheControl, fileContentMD5Converted, fileContentDisposition, context);
    }

    public Mono<FilesSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, String filePath, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String comp = "metadata";
        return this.service.setMetadata(shareName, filePath, this.client.getUrl(), timeout, metadata, this.client.getVersion(), "metadata", context);
    }

    public Mono<FilesSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, String filePath, Integer timeout, Map<String, String> metadata, Context context) {
        String comp = "metadata";
        return this.service.setMetadata(shareName, filePath, this.client.getUrl(), timeout, metadata, this.client.getVersion(), "metadata", context);
    }

    public Mono<FilesUploadRangeResponse> uploadRangeWithRestResponseAsync(String shareName, String filePath, String range, FileRangeWriteType fileRangeWrite, long contentLength, Context context) {
        Flux<ByteBuf> optionalbody = null;
        Integer timeout = null;
        String comp = "range";
        String contentMD5Converted = null;
        return this.service.uploadRange(shareName, filePath, this.client.getUrl(), optionalbody, timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), "range", context);
    }

    public Mono<FilesUploadRangeResponse> uploadRangeWithRestResponseAsync(String shareName, String filePath, String range, FileRangeWriteType fileRangeWrite, long contentLength, Flux<ByteBuf> optionalbody, Integer timeout, byte[] contentMD5, Context context) {
        String comp = "range";
        String contentMD5Converted = Base64Util.encodeToString((byte[])contentMD5);
        return this.service.uploadRange(shareName, filePath, this.client.getUrl(), optionalbody, timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), "range", context);
    }

    public Mono<FilesGetRangeListResponse> getRangeListWithRestResponseAsync(String shareName, String filePath, Context context) {
        String sharesnapshot = null;
        Integer timeout = null;
        String range = null;
        String comp = "rangelist";
        return this.service.getRangeList(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), range, "rangelist", context);
    }

    public Mono<FilesGetRangeListResponse> getRangeListWithRestResponseAsync(String shareName, String filePath, String sharesnapshot, Integer timeout, String range, Context context) {
        String comp = "rangelist";
        return this.service.getRangeList(shareName, filePath, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), range, "rangelist", context);
    }

    public Mono<FilesStartCopyResponse> startCopyWithRestResponseAsync(String shareName, String filePath, String copySource, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        return this.service.startCopy(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), metadata, copySource, context);
    }

    public Mono<FilesStartCopyResponse> startCopyWithRestResponseAsync(String shareName, String filePath, String copySource, Integer timeout, Map<String, String> metadata, Context context) {
        return this.service.startCopy(shareName, filePath, this.client.getUrl(), timeout, this.client.getVersion(), metadata, copySource, context);
    }

    public Mono<FilesAbortCopyResponse> abortCopyWithRestResponseAsync(String shareName, String filePath, String copyId, Context context) {
        Integer timeout = null;
        String copyActionAbortConstant = "abort";
        String comp = "copy";
        return this.service.abortCopy(shareName, filePath, this.client.getUrl(), copyId, timeout, "abort", this.client.getVersion(), "copy", context);
    }

    public Mono<FilesAbortCopyResponse> abortCopyWithRestResponseAsync(String shareName, String filePath, String copyId, Integer timeout, Context context) {
        String copyActionAbortConstant = "abort";
        String comp = "copy";
        return this.service.abortCopy(shareName, filePath, this.client.getUrl(), copyId, timeout, "abort", this.client.getVersion(), "copy", context);
    }

    public Mono<FilesListHandlesResponse> listHandlesWithRestResponseAsync(String shareName, String filePath, Context context) {
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String sharesnapshot = null;
        String comp = "listhandles";
        return this.service.listHandles(shareName, filePath, this.client.getUrl(), marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), "listhandles", context);
    }

    public Mono<FilesListHandlesResponse> listHandlesWithRestResponseAsync(String shareName, String filePath, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Context context) {
        String comp = "listhandles";
        return this.service.listHandles(shareName, filePath, this.client.getUrl(), marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), "listhandles", context);
    }

    public Mono<FilesForceCloseHandlesResponse> forceCloseHandlesWithRestResponseAsync(String shareName, String filePath, String handleId, Context context) {
        Integer timeout = null;
        String marker = null;
        String sharesnapshot = null;
        String comp = "forceclosehandles";
        return this.service.forceCloseHandles(shareName, filePath, this.client.getUrl(), timeout, marker, sharesnapshot, handleId, this.client.getVersion(), "forceclosehandles", context);
    }

    public Mono<FilesForceCloseHandlesResponse> forceCloseHandlesWithRestResponseAsync(String shareName, String filePath, String handleId, Integer timeout, String marker, String sharesnapshot, Context context) {
        String comp = "forceclosehandles";
        return this.service.forceCloseHandles(shareName, filePath, this.client.getUrl(), timeout, marker, sharesnapshot, handleId, this.client.getVersion(), "forceclosehandles", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageFiles")
    private static interface FilesService {
        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesCreateResponse> create(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-content-length") long var6, @HeaderParam(value="x-ms-type") String var8, @HeaderParam(value="x-ms-meta-") Map<String, String> var9, @HeaderParam(value="x-ms-content-type") String var10, @HeaderParam(value="x-ms-content-encoding") String var11, @HeaderParam(value="x-ms-content-language") String var12, @HeaderParam(value="x-ms-cache-control") String var13, @HeaderParam(value="x-ms-content-md5") String var14, @HeaderParam(value="x-ms-content-disposition") String var15, Context var16);

        @Get(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesDownloadResponse> download(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var7, Context var8);

        @Head(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        public Mono<FilesGetPropertiesResponse> getProperties(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, Context var7);

        @Delete(value="{shareName}/{filePath}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesDeleteResponse> delete(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, Context var6);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesSetHTTPHeadersResponse> setHTTPHeaders(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-content-length") Long var6, @QueryParam(value="comp") String var7, @HeaderParam(value="x-ms-content-type") String var8, @HeaderParam(value="x-ms-content-encoding") String var9, @HeaderParam(value="x-ms-content-language") String var10, @HeaderParam(value="x-ms-cache-control") String var11, @HeaderParam(value="x-ms-content-md5") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, Context var14);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesSetMetadataResponse> setMetadata(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesUploadRangeResponse> uploadRange(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @BodyParam(value="application/octet-stream") Flux<ByteBuf> var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-write") FileRangeWriteType var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Content-MD5") String var10, @HeaderParam(value="x-ms-version") String var11, @QueryParam(value="comp") String var12, Context var13);

        @Get(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesGetRangeListResponse> getRangeList(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-range") String var7, @QueryParam(value="comp") String var8, Context var9);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesStartCopyResponse> startCopy(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-copy-source") String var7, Context var8);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesAbortCopyResponse> abortCopy(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="copyid") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-copy-action") String var6, @HeaderParam(value="x-ms-version") String var7, @QueryParam(value="comp") String var8, Context var9);

        @Get(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesListHandlesResponse> listHandles(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="timeout") Integer var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="comp") String var9, Context var10);

        @Put(value="{shareName}/{filePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<FilesForceCloseHandlesResponse> forceCloseHandles(@PathParam(value="shareName") String var1, @PathParam(value="filePath") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @QueryParam(value="marker") String var5, @QueryParam(value="sharesnapshot") String var6, @HeaderParam(value="x-ms-handle-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="comp") String var9, Context var10);
    }
}

