/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.implementation.RestProxy;
import com.azure.core.implementation.annotation.BodyParam;
import com.azure.core.implementation.annotation.Delete;
import com.azure.core.implementation.annotation.ExpectedResponses;
import com.azure.core.implementation.annotation.Get;
import com.azure.core.implementation.annotation.HeaderParam;
import com.azure.core.implementation.annotation.Host;
import com.azure.core.implementation.annotation.HostParam;
import com.azure.core.implementation.annotation.PathParam;
import com.azure.core.implementation.annotation.Put;
import com.azure.core.implementation.annotation.QueryParam;
import com.azure.core.implementation.annotation.ServiceInterface;
import com.azure.core.implementation.annotation.UnexpectedResponseExceptionType;
import com.azure.core.util.Context;
import com.azure.storage.file.implementation.AzureFileStorageImpl;
import com.azure.storage.file.implementation.SignedIdentifiersWrapper;
import com.azure.storage.file.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.models.SharesCreateResponse;
import com.azure.storage.file.models.SharesCreateSnapshotResponse;
import com.azure.storage.file.models.SharesDeleteResponse;
import com.azure.storage.file.models.SharesGetAccessPolicyResponse;
import com.azure.storage.file.models.SharesGetPropertiesResponse;
import com.azure.storage.file.models.SharesGetStatisticsResponse;
import com.azure.storage.file.models.SharesSetAccessPolicyResponse;
import com.azure.storage.file.models.SharesSetMetadataResponse;
import com.azure.storage.file.models.SharesSetQuotaResponse;
import com.azure.storage.file.models.SignedIdentifier;
import com.azure.storage.file.models.StorageErrorException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class SharesImpl {
    private SharesService service;
    private AzureFileStorageImpl client;

    public SharesImpl(AzureFileStorageImpl client) {
        this.service = (SharesService)RestProxy.create(SharesService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<SharesCreateResponse> createWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        Integer quota = null;
        String restype = "share";
        return this.service.create(shareName, this.client.getUrl(), timeout, metadata, quota, this.client.getVersion(), "share", context);
    }

    public Mono<SharesCreateResponse> createWithRestResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, Context context) {
        String restype = "share";
        return this.service.create(shareName, this.client.getUrl(), timeout, metadata, quota, this.client.getVersion(), "share", context);
    }

    public Mono<SharesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, Context context) {
        String sharesnapshot = null;
        Integer timeout = null;
        String restype = "share";
        return this.service.getProperties(shareName, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), "share", context);
    }

    public Mono<SharesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String shareName, String sharesnapshot, Integer timeout, Context context) {
        String restype = "share";
        return this.service.getProperties(shareName, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), "share", context);
    }

    public Mono<SharesDeleteResponse> deleteWithRestResponseAsync(String shareName, Context context) {
        String sharesnapshot = null;
        Integer timeout = null;
        DeleteSnapshotsOptionType deleteSnapshots = null;
        String restype = "share";
        return this.service.delete(shareName, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, "share", context);
    }

    public Mono<SharesDeleteResponse> deleteWithRestResponseAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, Context context) {
        String restype = "share";
        return this.service.delete(shareName, this.client.getUrl(), sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, "share", context);
    }

    public Mono<SharesCreateSnapshotResponse> createSnapshotWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String restype = "share";
        String comp = "snapshot";
        return this.service.createSnapshot(shareName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), "share", "snapshot", context);
    }

    public Mono<SharesCreateSnapshotResponse> createSnapshotWithRestResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "share";
        String comp = "snapshot";
        return this.service.createSnapshot(shareName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), "share", "snapshot", context);
    }

    public Mono<SharesSetQuotaResponse> setQuotaWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        Integer quota = null;
        String restype = "share";
        String comp = "properties";
        return this.service.setQuota(shareName, this.client.getUrl(), timeout, this.client.getVersion(), quota, "share", "properties", context);
    }

    public Mono<SharesSetQuotaResponse> setQuotaWithRestResponseAsync(String shareName, Integer timeout, Integer quota, Context context) {
        String restype = "share";
        String comp = "properties";
        return this.service.setQuota(shareName, this.client.getUrl(), timeout, this.client.getVersion(), quota, "share", "properties", context);
    }

    public Mono<SharesSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String restype = "share";
        String comp = "metadata";
        return this.service.setMetadata(shareName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), "share", "metadata", context);
    }

    public Mono<SharesSetMetadataResponse> setMetadataWithRestResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "share";
        String comp = "metadata";
        return this.service.setMetadata(shareName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), "share", "metadata", context);
    }

    public Mono<SharesGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        String restype = "share";
        String comp = "acl";
        return this.service.getAccessPolicy(shareName, this.client.getUrl(), timeout, this.client.getVersion(), "share", "acl", context);
    }

    public Mono<SharesGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(String shareName, Integer timeout, Context context) {
        String restype = "share";
        String comp = "acl";
        return this.service.getAccessPolicy(shareName, this.client.getUrl(), timeout, this.client.getVersion(), "share", "acl", context);
    }

    public Mono<SharesSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        String restype = "share";
        String comp = "acl";
        SignedIdentifiersWrapper shareAclConverted = new SignedIdentifiersWrapper(null);
        return this.service.setAccessPolicy(shareName, this.client.getUrl(), shareAclConverted, timeout, this.client.getVersion(), "share", "acl", context);
    }

    public Mono<SharesSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(String shareName, List<SignedIdentifier> shareAcl, Integer timeout, Context context) {
        String restype = "share";
        String comp = "acl";
        SignedIdentifiersWrapper shareAclConverted = new SignedIdentifiersWrapper(shareAcl);
        return this.service.setAccessPolicy(shareName, this.client.getUrl(), shareAclConverted, timeout, this.client.getVersion(), "share", "acl", context);
    }

    public Mono<SharesGetStatisticsResponse> getStatisticsWithRestResponseAsync(String shareName, Context context) {
        Integer timeout = null;
        String restype = "share";
        String comp = "stats";
        return this.service.getStatistics(shareName, this.client.getUrl(), timeout, this.client.getVersion(), "share", "stats", context);
    }

    public Mono<SharesGetStatisticsResponse> getStatisticsWithRestResponseAsync(String shareName, Integer timeout, Context context) {
        String restype = "share";
        String comp = "stats";
        return this.service.getStatistics(shareName, this.client.getUrl(), timeout, this.client.getVersion(), "share", "stats", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageShares")
    private static interface SharesService {
        @Put(value="{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<SharesCreateResponse> create(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-share-quota") Integer var5, @HeaderParam(value="x-ms-version") String var6, @QueryParam(value="restype") String var7, Context var8);

        @Get(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<SharesGetPropertiesResponse> getProperties(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="sharesnapshot") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @QueryParam(value="restype") String var6, Context var7);

        @Delete(value="{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<SharesDeleteResponse> delete(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="sharesnapshot") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var6, @QueryParam(value="restype") String var7, Context var8);

        @Put(value="{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<SharesCreateSnapshotResponse> createSnapshot(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Put(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<SharesSetQuotaResponse> setQuota(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-share-quota") Integer var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Put(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<SharesSetMetadataResponse> setMetadata(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Get(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<SharesGetAccessPolicyResponse> getAccessPolicy(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6, Context var7);

        @Put(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<SharesSetAccessPolicyResponse> setAccessPolicy(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @BodyParam(value="application/xml; charset=utf-8") SignedIdentifiersWrapper var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Get(value="{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Mono<SharesGetStatisticsResponse> getStatistics(@PathParam(value="shareName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6, Context var7);
    }
}

