/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.models;

import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.core.implementation.annotation.HeaderCollection;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.storage.file.models.CopyStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="File-Download-Headers")
public final class FileDownloadHeaders {
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="Content-Range")
    private String contentRange;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="x-ms-copy-status-description")
    private String copyStatusDescription;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-progress")
    private String copyProgress;
    @JsonProperty(value="x-ms-copy-source")
    private String copySource;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType copyStatus;
    @JsonProperty(value="x-ms-content-md5")
    private byte[] fileContentMD5;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean isServerEncrypted;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public FileDownloadHeaders lastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public FileDownloadHeaders metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public FileDownloadHeaders contentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public FileDownloadHeaders contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String contentRange() {
        return this.contentRange;
    }

    public FileDownloadHeaders contentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public FileDownloadHeaders eTag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] contentMD5() {
        return ImplUtils.clone((byte[])this.contentMD5);
    }

    public FileDownloadHeaders contentMD5(byte[] contentMD5) {
        this.contentMD5 = ImplUtils.clone((byte[])contentMD5);
        return this;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public FileDownloadHeaders contentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public FileDownloadHeaders cacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public FileDownloadHeaders contentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public FileDownloadHeaders contentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public FileDownloadHeaders requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public FileDownloadHeaders version(String version) {
        this.version = version;
        return this;
    }

    public String acceptRanges() {
        return this.acceptRanges;
    }

    public FileDownloadHeaders acceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public OffsetDateTime dateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.dateTime();
    }

    public FileDownloadHeaders dateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public OffsetDateTime copyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.dateTime();
    }

    public FileDownloadHeaders copyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String copyStatusDescription() {
        return this.copyStatusDescription;
    }

    public FileDownloadHeaders copyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public String copyId() {
        return this.copyId;
    }

    public FileDownloadHeaders copyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String copyProgress() {
        return this.copyProgress;
    }

    public FileDownloadHeaders copyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public String copySource() {
        return this.copySource;
    }

    public FileDownloadHeaders copySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public CopyStatusType copyStatus() {
        return this.copyStatus;
    }

    public FileDownloadHeaders copyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public byte[] fileContentMD5() {
        return ImplUtils.clone((byte[])this.fileContentMD5);
    }

    public FileDownloadHeaders fileContentMD5(byte[] fileContentMD5) {
        this.fileContentMD5 = ImplUtils.clone((byte[])fileContentMD5);
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public FileDownloadHeaders isServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public FileDownloadHeaders errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

