/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.models;

import com.azure.core.implementation.util.ImplUtils;
import com.azure.storage.file.models.CopyStatusType;
import java.time.OffsetDateTime;
import java.util.Map;

public final class FileProperties {
    private final String eTag;
    private final OffsetDateTime lastModified;
    private final Map<String, String> metadata;
    private final String fileType;
    private final Long contentLength;
    private final String contentType;
    private final byte[] contentMD5;
    private final String contentEncoding;
    private final String cacheControl;
    private final String contentDisposition;
    private final OffsetDateTime copyCompletionTime;
    private final String copyStatusDescription;
    private final String copyId;
    private final String copyProgress;
    private final String copySource;
    private final CopyStatusType copyStatus;
    private final Boolean isServerEncrypted;

    public FileProperties(String eTag, OffsetDateTime lastModified, Map<String, String> metadata, String fileType, Long contentLength, String contentType, byte[] contentMD5, String contentEncoding, String cacheControl, String contentDisposition, OffsetDateTime copyCompletionTime, String copyStatusDescription, String copyId, String copyProgress, String copySource, CopyStatusType copyStatus, Boolean isServerEncrypted) {
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.metadata = metadata;
        this.fileType = fileType;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.contentMD5 = ImplUtils.clone((byte[])contentMD5);
        this.contentEncoding = contentEncoding;
        this.cacheControl = cacheControl;
        this.contentDisposition = contentDisposition;
        this.copyCompletionTime = copyCompletionTime;
        this.copyStatusDescription = copyStatusDescription;
        this.copyId = copyId;
        this.copyProgress = copyProgress;
        this.copySource = copySource;
        this.copyStatus = copyStatus;
        this.isServerEncrypted = isServerEncrypted;
    }

    public String eTag() {
        return this.eTag;
    }

    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public String fileType() {
        return this.fileType;
    }

    public String contentType() {
        return this.contentType;
    }

    public byte[] contentMD5() {
        return ImplUtils.clone((byte[])this.contentMD5);
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public OffsetDateTime copyCompletionTime() {
        return this.copyCompletionTime;
    }

    public String copyStatusDescription() {
        return this.copyStatusDescription;
    }

    public String copyId() {
        return this.copyId;
    }

    public String copyProgress() {
        return this.copyProgress;
    }

    public String copySource() {
        return this.copySource;
    }

    public CopyStatusType copyStatus() {
        return this.copyStatus;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }
}

