/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.client.ha;

import com.baidu.jprotobuf.pbrpc.client.ha.NamingService;
import com.baidu.jprotobuf.pbrpc.registry.RegisterInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class NamingServiceChangeListener {
    private static final Logger LOG = Logger.getLogger(NamingServiceChangeListener.class.getName());
    private Timer timer;
    private TimerTask updateListTask;
    private long delay = 1000L;
    private long period = 1000L;

    public abstract NamingService getNamingService();

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    protected abstract void reInit(String var1, List<RegisterInfo> var2) throws Exception;

    protected void startUpdateNamingServiceTask(Map<String, List<RegisterInfo>> serviceMap) {
        if (this.getNamingService() == null) {
            return;
        }
        this.timer = new Timer(true);
        this.updateListTask = new UpdateNamingServiceTask(this, serviceMap);
        this.timer.scheduleAtFixedRate(this.updateListTask, this.delay, this.period);
    }

    public void close() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private final class UpdateNamingServiceTask
    extends TimerTask {
        NamingServiceChangeListener loadBalancer;
        private Map<String, List<RegisterInfo>> serviceMap;

        public UpdateNamingServiceTask(NamingServiceChangeListener loadBalancer, Map<String, List<RegisterInfo>> serviceMap) {
            this.loadBalancer = loadBalancer;
            this.serviceMap = new HashMap<String, List<RegisterInfo>>();
            for (Map.Entry<String, List<RegisterInfo>> entry : serviceMap.entrySet()) {
                List<RegisterInfo> list = entry.getValue();
                if (list == null) {
                    list = new ArrayList<RegisterInfo>();
                }
                this.serviceMap.put(entry.getKey(), new ArrayList<RegisterInfo>(list));
            }
        }

        @Override
        public void run() {
            try {
                Set<String> serviceNames = this.serviceMap.keySet();
                Map<String, List<Object>> eServcieMap = this.loadBalancer.getNamingService().list(serviceNames);
                if (eServcieMap == null) {
                    eServcieMap = Collections.emptyMap();
                }
                for (Map.Entry<String, List<RegisterInfo>> next : this.serviceMap.entrySet()) {
                    List<Object> newList;
                    String service = next.getKey();
                    List<Object> oldList = next.getValue();
                    if (oldList == null) {
                        oldList = Collections.emptyList();
                    }
                    if ((newList = eServcieMap.get(service)) == null) {
                        newList = Collections.emptyList();
                    }
                    if (oldList.equals(newList)) continue;
                    LOG.log(Level.WARNING, "A new changed list geting from naming service name='" + service + "' value=" + newList);
                    ArrayList<Object> list = new ArrayList<Object>(newList);
                    next.setValue(list);
                    NamingServiceChangeListener.this.reInit(service, list);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, e.getMessage(), e.getCause());
            }
        }
    }
}

