/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.client.ha.lb.failover;

import com.baidu.jprotobuf.pbrpc.client.ha.lb.LoadBalanceProxyFactoryBean;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.failover.FailOverInterceptor;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecoverHeartbeat
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(RecoverHeartbeat.class.getName());
    private LoadBalanceProxyFactoryBean proxyFactoryBean;
    private static final long DEFAULT_RECOVER_INTERVAL = 1000L;
    private static final long TOO_FREQUENT = 100L;
    private boolean runing;
    private boolean close = false;

    private long getRecoverInterval() {
        long recoverInterval = this.proxyFactoryBean.getRecoverInterval();
        if (recoverInterval <= 100L) {
            LOGGER.log(Level.WARNING, "failover recover interval " + recoverInterval + " is too frequent, using default:" + 1000L);
            recoverInterval = 1000L;
        }
        return recoverInterval;
    }

    public RecoverHeartbeat(LoadBalanceProxyFactoryBean proxyFactoryBean) {
        this.proxyFactoryBean = proxyFactoryBean;
    }

    public boolean isRuning() {
        return this.runing;
    }

    public void close() {
        this.close = true;
    }

    @Override
    public void run() {
        this.runing = true;
        LOGGER.info("start recover heart beat thread");
        FailOverInterceptor interceptor = this.proxyFactoryBean.getFailOverInterceptor();
        while (this.proxyFactoryBean.hasFactoryBeanFailed() && !this.close) {
            Map<String, LoadBalanceProxyFactoryBean.FactoryBeanInvokeInfo> failedBeans = this.proxyFactoryBean.getFailedFactoryBeans();
            if (failedBeans == null || failedBeans.isEmpty()) {
                return;
            }
            for (Map.Entry<String, LoadBalanceProxyFactoryBean.FactoryBeanInvokeInfo> entry : failedBeans.entrySet()) {
                boolean available;
                LoadBalanceProxyFactoryBean.FactoryBeanInvokeInfo invokeInfo = entry.getValue();
                try {
                    available = interceptor.isRecover(invokeInfo.getBean(), invokeInfo.getInvocation(), invokeInfo.getBeanKey());
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getMessage());
                    }
                    available = false;
                }
                if (available) {
                    this.proxyFactoryBean.recoverFactoryBean(entry.getKey());
                    LOGGER.info(invokeInfo.getBeanKey() + " recover heart beat test success!");
                    continue;
                }
                LOGGER.log(Level.WARNING, invokeInfo.getBeanKey() + " recover heart beat test failed!");
            }
            try {
                Thread.sleep(this.getRecoverInterval());
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, e.getMessage());
            }
        }
        this.runing = false;
        LOGGER.info("all heart beat test success. recover heart beat thread exit");
    }
}

