/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.client.ha.lb.failover;

import com.baidu.jprotobuf.pbrpc.client.ServiceUrlAccessible;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.failover.FailOverInterceptor;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketFailOverInterceptor
implements FailOverInterceptor {
    private static final Logger LOGGER = Logger.getLogger(SocketFailOverInterceptor.class.getName());

    @Override
    public boolean isAvailable(Object o, Method m, String beanKey) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRecover(Object o, Method m, String beanKey) {
        if (!(o instanceof ServiceUrlAccessible)) {
            LOGGER.log(Level.SEVERE, "Invalid target object to recover, should be implements '" + ServiceUrlAccessible.class.getName() + "'");
            return false;
        }
        String serviceUrl = ((ServiceUrlAccessible)o).getServiceUrl();
        Host host = this.parseHost(serviceUrl);
        if (host == null) {
            return false;
        }
        Socket socket = null;
        try {
            socket = new Socket(host.host, host.port);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Recover socket test for host '" + host.host + "' and port '" + host.port + "' failed. message:" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINEST, e.getMessage(), e.getCause());
            }
        }
        return true;
    }

    @Override
    public boolean isDoFailover(Throwable t, String beanKey) {
        return true;
    }

    protected Host parseHost(String serviceUrl) {
        if (StringUtils.isBlank((String)serviceUrl)) {
            return null;
        }
        String[] splits = serviceUrl.split(":");
        if (splits == null || splits.length != 2) {
            return null;
        }
        Host host = new Host();
        host.host = splits[0];
        host.port = StringUtils.toInt((String)splits[1]);
        return host;
    }

    private static class Host {
        public String host;
        public int port;

        private Host() {
        }
    }
}

