/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy;

import com.baidu.jprotobuf.pbrpc.client.ha.NamingService;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy.NamingServiceLoadBalanceStrategy;
import com.baidu.jprotobuf.pbrpc.registry.RegisterInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RoundRobinLoadBalanceStrategy
implements NamingServiceLoadBalanceStrategy {
    private static final int MIN_LB_FACTOR = 1;
    private List<String> targets;
    private int currentPos;
    private Map<String, Integer> currentTargets;
    private Map<String, Integer> failedTargets;
    private NamingService namingService;
    private static final int DEFAULT_LOAD_FACTOR = 1;
    private String serviceSignature;

    public NamingService getNamingService() {
        return this.namingService;
    }

    public RoundRobinLoadBalanceStrategy(String serviceSignature, NamingService namingService) {
        this.serviceSignature = serviceSignature;
        this.namingService = namingService;
        this.doReInit(this.serviceSignature, namingService);
    }

    public RoundRobinLoadBalanceStrategy(Map<String, Integer> lbFactors) {
        this.init(lbFactors);
    }

    protected void init(List<RegisterInfo> servers) {
        Map<String, Integer> lbFactors = this.parseLbFactors(servers);
        this.init(lbFactors);
    }

    private Map<String, Integer> parseLbFactors(List<RegisterInfo> servers) {
        HashMap<String, Integer> lbFactors = new HashMap<String, Integer>();
        if (servers == null) {
            return lbFactors;
        }
        for (RegisterInfo address : servers) {
            String serviceUrl = address.getHost() + ":" + address.getPort();
            lbFactors.put(serviceUrl, 1);
        }
        return lbFactors;
    }

    protected synchronized void init(Map<String, Integer> lbFactors) {
        this.currentTargets = Collections.synchronizedMap(lbFactors);
        this.failedTargets = Collections.synchronizedMap(new HashMap(this.currentTargets.size()));
        this.reInitTargets(this.currentTargets);
    }

    private void reInitTargets(Map<String, Integer> lbFactors) {
        this.targets = this.initTargets(lbFactors);
        this.currentPos = 0;
    }

    @Override
    public synchronized String elect() {
        if (this.targets == null || this.targets.isEmpty()) {
            throw new RuntimeException("no target is available");
        }
        if (this.currentPos >= this.targets.size()) {
            this.currentPos = 0;
        }
        return this.targets.get(this.currentPos++);
    }

    @Override
    public synchronized Set<String> getTargets() {
        if (this.targets == null) {
            return new HashSet<String>(0);
        }
        return new HashSet<String>(this.targets);
    }

    public List<String> initTargets(Map<String, Integer> lbFactors) {
        if (lbFactors == null || lbFactors.size() == 0) {
            return null;
        }
        if (lbFactors.size() == 1) {
            return new ArrayList<String>(lbFactors.keySet());
        }
        this.fixFactor(lbFactors);
        Collection<Integer> factors = lbFactors.values();
        int min = Collections.min(factors);
        if (min > 1) {
            List<Integer> divisors = this.getDivisors(min);
            int maxDivisor = this.getMaxDivisor(divisors, factors);
            return this.buildBalanceTargets(lbFactors, maxDivisor);
        }
        return this.buildBalanceTargets(lbFactors, 1);
    }

    private int getMaxDivisor(List<Integer> divisors, Collection<Integer> factors) {
        for (Integer divisor : divisors) {
            if (!this.canModAll(divisor, factors)) continue;
            return divisor;
        }
        return 1;
    }

    private List<Integer> getDivisors(int value) {
        int count;
        if (value <= 1) {
            return Collections.emptyList();
        }
        ArrayList<Integer> divisors = new ArrayList<Integer>(count + 1);
        divisors.add(value);
        for (count = value / 2; count > 0; --count) {
            if (value % count != 0) continue;
            divisors.add(count);
        }
        return divisors;
    }

    private void fixFactor(Map<String, Integer> lbFactors) {
        Set<Map.Entry<String, Integer>> setEntries = lbFactors.entrySet();
        for (Map.Entry<String, Integer> entry : setEntries) {
            if (entry.getValue() >= 1) continue;
            entry.setValue(1);
        }
    }

    private boolean canModAll(int base, Collection<Integer> factors) {
        for (Integer integer : factors) {
            if (integer % base == 0) continue;
            return false;
        }
        return true;
    }

    private List<String> buildBalanceTargets(Map<String, Integer> lbFactors, int baseFactor) {
        Set<Map.Entry<String, Integer>> setEntries = lbFactors.entrySet();
        LinkedList<String> targets = new LinkedList<String>();
        for (Map.Entry<String, Integer> entry : setEntries) {
            int factor = entry.getValue() / baseFactor;
            for (int i = 0; i < factor; ++i) {
                targets.add(entry.getKey());
            }
        }
        return targets;
    }

    @Override
    public synchronized void removeTarget(String key) {
        if (this.currentTargets.containsKey(key)) {
            this.failedTargets.put(key, this.currentTargets.get(key));
            this.currentTargets.remove(key);
            this.reInitTargets(this.currentTargets);
        }
    }

    @Override
    public synchronized void recoverTarget(String key) {
        if (this.failedTargets.containsKey(key)) {
            this.currentTargets.put(key, this.failedTargets.get(key));
            this.failedTargets.remove(key);
            this.reInitTargets(this.currentTargets);
        }
    }

    @Override
    public boolean hasTargets() {
        return this.getTargets() != null && !this.getTargets().isEmpty();
    }

    @Override
    public Set<String> getFailedTargets() {
        return this.failedTargets.keySet();
    }

    @Override
    public void doReInit(String serviceSignagure, NamingService namingService) {
        List<RegisterInfo> servers;
        HashSet<String> serviceSignatures = new HashSet<String>();
        serviceSignatures.add(serviceSignagure);
        try {
            servers = namingService.list(serviceSignatures).get(serviceSignagure);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.init(servers);
    }
}

