/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.spring;

import com.baidu.jprotobuf.pbrpc.RpcHandler;
import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.registry.RegisterInfo;
import com.baidu.jprotobuf.pbrpc.registry.RegistryCenterService;
import com.baidu.jprotobuf.pbrpc.server.RpcServiceRegistry;
import com.baidu.jprotobuf.pbrpc.spring.RpcServiceRegistryBean;
import com.baidu.jprotobuf.pbrpc.transport.ExceptionCatcher;
import com.baidu.jprotobuf.pbrpc.transport.RpcServer;
import com.baidu.jprotobuf.pbrpc.transport.RpcServerOptions;
import com.baidu.jprotobuf.pbrpc.utils.NetUtils;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RpcServiceExporter
extends RpcServerOptions
implements InitializingBean,
DisposableBean {
    private RpcServer prRpcServer;
    private int servicePort;
    private String host;
    private List<Object> registerServices;
    private RpcServiceRegistryBean rpcServiceRegistryBean;
    private RegistryCenterService registryCenterService;
    private List<RegisterInfo> cachedRisterInfoList;
    private InvokerInterceptor interceptor;
    private ExceptionCatcher exceptionCatcher;

    public void setExceptionCatcher(ExceptionCatcher exceptionCatcher) {
        this.exceptionCatcher = exceptionCatcher;
    }

    public void setInterceptor(InvokerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setRegistryCenterService(RegistryCenterService registryCenterService) {
        this.registryCenterService = registryCenterService;
    }

    public void setRpcServiceRegistryBean(RpcServiceRegistryBean rpcServiceRegistryBean) {
        this.rpcServiceRegistryBean = rpcServiceRegistryBean;
    }

    public List<Object> getRegisterServices() {
        return this.registerServices;
    }

    public void setRegisterServices(List<Object> registerServices) {
        this.registerServices = registerServices;
    }

    protected int getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    protected String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void destroy() throws Exception {
        if (this.prRpcServer != null) {
            this.prRpcServer.shutdown();
        }
        if (this.registryCenterService != null && this.cachedRisterInfoList != null) {
            for (RegisterInfo registerInfo : this.cachedRisterInfoList) {
                this.registryCenterService.unregister(registerInfo);
            }
        }
        if (this.rpcServiceRegistryBean != null) {
            this.rpcServiceRegistryBean.unRegisterAll();
        }
    }

    public void afterPropertiesSet() throws Exception {
        String registerHost;
        Assert.isTrue((this.servicePort > 0 ? 1 : 0) != 0, (String)("invalid service port: " + this.servicePort));
        Assert.isTrue((!CollectionUtils.isEmpty(this.registerServices) ? 1 : 0) != 0, (String)"No register service specified.");
        if (this.rpcServiceRegistryBean == null) {
            this.rpcServiceRegistryBean = new RpcServiceRegistryBean();
        }
        this.prRpcServer = new RpcServer((RpcServerOptions)this, (RpcServiceRegistry)this.rpcServiceRegistryBean);
        this.prRpcServer.setInterceptor(this.interceptor);
        this.prRpcServer.setExceptionCatcher(this.exceptionCatcher);
        for (Object service : this.registerServices) {
            this.prRpcServer.registerService(service);
        }
        if (StringUtils.isBlank((String)this.host)) {
            this.prRpcServer.start(new InetSocketAddress(this.servicePort));
            registerHost = NetUtils.getLocalAddress().getHostAddress();
        } else {
            this.prRpcServer.start(new InetSocketAddress(this.host, this.servicePort));
            registerHost = this.host;
        }
        if (this.registryCenterService != null) {
            this.cachedRisterInfoList = new ArrayList<RegisterInfo>();
            Collection services = this.rpcServiceRegistryBean.getServices();
            ArrayList list = new ArrayList(services);
            for (RpcHandler rpcHandler : list) {
                RegisterInfo registerInfo = new RegisterInfo();
                registerInfo.setHost(registerHost);
                registerInfo.setPort(this.servicePort);
                registerInfo.setProtocol("pbrpc");
                registerInfo.setService(rpcHandler.getMethodSignature());
                this.registryCenterService.register(registerInfo);
                this.cachedRisterInfoList.add(registerInfo);
            }
        }
    }
}

