/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.client.ha;

import com.baidu.jprotobuf.pbrpc.ProtobufRPC;
import com.baidu.jprotobuf.pbrpc.client.ProtobufRpcProxy;
import com.baidu.jprotobuf.pbrpc.client.ha.NamingService;
import com.baidu.jprotobuf.pbrpc.client.ha.NamingServiceChangeListener;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.LoadBalanceProxyFactoryBean;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.failover.SocketFailOverInterceptor;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy.NamingServiceLoadBalanceStrategyFactory;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy.RRNamingServiceLoadBalanceStrategyFactory;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy.StrategyInterceptor;
import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.registry.RegisterInfo;
import com.baidu.jprotobuf.pbrpc.transport.ExceptionHandler;
import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.utils.ServiceSignatureUtils;
import com.baidu.jprotobuf.pbrpc.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.util.CollectionUtils;

public class HaProtobufRpcProxy<T>
extends NamingServiceChangeListener
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HaProtobufRpcProxy.class.getName());
    private final RpcClient rpcClient;
    private final Class<T> interfaceClass;
    private final NamingService namingService;
    private NamingServiceLoadBalanceStrategyFactory loadBalanceStrategyFactory;
    private SocketFailOverInterceptor failOverInterceptor;
    private T proxyInstance;
    private boolean lookupStubOnStartup = false;
    private Map<String, Object> instancesMap = new HashMap<String, Object>();
    private Map<String, LoadBalanceProxyFactoryBean> lbMap = new HashMap<String, LoadBalanceProxyFactoryBean>();
    private Map<String, List<ProtobufRpcProxy<T>>> protobufRpcProxyListMap = new HashMap<String, List<ProtobufRpcProxy<T>>>();
    private AtomicBoolean proxied = new AtomicBoolean(false);
    protected InvokerInterceptor interceptor;
    protected ExceptionHandler exceptionHandler;
    private StrategyInterceptor strategyInterceptor;
    private long heartBeatInterval = 1000L;

    public void setHeartBeatInterval(long heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
    }

    public void setStrategyInterceptor(StrategyInterceptor strategyInterceptor) {
        this.strategyInterceptor = strategyInterceptor;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setInterceptor(InvokerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public boolean isLookupStubOnStartup() {
        return this.lookupStubOnStartup;
    }

    public void setLookupStubOnStartup(boolean lookupStubOnStartup) {
        this.lookupStubOnStartup = lookupStubOnStartup;
    }

    public HaProtobufRpcProxy(RpcClient rpcClient, Class<T> interfaceClass, NamingService namingService) {
        this(rpcClient, interfaceClass, namingService, null, null);
    }

    public HaProtobufRpcProxy(RpcClient rpcClient, Class<T> interfaceClass, NamingService namingService, NamingServiceLoadBalanceStrategyFactory loadBalanceStrategyFactory, SocketFailOverInterceptor failOverInterceptor) {
        this.rpcClient = rpcClient;
        this.interfaceClass = interfaceClass;
        this.namingService = namingService;
        this.loadBalanceStrategyFactory = loadBalanceStrategyFactory;
        this.failOverInterceptor = failOverInterceptor;
        if (namingService == null) {
            throw new NullPointerException("param 'namingService' is null.");
        }
        ProxyFactory proxyFactory = new ProxyFactory(interfaceClass, (Interceptor)this);
        this.proxyInstance = proxyFactory.getProxy();
    }

    protected ProtobufRpcProxy<T> onBuildProtobufRpcProxy(RpcClient rpcClient, Class<T> interfaceClass) {
        ProtobufRpcProxy protobufRpcProxy = new ProtobufRpcProxy(rpcClient, interfaceClass);
        protobufRpcProxy.setInterceptor(this.interceptor);
        protobufRpcProxy.setExceptionHandler(this.exceptionHandler);
        return protobufRpcProxy;
    }

    public synchronized T proxy() throws Exception {
        if (this.proxied.compareAndSet(false, true)) {
            ProtobufRpcProxy<T> protobufRpcProxy = this.onBuildProtobufRpcProxy(this.rpcClient, this.interfaceClass);
            Map<String, List<RegisterInfo>> servers = this.namingService.list(protobufRpcProxy.getServiceSignatures());
            this.startUpdateNamingServiceTask(servers);
            this.createServiceProxy(servers);
        }
        return this.proxyInstance;
    }

    private void createServiceProxy(Map<String, List<RegisterInfo>> servers) throws Exception {
        for (Map.Entry<String, List<RegisterInfo>> next : servers.entrySet()) {
            this.doProxy(next.getKey(), next.getValue());
        }
    }

    private void doProxy(String service, List<RegisterInfo> serversList) throws Exception {
        long current = System.currentTimeMillis();
        List<RegisterInfo> servers = serversList;
        if (CollectionUtils.isEmpty(servers)) {
            servers = new ArrayList<RegisterInfo>();
        }
        LOGGER.info("Begin: proxy service [" + service + "] for target servicesList of size:" + servers.size());
        LoadBalanceProxyFactoryBean lbProxyBean = new LoadBalanceProxyFactoryBean();
        lbProxyBean.setStrategyInterceptor(this.strategyInterceptor);
        lbProxyBean.setServiceInterface(this.interfaceClass);
        lbProxyBean.setRecoverInterval(this.heartBeatInterval);
        ArrayList<ProtobufRpcProxy<T>> protobufRpcProxyList = new ArrayList<ProtobufRpcProxy<T>>();
        HashMap<String, String> serverUrls = new HashMap<String, String>(servers.size());
        HashMap<String, Object> targetBeans = new HashMap<String, Object>();
        for (RegisterInfo address : servers) {
            String serviceUrl = address.getHost() + ":" + address.getPort();
            if (serverUrls.containsKey(serviceUrl)) continue;
            serverUrls.put(serviceUrl, serviceUrl);
            ProtobufRpcProxy<T> protobufRpcProxy = this.onBuildProtobufRpcProxy(this.rpcClient, this.interfaceClass);
            protobufRpcProxy.setHost(address.getHost());
            protobufRpcProxy.setPort(address.getPort());
            protobufRpcProxy.setLookupStubOnStartup(this.lookupStubOnStartup);
            Object rpc = protobufRpcProxy.proxy();
            protobufRpcProxyList.add(protobufRpcProxy);
            targetBeans.put(serviceUrl, rpc);
        }
        if (this.loadBalanceStrategyFactory == null) {
            this.loadBalanceStrategyFactory = new RRNamingServiceLoadBalanceStrategyFactory();
        }
        lbProxyBean.setLoadBalanceStrategy(this.loadBalanceStrategyFactory.create(service, this.namingService));
        if (this.failOverInterceptor == null) {
            SocketFailOverInterceptor socketFailOverInterceptor = new SocketFailOverInterceptor();
            lbProxyBean.setFailOverInterceptor(socketFailOverInterceptor);
        } else {
            lbProxyBean.setFailOverInterceptor(this.failOverInterceptor);
        }
        lbProxyBean.setTargetBeans(targetBeans);
        lbProxyBean.afterPropertiesSet();
        this.protobufRpcProxyListMap.put(service, protobufRpcProxyList);
        this.lbMap.put(service, lbProxyBean);
        this.instancesMap.put(service, lbProxyBean.getObject());
        LOGGER.info("Finished:proxy service [" + service + "] for target servicesList of size:" + servers.size() + " time took:" + (System.currentTimeMillis() - current) + " ms");
    }

    @Override
    public void close() {
        Collection<List<ProtobufRpcProxy<T>>> values = this.protobufRpcProxyListMap.values();
        for (List<ProtobufRpcProxy<T>> list : values) {
            this.doClose(null, list);
        }
        Collection<LoadBalanceProxyFactoryBean> lbs = this.lbMap.values();
        for (LoadBalanceProxyFactoryBean loadBalanceProxyFactoryBean : lbs) {
            this.doClose(loadBalanceProxyFactoryBean, null);
        }
        super.close();
    }

    private void doClose(LoadBalanceProxyFactoryBean lbProxyBean, List<ProtobufRpcProxy<T>> protobufRpcProxyList) {
        if (lbProxyBean != null) {
            try {
                lbProxyBean.destroy();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            lbProxyBean = null;
        }
        if (protobufRpcProxyList != null) {
            for (ProtobufRpcProxy<T> proxy : protobufRpcProxyList) {
                try {
                    proxy.close();
                    proxy = null;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            protobufRpcProxyList.clear();
        }
    }

    @Override
    public NamingService getNamingService() {
        return this.namingService;
    }

    @Override
    protected void reInit(String service, List<RegisterInfo> list) throws Exception {
        LoadBalanceProxyFactoryBean oldLbProxyBean = this.lbMap.get(service);
        ArrayList<ProtobufRpcProxy<T>> oldProtobufRpcProxyList = new ArrayList<ProtobufRpcProxy<T>>((Collection)this.protobufRpcProxyListMap.get(service));
        this.doProxy(service, list);
        try {
            this.doClose(oldLbProxyBean, oldProtobufRpcProxyList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodSignature;
        Object instance;
        Method method = invocation.getMethod();
        ProtobufRPC protobufPRC = method.getAnnotation(ProtobufRPC.class);
        if (protobufPRC == null) {
            throw new IllegalAccessError("Target method is not marked annotation @ProtobufPRC. method name :" + method.getDeclaringClass().getName() + "." + method.getName());
        }
        String serviceName = protobufPRC.serviceName();
        String methodName = protobufPRC.methodName();
        if (StringUtils.isEmpty((String)methodName)) {
            methodName = method.getName();
        }
        if ((instance = this.instancesMap.get(methodSignature = ServiceSignatureUtils.makeSignature((String)serviceName, (String)methodName))) == null) {
            throw new NullPointerException("target instance is null may be not initial correct.");
        }
        Object result = invocation.getMethod().invoke(instance, invocation.getArguments());
        return result;
    }
}

