/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.spring;

import com.baidu.jprotobuf.pbrpc.client.ha.NamingService;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.failover.SocketFailOverInterceptor;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy.NamingServiceLoadBalanceStrategyFactory;
import com.baidu.jprotobuf.pbrpc.client.ha.lb.strategy.StrategyInterceptor;
import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.spring.HaProtobufRpcProxyBean;
import com.baidu.jprotobuf.pbrpc.transport.ExceptionHandler;
import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientOptions;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class HaRpcProxyFactoryBean
extends RpcClientOptions
implements FactoryBean,
InitializingBean,
MethodInterceptor,
DisposableBean {
    private Class<Object> serviceInterface;
    private HaProtobufRpcProxyBean<Object> pbrpcProxy;
    private Object serviceProxy;
    private RpcClient rpcClient;
    private NamingService namingService;
    private NamingServiceLoadBalanceStrategyFactory namingServiceLoadBalanceStrategyFactory;
    private SocketFailOverInterceptor failOverInterceptor;
    private InvokerInterceptor interceptor;
    private ExceptionHandler exceptionHandler;
    private StrategyInterceptor strategyInterceptor;
    private long heartBeatInterval = 1000L;
    private boolean lookupStubOnStartup = true;

    public void setHeartBeatInterval(long heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
    }

    public void setStrategyInterceptor(StrategyInterceptor strategyInterceptor) {
        this.strategyInterceptor = strategyInterceptor;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setInterceptor(InvokerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public boolean isLookupStubOnStartup() {
        return this.lookupStubOnStartup;
    }

    public void setLookupStubOnStartup(boolean lookupStubOnStartup) {
        this.lookupStubOnStartup = lookupStubOnStartup;
    }

    public void setNamingService(NamingService namingService) {
        this.namingService = namingService;
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("'serviceInterface' must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class getObjectType() {
        return this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.namingService, (String)"property 'namingService' is null.");
        this.rpcClient = new RpcClient((RpcClientOptions)this);
        this.pbrpcProxy = new HaProtobufRpcProxyBean<Object>(this.rpcClient, this.serviceInterface, this.namingService, this.namingServiceLoadBalanceStrategyFactory, this.failOverInterceptor);
        this.pbrpcProxy.setLookupStubOnStartup(this.lookupStubOnStartup);
        this.pbrpcProxy.setInterceptor(this.interceptor);
        this.pbrpcProxy.setExceptionHandler(this.exceptionHandler);
        this.pbrpcProxy.setStrategyInterceptor(this.strategyInterceptor);
        this.pbrpcProxy.setHeartBeatInterval(this.heartBeatInterval);
        this.pbrpcProxy.proxy();
        ProxyFactory proxyFactory = new ProxyFactory(this.getServiceInterface(), (Interceptor)this);
        this.serviceProxy = proxyFactory.getProxy();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        return this.pbrpcProxy.invoke(invocation);
    }

    public void destroy() throws Exception {
        if (this.pbrpcProxy != null) {
            this.pbrpcProxy.close();
        }
        if (this.rpcClient != null) {
            this.rpcClient.stop();
        }
    }

    public void setNamingServiceLoadBalanceStrategyFactory(NamingServiceLoadBalanceStrategyFactory namingServiceLoadBalanceStrategyFactory) {
        this.namingServiceLoadBalanceStrategyFactory = namingServiceLoadBalanceStrategyFactory;
    }

    public void setFailOverInterceptor(SocketFailOverInterceptor failOverInterceptor) {
        this.failOverInterceptor = failOverInterceptor;
    }
}

