/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.jprotobuf.pbrpc.spring;

import com.baidu.jprotobuf.pbrpc.intercept.InvokerInterceptor;
import com.baidu.jprotobuf.pbrpc.spring.ProtobufRpcProxyBean;
import com.baidu.jprotobuf.pbrpc.transport.RpcClient;
import com.baidu.jprotobuf.pbrpc.transport.RpcClientOptions;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RpcProxyFactoryBean
extends RpcClientOptions
implements FactoryBean,
InitializingBean,
MethodInterceptor,
DisposableBean {
    private Class serviceInterface;
    private String host;
    private int port;
    private ProtobufRpcProxyBean pbrpcProxy;
    private Object serviceProxy;
    private RpcClient rpcClient;
    private boolean lookupStubOnStartup = true;
    private InvokerInterceptor interceptor;
    private Object proxy;

    public void setInterceptor(InvokerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public boolean isLookupStubOnStartup() {
        return this.lookupStubOnStartup;
    }

    public void setLookupStubOnStartup(boolean lookupStubOnStartup) {
        this.lookupStubOnStartup = lookupStubOnStartup;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("'serviceInterface' must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class getObjectType() {
        return this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.port > 0 ? 1 : 0) != 0, (String)("invalid service port: " + this.port));
        this.rpcClient = new RpcClient((RpcClientOptions)this);
        this.pbrpcProxy = new ProtobufRpcProxyBean(this.rpcClient, this.serviceInterface);
        this.pbrpcProxy.setPort(this.port);
        this.pbrpcProxy.setHost(this.host);
        this.pbrpcProxy.setLookupStubOnStartup(this.lookupStubOnStartup);
        this.pbrpcProxy.setInterceptor(this.interceptor);
        this.proxy = this.pbrpcProxy.proxy();
        this.pbrpcProxy.setProxyBean(this.proxy);
        ProxyFactory proxyFactory = new ProxyFactory(this.getServiceInterface(), (Interceptor)this);
        this.serviceProxy = proxyFactory.getProxy();
    }

    public Object getProxyBean() {
        return this.proxy;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        return this.pbrpcProxy.invoke(invocation);
    }

    public void destroy() throws Exception {
        if (this.pbrpcProxy != null) {
            this.pbrpcProxy.close();
        }
        if (this.rpcClient != null) {
            this.rpcClient.stop();
        }
    }
}

