/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.blob;

import com.baremaps.blob.BlobStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBlobStore
extends BlobStore {
    private static Logger logger = LoggerFactory.getLogger(FileBlobStore.class);

    @Override
    public boolean accept(URI uri) {
        return uri.getScheme() == null && uri.getHost() == null && uri.getPath() != null;
    }

    @Override
    public Path fetch(URI uri) {
        return Paths.get(uri.getPath(), new String[0]).toAbsolutePath();
    }

    @Override
    public InputStream read(URI uri) throws IOException {
        logger.debug("Read {}", (Object)uri);
        return Files.newInputStream(Paths.get(uri.getPath(), new String[0]).toAbsolutePath(), new OpenOption[0]);
    }

    @Override
    public byte[] readByteArray(URI uri) throws IOException {
        logger.debug("Read {}", (Object)uri);
        return Files.readAllBytes(Paths.get(uri.getPath(), new String[0]).toAbsolutePath());
    }

    @Override
    public OutputStream write(URI uri) throws IOException {
        logger.debug("Write {}", (Object)uri);
        Path path = Paths.get(uri.getPath(), new String[0]).toAbsolutePath();
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        return Files.newOutputStream(Paths.get(uri.getPath(), new String[0]), new OpenOption[0]);
    }

    @Override
    public void writeByteArray(URI uri, byte[] bytes) throws IOException {
        logger.debug("Write {}", (Object)uri);
        Path path = Paths.get(uri.getPath(), new String[0]).toAbsolutePath();
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.write(path, bytes, new OpenOption[0]);
    }

    @Override
    public void delete(URI uri) throws IOException {
        logger.debug("Delete {}", (Object)uri);
        Files.deleteIfExists(Paths.get(uri.getPath(), new String[0]).toAbsolutePath());
    }
}

