/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.blob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobStore {
    private static Logger logger = LoggerFactory.getLogger(BlobStore.class);
    private final Map<URI, Path> cache = new HashMap<URI, Path>();

    protected Path cache(URI uri) throws IOException {
        if (!this.cache.containsKey(uri)) {
            String fileName = Paths.get(uri.getPath(), new String[0]).getFileName().toString();
            File tmpFile = File.createTempFile("baremaps_", "_" + fileName);
            logger.debug("Cache {} in {}", (Object)uri, (Object)tmpFile);
            try (InputStream input = this.read(uri);){
                tmpFile.deleteOnExit();
                Files.copy(input, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.cache.put(uri, tmpFile.toPath());
            }
        }
        return this.cache.get(uri);
    }

    public abstract boolean accept(URI var1);

    public abstract Path fetch(URI var1) throws IOException;

    public abstract InputStream read(URI var1) throws IOException;

    public abstract byte[] readByteArray(URI var1) throws IOException;

    public abstract OutputStream write(URI var1) throws IOException;

    public abstract void writeByteArray(URI var1, byte[] var2) throws IOException;

    public abstract void delete(URI var1) throws IOException;
}

