/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.blob;

import com.baremaps.blob.BlobStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CompositeBlobStore
extends BlobStore {
    private final List<BlobStore> components;

    public CompositeBlobStore(BlobStore ... components) {
        this(Arrays.asList(components));
    }

    public CompositeBlobStore(List<BlobStore> components) {
        this.components = components;
    }

    private Optional<BlobStore> findFileSystem(URI uri) {
        return this.components.stream().filter(fileStore -> fileStore.accept(uri)).findFirst();
    }

    @Override
    public boolean accept(URI uri) {
        return this.findFileSystem(uri).isPresent();
    }

    @Override
    public Path fetch(URI uri) throws IOException {
        Optional<BlobStore> fileStore = this.findFileSystem(uri);
        if (fileStore.isPresent()) {
            return fileStore.get().fetch(uri);
        }
        throw new IOException("Unsupported URI: " + uri);
    }

    @Override
    public InputStream read(URI uri) throws IOException {
        Optional<BlobStore> fileStore = this.findFileSystem(uri);
        if (fileStore.isPresent()) {
            return fileStore.get().read(uri);
        }
        throw new IOException("Unsupported URI: " + uri);
    }

    @Override
    public byte[] readByteArray(URI uri) throws IOException {
        Optional<BlobStore> fileStore = this.findFileSystem(uri);
        if (fileStore.isPresent()) {
            return fileStore.get().readByteArray(uri);
        }
        throw new IOException("Unsupported URI: " + uri);
    }

    @Override
    public OutputStream write(URI uri) throws IOException {
        Optional<BlobStore> fileSystem = this.findFileSystem(uri);
        if (fileSystem.isPresent()) {
            return fileSystem.get().write(uri);
        }
        throw new IOException("Unsupported URI: " + uri);
    }

    @Override
    public void writeByteArray(URI uri, byte[] bytes) throws IOException {
        Optional<BlobStore> fileSystem = this.findFileSystem(uri);
        if (!fileSystem.isPresent()) {
            throw new IOException("Unsupported URI: " + uri);
        }
        fileSystem.get().writeByteArray(uri, bytes);
    }

    @Override
    public void delete(URI uri) throws IOException {
        Optional<BlobStore> fileStore = this.findFileSystem(uri);
        if (!fileStore.isPresent()) {
            throw new IOException("Unsupported URI: " + uri);
        }
        fileStore.get().delete(uri);
    }
}

