/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.blob;

import com.baremaps.blob.BlobStore;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBlobStore
extends BlobStore {
    private static Logger logger = LoggerFactory.getLogger(HttpBlobStore.class);
    private final String contentEncoding;
    private final String contentType;

    public HttpBlobStore() {
        this("utf-8", "application/octet-stream");
    }

    public HttpBlobStore(String contentEncoding, String contentType) {
        this.contentEncoding = contentEncoding;
        this.contentType = contentType;
    }

    @Override
    public boolean accept(URI uri) {
        return ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) && uri.getHost() != null && uri.getPath() != null;
    }

    @Override
    public Path fetch(URI uri) throws IOException {
        return this.cache(uri);
    }

    @Override
    public InputStream read(URI uri) throws IOException {
        logger.info("Read {}", (Object)uri);
        HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        return new BufferedInputStream(conn.getInputStream());
    }

    @Override
    public byte[] readByteArray(URI uri) throws IOException {
        logger.info("Read {}", (Object)uri);
        HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        try (InputStream inputStream = conn.getInputStream();){
            byte[] byArray = ByteStreams.toByteArray((InputStream)inputStream);
            return byArray;
        }
    }

    @Override
    public OutputStream write(final URI uri) {
        logger.info("Write {}", (Object)uri);
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                byte[] bytes = this.toByteArray();
                HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
                conn.setDoOutput(true);
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("Content-Type", HttpBlobStore.this.contentType);
                conn.setRequestProperty("Content-Encoding", HttpBlobStore.this.contentEncoding);
                conn.setRequestProperty("Content-Length", String.valueOf(bytes.length));
                try (OutputStream outputStream = conn.getOutputStream();
                     ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
        };
    }

    @Override
    public void writeByteArray(URI uri, byte[] bytes) throws IOException {
        logger.info("Write {}", (Object)uri);
        HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Content-Type", this.contentType);
        conn.setRequestProperty("Content-Encoding", this.contentEncoding);
        conn.setRequestProperty("Content-Length", String.valueOf(bytes.length));
        try (OutputStream outputStream = conn.getOutputStream();
             ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    @Override
    public void delete(URI uri) throws IOException {
        logger.info("Delete {}", (Object)uri);
        HttpURLConnection conn = (HttpURLConnection)uri.toURL().openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("DELETE");
        conn.getInputStream();
    }
}

