/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.blob;

import com.baremaps.blob.BlobStore;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBlobStore
extends BlobStore {
    private static final String SCHEMA = "res://";
    private static Logger logger = LoggerFactory.getLogger(ResourceBlobStore.class);

    @Override
    public boolean accept(URI uri) {
        return uri.toString().startsWith(SCHEMA) && uri.getPath() != null;
    }

    @Override
    public Path fetch(URI uri) {
        String path = this.path(uri);
        System.out.println(path);
        logger.debug("Read {}", (Object)path);
        return Paths.get(path, new String[0]);
    }

    @Override
    public InputStream read(URI uri) throws IOException {
        String path = this.path(uri);
        logger.debug("Read {}", (Object)path);
        return Resources.asByteSource((URL)Resources.getResource((String)path)).openStream();
    }

    @Override
    public byte[] readByteArray(URI uri) throws IOException {
        String path = this.path(uri);
        logger.debug("Read {}", (Object)path);
        return Resources.toByteArray((URL)Resources.getResource((String)path));
    }

    private String path(URI uri) {
        return uri.toString().replace(SCHEMA, "");
    }

    @Override
    public OutputStream write(URI uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeByteArray(URI uri, byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(URI uri) {
        throw new UnsupportedOperationException();
    }
}

