/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.iploc;

import com.baremaps.collection.utils.FileUtils;
import com.baremaps.geocoder.Geocoder;
import com.baremaps.geocoder.geonames.GeonamesGeocoder;
import com.baremaps.iploc.IpLoc;
import com.baremaps.iploc.data.InetnumLocation;
import com.baremaps.iploc.data.Ipv4Range;
import com.baremaps.iploc.data.Location;
import com.baremaps.iploc.database.InetnumLocationDao;
import com.baremaps.iploc.database.InetnumLocationDaoSqliteImpl;
import com.baremaps.iploc.database.SqliteUtils;
import com.baremaps.iploc.nic.NicData;
import com.baremaps.iploc.nic.NicObject;
import com.baremaps.testing.TestFiles;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class IpLocTest {
    private static List<NicObject> nicObjects;
    private static IpLoc ipLoc;
    private static InetnumLocationDao inetnumLocationDao;
    private static Path directory;
    private static String databaseUrl;

    IpLocTest() {
    }

    @BeforeAll
    public static void beforeAll() throws IOException, URISyntaxException {
        nicObjects = NicData.sample("ripe/simple_nic_sample.txt");
        directory = Files.createTempDirectory(Paths.get(".", new String[0]), "geocoder_", new FileAttribute[0]);
        Path data = TestFiles.resolve((String)"geonames/geocoder_sample.txt");
        GeonamesGeocoder geocoder = new GeonamesGeocoder(directory, data);
        geocoder.build();
        databaseUrl = String.format("JDBC:sqlite:%s", directory.resolve("test.db"));
        ipLoc = new IpLoc(databaseUrl, (Geocoder)geocoder);
        inetnumLocationDao = new InetnumLocationDaoSqliteImpl(databaseUrl);
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteRecursively((Path)directory);
    }

    @BeforeEach
    public void beforeEach() throws IOException, URISyntaxException, SQLException {
        SqliteUtils.executeResource((String)databaseUrl, (String)"iploc_init.sql");
    }

    @Test
    void findAll() {
        ipLoc.insertNicObjects(nicObjects.stream());
        List inetnumLocations = inetnumLocationDao.findAll();
        Assertions.assertEquals((int)7, (int)inetnumLocations.size());
    }

    @Test
    void findByIpWithZeroes() {
        ipLoc.insertNicObjects(nicObjects.stream());
        List inetnumLocations = inetnumLocationDao.findByIp(new Ipv4Range("0.0.0.5/32").getStart());
        Assertions.assertEquals((int)4, (int)inetnumLocations.size());
    }

    @Test
    void findByIp() {
        ipLoc.insertNicObjects(nicObjects.stream());
        List inetnumLocations = inetnumLocationDao.findByIp(new Ipv4Range("255.22.22.2/32").getStart());
        Assertions.assertEquals((int)1, (int)inetnumLocations.size());
    }

    @Test
    void save() {
        inetnumLocationDao.save((Object)new InetnumLocation("Test", new Ipv4Range("192.168.0.0/24"), new Location(1.0, 1.0), "Test", null));
        List getAllInetnumLocations = inetnumLocationDao.findAll();
        Assertions.assertEquals((int)1, (int)getAllInetnumLocations.size());
    }

    @Test
    void saveMultiple() {
        ArrayList<InetnumLocation> inetnumLocations = new ArrayList<InetnumLocation>();
        for (int i = 0; i < 30; ++i) {
            inetnumLocations.add(new InetnumLocation("Test", new Ipv4Range("192.168.0.0/24"), new Location(1.0, 1.0), "Test", null));
        }
        inetnumLocationDao.save(inetnumLocations);
        List getAllInetnumLocations = inetnumLocationDao.findAll();
        Assertions.assertEquals((int)30, (int)getAllInetnumLocations.size());
    }
}

