/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.iploc;

import com.baremaps.iploc.data.Ipv4Range;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Ipv4RangeTest {
    Ipv4RangeTest() {
    }

    @Test
    void testRange() {
        Ipv4Range ipv4Range = new Ipv4Range("0.0.0.0 - 0.0.0.255");
        Assertions.assertArrayEquals((byte[])ipv4Range.getStart(), (byte[])new byte[]{0, 0, 0, 0});
        Assertions.assertArrayEquals((byte[])ipv4Range.getEnd(), (byte[])new byte[]{0, 0, 0, -1});
    }

    @Test
    void testRangeWithMask() {
        Ipv4Range ipv4Range = new Ipv4Range("0.0.0.0/24");
        Assertions.assertArrayEquals((byte[])ipv4Range.getStart(), (byte[])new byte[]{0, 0, 0, 0});
        Assertions.assertArrayEquals((byte[])ipv4Range.getEnd(), (byte[])new byte[]{0, 0, 0, -1});
    }

    @Test
    void testRangeMaxValue() {
        Ipv4Range ipv4Range = new Ipv4Range("255.255.255.0 - 255.255.255.255");
        Assertions.assertArrayEquals((byte[])ipv4Range.getStart(), (byte[])new byte[]{-1, -1, -1, 0});
        Assertions.assertArrayEquals((byte[])ipv4Range.getEnd(), (byte[])new byte[]{-1, -1, -1, -1});
    }

    @Test
    void testRangeWithMaxMask() {
        Ipv4Range ipv4Range = new Ipv4Range("255.255.255.0/24");
        Assertions.assertArrayEquals((byte[])ipv4Range.getStart(), (byte[])new byte[]{-1, -1, -1, 0});
        Assertions.assertArrayEquals((byte[])ipv4Range.getEnd(), (byte[])new byte[]{-1, -1, -1, -1});
    }
}

