/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.iploc.nic;

import com.baremaps.iploc.nic.NicData;
import com.baremaps.iploc.nic.NicObject;
import java.io.IOException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class NicObjectTest {
    private List<NicObject> nicObjects;

    NicObjectTest() {
    }

    @BeforeEach
    public void before() throws IOException {
        this.nicObjects = NicData.sample("ripe/sample.txt");
    }

    @Test
    void type() {
        Assertions.assertEquals((Object)"organisation", (Object)this.nicObjects.get(0).type());
        Assertions.assertEquals((Object)"mntner", (Object)this.nicObjects.get(1).type());
        Assertions.assertEquals((Object)"organisation", (Object)this.nicObjects.get(2).type());
        Assertions.assertEquals((Object)"inetnum", (Object)this.nicObjects.get(3).type());
    }

    @Test
    void id() {
        Assertions.assertEquals((Object)"ORG-HEDI1-RIPE", (Object)this.nicObjects.get(0).id());
        Assertions.assertEquals((Object)"ch-heig-vd-1-mnt", (Object)this.nicObjects.get(1).id());
        Assertions.assertEquals((Object)"ORG-VA29373-RIPE", (Object)this.nicObjects.get(2).id());
        Assertions.assertEquals((Object)"193.135.138.0 - 193.135.138.255", (Object)this.nicObjects.get(3).id());
    }

    @Test
    void attributes() {
        Assertions.assertEquals((int)21, (int)this.nicObjects.get(0).attributes().size());
        Assertions.assertEquals((int)15, (int)this.nicObjects.get(1).attributes().size());
        Assertions.assertEquals((int)18, (int)this.nicObjects.get(2).attributes().size());
        Assertions.assertEquals((int)23, (int)this.nicObjects.get(3).attributes().size());
    }

    @Test
    void first() {
        NicObject nicObject = this.nicObjects.get(0);
        Assertions.assertEquals((Object)"RIPE-NCC-HM-MNT", nicObject.first("mnt-by").get());
        Assertions.assertEquals((Object)"****************************", nicObject.first("remarks").get());
    }

    @Test
    void all() {
        NicObject nicObject = this.nicObjects.get(0);
        Assertions.assertEquals((int)2, (int)nicObject.all("mnt-by").size());
        Assertions.assertEquals((int)7, (int)nicObject.all("remarks").size());
    }
}

